/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.Format;
import jalview.util.QuickSort;
import jalview.util.SparseCount;
import java.util.List;

public class ResidueCount {
    private static final int TOUPPERCASE = -32;
    private static final String NUCS = "ACGNTU";
    private static final String AAS = "ACDEFGHIKLMNPQRSTUVWXY";
    static final int GAP_COUNT = 0;
    private static int[] NUC_INDEX;
    private static int[] AA_INDEX;
    private short[] counts;
    private int[] intCounts;
    private boolean useIntCounts;
    private SparseCount otherData;
    int maxCount;
    private boolean isNucleotide;

    public ResidueCount() {
        this(false);
    }

    public ResidueCount(boolean nucleotide) {
        this.isNucleotide = nucleotide;
        int charsToCount = nucleotide ? NUCS.length() : AAS.length();
        this.counts = new short[charsToCount + 1];
    }

    public ResidueCount(List<SequenceI> sequences) {
        this();
        for (SequenceI seq : sequences) {
            for (int i = 0; i < seq.getLength(); ++i) {
                this.add(seq.getCharAt(i));
            }
        }
    }

    public int add(char c) {
        char u = this.toUpperCase(c);
        int newValue = 0;
        int offset = this.getOffset(u);
        newValue = offset == 0 ? (Comparison.isGap(u) ? this.addGap() : this.addOtherCharacter(u)) : this.increment(offset);
        return newValue;
    }

    int increment(int offset) {
        int newValue = 0;
        if (this.useIntCounts) {
            newValue = this.intCounts[offset];
            this.intCounts[offset] = ++newValue;
        } else if (this.counts[offset] == Short.MAX_VALUE) {
            this.handleOverflow();
            newValue = this.intCounts[offset];
            this.intCounts[offset] = ++newValue;
        } else {
            newValue = this.counts[offset];
            this.counts[offset] = (short)(++newValue);
        }
        if (offset != 0) {
            this.maxCount = Math.max(this.maxCount, newValue);
        }
        return newValue;
    }

    synchronized void handleOverflow() {
        this.intCounts = new int[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            this.intCounts[i] = this.counts[i];
        }
        this.counts = null;
        this.useIntCounts = true;
    }

    int getOffset(char c) {
        int offset = 0;
        if ('A' <= c && c <= 'Z') {
            offset = this.isNucleotide ? NUC_INDEX[c - 65] : AA_INDEX[c - 65];
        }
        return offset;
    }

    protected char toUpperCase(char c) {
        char u = c;
        if ('a' <= c && c <= 'z') {
            u = (char)(c + -32);
        }
        return u;
    }

    int addOtherCharacter(char c) {
        if (this.otherData == null) {
            this.otherData = new SparseCount();
        }
        int newValue = this.otherData.add(c, 1);
        this.maxCount = Math.max(this.maxCount, newValue);
        return newValue;
    }

    void setOtherCharacter(char c, int value) {
        if (this.otherData == null) {
            this.otherData = new SparseCount();
        }
        this.otherData.put(c, value);
    }

    public int addGap() {
        int newValue = this.increment(0);
        return newValue;
    }

    boolean isCountingInts() {
        return this.useIntCounts;
    }

    public void put(char c, int count) {
        char u = this.toUpperCase(c);
        int offset = this.getOffset(u);
        if (offset == 0) {
            if (Comparison.isGap(u)) {
                this.set(0, count);
            } else {
                this.setOtherCharacter(u, count);
                this.maxCount = Math.max(this.maxCount, count);
            }
        } else {
            this.set(offset, count);
            this.maxCount = Math.max(this.maxCount, count);
        }
    }

    void set(int offset, int value) {
        if (this.useIntCounts) {
            this.intCounts[offset] = value;
        } else if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            this.handleOverflow();
            this.intCounts[offset] = value;
        } else {
            this.counts[offset] = (short)value;
        }
    }

    public int getCount(char c) {
        char u = this.toUpperCase(c);
        int offset = this.getOffset(u);
        if (offset == 0 && !Comparison.isGap(u)) {
            return this.otherData == null ? 0 : this.otherData.get(u);
        }
        return this.useIntCounts ? this.intCounts[offset] : this.counts[offset];
    }

    public int getGapCount() {
        return this.useIntCounts ? this.intCounts[0] : this.counts[0];
    }

    boolean isUsingOtherData() {
        return this.otherData != null;
    }

    public String getResiduesForCount(int count) {
        int i;
        if (count == 0) {
            return "";
        }
        StringBuilder modal = new StringBuilder();
        if (this.useIntCounts) {
            for (i = 1; i < this.intCounts.length; ++i) {
                if (this.intCounts[i] != count) continue;
                modal.append(this.isNucleotide ? NUCS.charAt(i - 1) : AAS.charAt(i - 1));
            }
        } else {
            for (i = 1; i < this.counts.length; ++i) {
                if (this.counts[i] != count) continue;
                modal.append(this.isNucleotide ? NUCS.charAt(i - 1) : AAS.charAt(i - 1));
            }
        }
        if (this.otherData != null) {
            for (i = 0; i < this.otherData.size(); ++i) {
                if (this.otherData.valueAt(i) != count) continue;
                modal.append((char)this.otherData.keyAt(i));
            }
        }
        return modal.toString();
    }

    public int getModalCount() {
        return this.maxCount;
    }

    public int size() {
        int size = 0;
        if (this.useIntCounts) {
            for (int i = 1; i < this.intCounts.length; ++i) {
                if (this.intCounts[i] <= 0) continue;
                ++size;
            }
        } else {
            for (int i = 1; i < this.counts.length; ++i) {
                if (this.counts[i] <= 0) continue;
                ++size;
            }
        }
        if (this.otherData != null) {
            size += this.otherData.size();
        }
        return size;
    }

    public SymbolCounts getSymbolCounts() {
        char symbol;
        int i;
        int size = this.size();
        char[] symbols = new char[size];
        int[] values = new int[size];
        int j = 0;
        if (this.useIntCounts) {
            for (i = 1; i < this.intCounts.length; ++i) {
                if (this.intCounts[i] <= 0) continue;
                symbols[j] = symbol = this.isNucleotide ? NUCS.charAt(i - 1) : AAS.charAt(i - 1);
                values[j] = this.intCounts[i];
                ++j;
            }
        } else {
            for (i = 1; i < this.counts.length; ++i) {
                if (this.counts[i] <= 0) continue;
                symbols[j] = symbol = this.isNucleotide ? NUCS.charAt(i - 1) : AAS.charAt(i - 1);
                values[j] = this.counts[i];
                ++j;
            }
        }
        if (this.otherData != null) {
            for (i = 0; i < this.otherData.size(); ++i) {
                symbols[j] = (char)this.otherData.keyAt(i);
                values[j] = this.otherData.valueAt(i);
                ++j;
            }
        }
        return new SymbolCounts(symbols, values);
    }

    public String getTooltip(int normaliseBy, int percentageDecPl) {
        SymbolCounts symbolCounts = this.getSymbolCounts();
        char[] ca = symbolCounts.symbols;
        int[] vl = symbolCounts.values;
        QuickSort.sort(vl, ca);
        boolean first = true;
        StringBuilder sb = new StringBuilder(64);
        for (int c = ca.length - 1; c >= 0; --c) {
            char residue = ca[c];
            float tval = (float)vl[c] * 100.0f / (float)normaliseBy;
            sb.append(first ? "" : "; ").append(residue).append(" ");
            Format.appendPercentage(sb, tval, percentageDecPl);
            sb.append("%");
            first = false;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        SymbolCounts sc = this.getSymbolCounts();
        for (int i = 0; i < sc.symbols.length; ++i) {
            sb.append(sc.symbols[i]).append(":").append(sc.values[i]).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getTotalResidueCount() {
        int total = 0;
        for (char symbol : this.getSymbolCounts().symbols) {
            total += this.getCount(symbol);
        }
        return total;
    }

    static {
        int i;
        NUC_INDEX = new int[26];
        AA_INDEX = new int[26];
        for (i = 0; i < NUCS.length(); ++i) {
            ResidueCount.NUC_INDEX[NUCS.charAt((int)i) - 65] = i + 1;
        }
        for (i = 0; i < AAS.length(); ++i) {
            ResidueCount.AA_INDEX[AAS.charAt((int)i) - 65] = i + 1;
        }
    }

    public class SymbolCounts {
        public final char[] symbols;
        public final int[] values;

        SymbolCounts(char[] s, int[] v) {
            this.symbols = s;
            this.values = v;
        }
    }
}

