/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;

public class EmbmenuFrame
extends Frame
implements MouseListener,
AutoCloseable {
    protected static final Font FONT_ARIAL_PLAIN_11;
    public static final Font DEFAULT_MENU_FONT;
    protected Map<Label, PopupMenu> embeddedPopup = new HashMap<Label, PopupMenu>();
    protected Panel embeddedMenu;

    public EmbmenuFrame() throws HeadlessException {
    }

    public EmbmenuFrame(String title) throws HeadlessException {
        super(title);
    }

    protected boolean embedMenuIfNeeded(Panel tobeAdjusted) {
        MenuBar topMenuBar = this.getMenuBar();
        if (topMenuBar == null) {
            return false;
        }
        if (Platform.isAMacAndNotJS()) {
            this.embeddedMenu = this.makeEmbeddedPopupMenu(topMenuBar, true, false);
            this.setMenuBar(null);
            this.add((Component)this.embeddedMenu, "North");
            tobeAdjusted.setSize(this.getSize().width, this.getSize().height - this.embeddedMenu.getHeight());
            return true;
        }
        return false;
    }

    protected Panel makeEmbeddedPopupMenu(MenuBar menuBar, boolean overrideFonts, boolean append) {
        if (!append) {
            this.embeddedPopup.clear();
            if (this.embeddedMenu != null) {
                this.embeddedMenu.removeAll();
            }
        }
        this.embeddedMenu = this.makeEmbeddedPopupMenu(menuBar, DEFAULT_MENU_FONT, overrideFonts, new Panel(), this);
        return this.embeddedMenu;
    }

    protected Panel makeEmbeddedPopupMenu(MenuBar menuBar, Font font, boolean overrideFonts, Panel embeddedMenu, MouseListener clickHandler) {
        Font mbf;
        if (overrideFonts && (mbf = menuBar.getFont()) != null) {
            font = mbf;
        }
        if (embeddedMenu == null) {
            embeddedMenu = new Panel();
        }
        FlowLayout flowLayout1 = new FlowLayout();
        embeddedMenu.setBackground(Color.lightGray);
        embeddedMenu.setLayout(flowLayout1);
        int nMbi = menuBar.getMenuCount();
        for (int mbi = 0; mbi < nMbi; ++mbi) {
            Menu mi = menuBar.getMenu(mbi);
            Label elab = new Label(mi.getLabel());
            elab.setFont(font);
            PopupMenu popup = new PopupMenu();
            int mSize = mi.getItemCount();
            for (int m = 0; m < mSize; ++m) {
                popup.add(mi.getItem(m));
                --mSize;
                --m;
            }
            this.embeddedPopup.put(elab, popup);
            embeddedMenu.add(elab);
            elab.addMouseListener(clickHandler);
        }
        flowLayout1.setAlignment(0);
        flowLayout1.setHgap(2);
        flowLayout1.setVgap(0);
        return embeddedMenu;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        PopupMenu popup = null;
        Label source = (Label)evt.getSource();
        popup = this.getPopupMenu(source);
        if (popup != null) {
            this.embeddedMenu.add(popup);
            popup.show(this.embeddedMenu, source.getBounds().x, source.getBounds().y + source.getBounds().getSize().height);
        }
    }

    PopupMenu getPopupMenu(Label source) {
        return this.embeddedPopup.get(source);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    public void destroyMenus() {
        if (this.embeddedPopup != null) {
            for (Label lb : this.embeddedPopup.keySet()) {
                lb.removeMouseListener(this);
            }
            this.embeddedPopup.clear();
        }
        if (this.embeddedMenu != null) {
            this.embeddedMenu.removeAll();
        }
    }

    @Override
    public void close() {
        this.destroyMenus();
        this.embeddedPopup = null;
        this.embeddedMenu = null;
    }

    static {
        DEFAULT_MENU_FONT = FONT_ARIAL_PLAIN_11 = new Font("Arial", 0, 11);
    }
}

