/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Alignment {
    protected AlignmentMetadata metadata;
    protected List<FastaSequence> sequences;

    protected Alignment() {
    }

    public Alignment(List<FastaSequence> sequences, Program program, char gapchar) {
        this.sequences = sequences;
        this.metadata = new AlignmentMetadata(program, gapchar);
    }

    public Alignment(List<FastaSequence> sequences, AlignmentMetadata metadata) {
        this.sequences = sequences;
        this.metadata = metadata;
    }

    public List<FastaSequence> getSequences() {
        return this.sequences;
    }

    public int getSize() {
        return this.sequences.size();
    }

    public AlignmentMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        String sseq = "";
        for (FastaSequence fs : this.getSequences()) {
            sseq = sseq + fs.toString() + "\n";
        }
        return sseq;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.sequences == null ? 0 : this.sequences.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alignment)) {
            return false;
        }
        Alignment al = (Alignment)obj;
        if (this.getSize() != al.getSize()) {
            return false;
        }
        if (!this.getMetadata().equals(al.getMetadata())) {
            return false;
        }
        int outerCounter = 0;
        int matchCounter = 0;
        for (FastaSequence fs : this.getSequences()) {
            ++outerCounter;
            for (FastaSequence fs1 : al.getSequences()) {
                if (!fs.equals(fs1)) continue;
                ++matchCounter;
            }
            if (outerCounter == matchCounter) continue;
            return false;
        }
        return true;
    }
}

