/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import org.jmol.modelset.Atom;
import org.jmol.viewer.Viewer;

public class NMRNoeMatrix {
    static int id = 0;
    double[][] eigenValues;
    double[][] eigenVectors;
    double[][] relaxMatrix;
    double[][] noeM;
    double[][] distanceMatrix;
    NOEAtom[] atoms;
    int nHAtoms;
    int atomCounter;
    int i;
    int j;
    int k;
    int m;
    int n;
    int p;
    int q;
    private int[] atomMap;
    private int baseIndex = 0;
    private final NOEParams params;
    static NumberFormat nf = NumberFormat.getInstance();

    private NMRNoeMatrix() {
        this.params = new NOEParams();
    }

    public static NMRNoeMatrix createMatrix(Viewer viewer, BS bsMol, String[] labelArray, NOEParams params) {
        BS bsH = null;
        try {
            bsH = bsMol.cardinality() == 0 ? new BS() : viewer.getSmartsMatch("[H]", bsMol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Hashtable<Atom, String> labels = new Hashtable<Atom, String>();
        Hashtable<Atom, Integer> indexAtomInMol = new Hashtable<Atom, Integer>();
        Map<String, Lst<Atom>> labelMap = NMRNoeMatrix.createLabelMapAndIndex(viewer, bsMol, labelArray, bsH, labels, indexAtomInMol);
        Lst<Object> hAtoms = NMRNoeMatrix.createHAtomList(viewer, bsMol, bsH, labels, labelMap);
        NMRNoeMatrix noeMatrix = NMRNoeMatrix.createNOEMatrix(hAtoms, indexAtomInMol, bsMol.cardinality(), bsMol.nextSetBit(0), params == null ? new NOEParams() : params);
        if (!bsMol.isEmpty()) {
            viewer.getCurrentModelAuxInfo().put("noeMatrix", noeMatrix);
        }
        return noeMatrix;
    }

    public NOEParams getParams() {
        return this.params;
    }

    private static NMRNoeMatrix createNOEMatrix(Lst<Object> hAtoms, Map<Atom, Integer> indexAtomInMol, int atomCount, int baseIndex, NOEParams params) {
        int[] map = new int[atomCount];
        int nHAtoms = hAtoms.size();
        NMRNoeMatrix noeMatrix = new NMRNoeMatrix(params);
        noeMatrix.baseIndex = baseIndex;
        noeMatrix.initArrays(nHAtoms);
        for (int i = 0; i < nHAtoms; ++i) {
            Atom[] a;
            Object aobj = hAtoms.get(i);
            if (aobj instanceof Atom) {
                a = (Atom[])hAtoms.get(i);
                map[indexAtomInMol.get((Object)a).intValue()] = i;
                noeMatrix.addAtom(a.x, a.y, a.z);
                continue;
            }
            if (aobj instanceof Lst) {
                Lst lst = (Lst)aobj;
                int nEquiv = lst.size();
                for (int j = 0; j < nEquiv; ++j) {
                    map[indexAtomInMol.get(lst.get((int)j)).intValue()] = i;
                }
                double[] xa = new double[nEquiv];
                double[] ya = new double[nEquiv];
                double[] za = new double[nEquiv];
                for (int j = 0; j < nEquiv; ++j) {
                    Atom a2 = (Atom)lst.get(j);
                    xa[j] = a2.x;
                    ya[j] = a2.y;
                    za[j] = a2.z;
                }
                noeMatrix.addEquiv(xa, ya, za);
                continue;
            }
            a = (Atom[])aobj;
            map[indexAtomInMol.get((Object)a[0]).intValue()] = i;
            map[indexAtomInMol.get((Object)a[1]).intValue()] = i;
            map[indexAtomInMol.get((Object)a[2]).intValue()] = i;
            noeMatrix.addMethyl(a[0].x, a[0].y, a[0].z, a[1].x, a[1].y, a[1].z, a[2].x, a[2].y, a[2].z);
        }
        noeMatrix.atomMap = map;
        return noeMatrix;
    }

    private NMRNoeMatrix(NOEParams params) {
        this.params = params;
        params.id = ++id;
    }

    public void calcNOEs() throws Exception {
        if (this.nHAtoms == 0 || this.atoms == null) {
            this.noeM = new double[0][0];
            return;
        }
        if (this.nHAtoms != this.atomCounter) {
            throw new Exception("Not all atoms have been read in yet!");
        }
        boolean isNew = false;
        if (this.params.tainted) {
            this.calcRelaxMatrix();
            this.Diagonalise();
            isNew = true;
        }
        if (this.params.tainted || this.params.mixingChanged) {
            this.calcNoeMatrix();
            this.params.mixingChanged = false;
            isNew = true;
        }
        this.params.tainted = false;
    }

    public void initArrays(int n) {
        this.nHAtoms = n;
        this.atoms = new NOEAtom[this.nHAtoms];
        this.atomCounter = 0;
        this.relaxMatrix = new double[this.nHAtoms][this.nHAtoms];
        this.eigenValues = new double[this.nHAtoms][this.nHAtoms];
        this.eigenVectors = new double[this.nHAtoms][this.nHAtoms];
        this.noeM = new double[this.nHAtoms][this.nHAtoms];
        this.distanceMatrix = new double[this.nHAtoms][this.nHAtoms];
    }

    public void addAtom(double x, double y, double z) {
        this.atoms[this.atomCounter] = new NOEAtom();
        this.atoms[this.atomCounter].x = x;
        this.atoms[this.atomCounter].y = y;
        this.atoms[this.atomCounter].z = z;
        this.atoms[this.atomCounter].methyl = false;
        ++this.atomCounter;
        this.params.tainted = true;
    }

    public void addMethyl(double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        this.atoms[this.atomCounter] = new NOEAtom();
        this.atoms[this.atomCounter].x = x;
        this.atoms[this.atomCounter].y = y;
        this.atoms[this.atomCounter].z = z;
        this.atoms[this.atomCounter].x1 = x1;
        this.atoms[this.atomCounter].y1 = y1;
        this.atoms[this.atomCounter].z1 = z1;
        this.atoms[this.atomCounter].x2 = x2;
        this.atoms[this.atomCounter].y2 = y2;
        this.atoms[this.atomCounter].z2 = z2;
        this.atoms[this.atomCounter].methyl = true;
        ++this.atomCounter;
        this.params.tainted = true;
    }

    public void addEquiv(double[] xa, double[] ya, double[] za) {
        this.atoms[this.atomCounter] = new NOEAtom();
        this.atoms[this.atomCounter].xa = xa;
        this.atoms[this.atomCounter].ya = ya;
        this.atoms[this.atomCounter].za = za;
        this.atoms[this.atomCounter].equiv = true;
        ++this.atomCounter;
        this.params.tainted = true;
    }

    private void calcRelaxMatrix() {
        double JValRho;
        double JValSigma;
        double alpha = 5.6965E10;
        double rhoStar = this.params.rhoStar;
        double freq = this.params.freq;
        double cutoff2 = this.params.cutoff * this.params.cutoff;
        double tau = this.params.tau;
        if (this.params.noesy) {
            JValSigma = 6.0 * NMRNoeMatrix.J(2.0 * freq, tau) - NMRNoeMatrix.J(0.0, tau);
            JValRho = 6.0 * NMRNoeMatrix.J(2.0 * freq, tau) + 3.0 * NMRNoeMatrix.J(freq, tau) + NMRNoeMatrix.J(0.0, tau);
        } else {
            JValSigma = 3.0 * NMRNoeMatrix.J(freq, tau) + 2.0 * NMRNoeMatrix.J(0.0, tau);
            JValRho = 3.0 * NMRNoeMatrix.J(2.0 * freq, tau) + 4.5 * NMRNoeMatrix.J(freq, tau) + 2.5 * NMRNoeMatrix.J(0.0, tau);
        }
        this.i = 0;
        while (this.i < this.nHAtoms) {
            double rho = 0.0;
            this.j = 0;
            while (this.j < this.nHAtoms) {
                double distSqrd = this.distanceSqrd(this.atoms[this.i], this.atoms[this.j]);
                this.distanceMatrix[this.i][this.j] = Math.sqrt(distSqrd);
                double aOverR6 = distSqrd < cutoff2 ? alpha / (distSqrd * distSqrd * distSqrd) : 0.0;
                if (this.i < this.j) {
                    this.relaxMatrix[this.i][this.j] = aOverR6 * JValSigma;
                    this.relaxMatrix[this.j][this.i] = this.relaxMatrix[this.i][this.j];
                }
                if (this.i != this.j) {
                    rho += aOverR6 * JValRho;
                }
                ++this.j;
            }
            this.relaxMatrix[this.i][this.i] = rho + rhoStar;
            ++this.i;
        }
    }

    private static double J(double w, double tau) {
        return tau / (1.0 + w * w * tau * tau);
    }

    private int sign(double x) {
        if (x < 0.0) {
            return -1;
        }
        return 1;
    }

    private void calcNoeMatrix() {
        double[] tempEVs = new double[this.nHAtoms];
        double tMix = this.params.tMix;
        this.i = 0;
        while (this.i < this.nHAtoms) {
            tempEVs[this.i] = Math.exp(-this.eigenValues[this.i][this.i] * tMix);
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.nHAtoms) {
            this.j = 0;
            while (this.j <= this.i) {
                double sum = 0.0;
                this.k = 0;
                while (this.k < this.nHAtoms) {
                    sum += this.eigenVectors[this.i][this.k] * this.eigenVectors[this.j][this.k] * tempEVs[this.k];
                    ++this.k;
                }
                this.noeM[this.i][this.j] = sum;
                this.noeM[this.j][this.i] = sum;
                ++this.j;
            }
            ++this.i;
        }
    }

    private int Diagonalise() {
        int i;
        int iter = 0;
        for (i = 0; i < this.nHAtoms; ++i) {
            for (int z = 0; z < this.nHAtoms; ++z) {
                this.eigenVectors[i][z] = 0.0;
                this.eigenValues[i][z] = this.relaxMatrix[i][z];
            }
        }
        for (i = 0; i < this.nHAtoms; ++i) {
            this.eigenVectors[i][i] = 1.0;
        }
        String state = "ITERATING";
        int maxIter = 100000;
        while (state == "ITERATING") {
            double max = this.maxOffDiag();
            if (max > 0.0) {
                this.rotate();
                if (++iter < maxIter) continue;
                state = "STOP";
                System.out.println("maximum iteration reached");
                continue;
            }
            state = "SUCCESS";
        }
        return iter;
    }

    private double maxOffDiag() {
        double max = 0.0;
        for (int i = 0; i < this.nHAtoms - 1; ++i) {
            for (int j = i + 1; j < this.nHAtoms; ++j) {
                double aij = Math.abs(this.eigenValues[i][j]);
                if (!(aij > max)) continue;
                max = aij;
                this.p = i;
                this.q = j;
            }
        }
        return max;
    }

    private void rotate() {
        int k;
        double d = (this.eigenValues[this.p][this.p] - this.eigenValues[this.q][this.q]) / (2.0 * this.eigenValues[this.p][this.q]);
        double t = (double)this.sign(d) / (Math.abs(d) + Math.sqrt(d * d + 1.0));
        double c = 1.0 / Math.sqrt(t * t + 1.0);
        double s = t * c;
        double[] dArray = this.eigenValues[this.p];
        int n = this.p;
        dArray[n] = dArray[n] + t * this.eigenValues[this.p][this.q];
        double[] dArray2 = this.eigenValues[this.q];
        int n2 = this.q;
        dArray2[n2] = dArray2[n2] - t * this.eigenValues[this.p][this.q];
        this.eigenValues[this.q][this.p] = 0.0;
        this.eigenValues[this.p][this.q] = 0.0;
        for (k = 0; k < this.nHAtoms; ++k) {
            if (k == this.p || k == this.q) continue;
            double akp = c * this.eigenValues[k][this.p] + s * this.eigenValues[k][this.q];
            double akq = -s * this.eigenValues[k][this.p] + c * this.eigenValues[k][this.q];
            double d2 = akp;
            this.eigenValues[this.p][k] = d2;
            this.eigenValues[k][this.p] = d2;
            double d3 = akq;
            this.eigenValues[this.q][k] = d3;
            this.eigenValues[k][this.q] = d3;
        }
        for (k = 0; k < this.nHAtoms; ++k) {
            double rkp = c * this.eigenVectors[k][this.p] + s * this.eigenVectors[k][this.q];
            double rkq = -s * this.eigenVectors[k][this.p] + c * this.eigenVectors[k][this.q];
            this.eigenVectors[k][this.p] = rkp;
            this.eigenVectors[k][this.q] = rkq;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.i = 0;
        while (this.i < this.nHAtoms) {
            this.j = 0;
            while (this.j < this.nHAtoms) {
                sb.append(nf.format(this.noeM[this.i][this.j]) + "\t");
                ++this.j;
            }
            sb.append("\n");
            ++this.i;
        }
        sb.append(this.params.toString());
        return sb.toString();
    }

    public String toStringNormRow() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        StringBuffer sb = new StringBuffer();
        this.i = 0;
        while (this.i < this.nHAtoms) {
            this.j = 0;
            while (this.j < this.nHAtoms) {
                double val = this.noeM[this.i][this.j] / this.noeM[this.i][this.i];
                sb.append(nf.format(val) + "\t");
                ++this.j;
            }
            sb.append("\n");
            ++this.i;
        }
        return sb.toString();
    }

    private double distanceSqrd(NOEAtom a, NOEAtom b) {
        NOEAtom atom2;
        NOEAtom atom1;
        if (b.methyl && !a.methyl) {
            atom1 = b;
            atom2 = a;
        } else if (b.equiv && !a.equiv) {
            atom1 = b;
            atom2 = a;
        } else {
            atom1 = a;
            atom2 = b;
        }
        if (atom1.methyl) {
            double a2z;
            double a2y;
            double a2x;
            if (atom2.methyl) {
                a2x = (atom2.x + atom2.x1 + atom2.x2) / 3.0;
                a2y = (atom2.y + atom2.y1 + atom2.y2) / 3.0;
                a2z = (atom2.z + atom2.z1 + atom2.z2) / 3.0;
            } else if (atom2.equiv) {
                a2x = 0.0;
                a2y = 0.0;
                a2z = 0.0;
                for (int j = 0; j < atom2.xa.length; ++j) {
                    a2x += atom2.xa[j] / (double)atom2.xa.length;
                    a2y += atom2.ya[j] / (double)atom2.xa.length;
                    a2z += atom2.za[j] / (double)atom2.xa.length;
                }
            } else {
                a2x = atom2.x;
                a2y = atom2.y;
                a2z = atom2.z;
            }
            double x1 = atom1.x - a2x;
            double y1 = atom1.y - a2y;
            double z1 = atom1.z - a2z;
            double x2 = atom1.x1 - a2x;
            double y2 = atom1.y1 - a2y;
            double z2 = atom1.z1 - a2z;
            double x3 = atom1.x2 - a2x;
            double y3 = atom1.y2 - a2y;
            double z3 = atom1.z2 - a2z;
            double d1 = x1 * x1 + y1 * y1 + z1 * z1;
            double d2 = x2 * x2 + y2 * y2 + z2 * z2;
            double d3 = x3 * x3 + y3 * y3 + z3 * z3;
            double d15 = d1 * d1 * Math.sqrt(d1);
            double d25 = d2 * d2 * Math.sqrt(d2);
            double d35 = d3 * d3 * Math.sqrt(d3);
            double prod12 = x1 * x2 + y1 * y2 + z1 * z2;
            double prod13 = x1 * x3 + y1 * y3 + z1 * z3;
            double prod23 = x2 * x3 + y2 * y3 + z2 * z3;
            double d = 2.0 * d1 * d1 / (d15 * d15);
            d += (3.0 * (prod12 * prod12) - d1 * d2) / (d15 * d25);
            d += (3.0 * (prod13 * prod13) - d1 * d3) / (d15 * d35);
            d += (3.0 * (prod12 * prod12) - d2 * d1) / (d25 * d15);
            d += 2.0 * d2 * d2 / (d25 * d25);
            d += (3.0 * (prod23 * prod23) - d2 * d3) / (d25 * d35);
            d += (3.0 * (prod13 * prod13) - d3 * d1) / (d35 * d15);
            d += (3.0 * (prod23 * prod23) - d3 * d2) / (d35 * d25);
            return Math.pow((d += 2.0 * d3 * d3 / (d35 * d35)) / 18.0, -0.3333333333333333);
        }
        if (atom1.equiv) {
            if (atom2.equiv) {
                double dd = 0.0;
                for (int i = 0; i < atom1.xa.length; ++i) {
                    for (int j = 0; j < atom2.xa.length; ++j) {
                        double x1 = atom1.xa[i] - atom2.xa[j];
                        double y1 = atom1.ya[i] - atom2.ya[j];
                        double z1 = atom1.za[i] - atom2.za[j];
                        dd += Math.pow(x1 * x1 + y1 * y1 + z1 * z1, -3.0);
                    }
                }
                return Math.pow(dd / (double)(atom1.xa.length * atom2.xa.length), -0.3333333333333333);
            }
            double dd = 0.0;
            for (int i = 0; i < atom1.xa.length; ++i) {
                double x1 = atom1.xa[i] - atom2.x;
                double y1 = atom1.ya[i] - atom2.y;
                double z1 = atom1.za[i] - atom2.z;
                dd += Math.pow(x1 * x1 + y1 * y1 + z1 * z1, -3.0);
            }
            return Math.pow(dd / (double)atom1.xa.length, -0.3333333333333333);
        }
        double x1 = atom1.x - atom2.x;
        double y1 = atom1.y - atom2.y;
        double z1 = atom1.z - atom2.z;
        return x1 * x1 + y1 * y1 + z1 * z1;
    }

    private void doItAll(File file) {
        System.out.println("starting");
        this.readAtomsFromFile(file);
        this.relaxMatrix = new double[this.nHAtoms][this.nHAtoms];
        this.eigenValues = new double[this.nHAtoms][this.nHAtoms];
        this.eigenVectors = new double[this.nHAtoms][this.nHAtoms];
        this.noeM = new double[this.nHAtoms][this.nHAtoms];
        System.out.println("read atoms: " + Integer.toString(this.nHAtoms));
        this.calcRelaxMatrix();
        System.out.println("built matrix");
        System.out.println("total iterations = " + Integer.toString(this.Diagonalise()));
        System.out.println("diagonalised matrix");
        this.calcNoeMatrix();
        System.out.println("calculated NOE matrix");
        System.out.println(this.toString());
        System.out.println("");
        System.out.println(this.toStringNormRow());
        try {
            this.calcNOEs();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAtomsFromFile(File file) {
        this.atoms = new NOEAtom[200];
        this.nHAtoms = 0;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(file));
                br.readLine();
                System.out.println("found file");
                while (true) {
                    String[] linetokens;
                    if (!(linetokens = br.readLine().split("\\s+"))[1].matches("41") && !linetokens[1].matches("44")) {
                        continue;
                    }
                    this.atoms[this.nHAtoms] = new NOEAtom();
                    this.atoms[this.nHAtoms].x = Double.valueOf(linetokens[14]);
                    this.atoms[this.nHAtoms].y = Double.valueOf(linetokens[15]);
                    this.atoms[this.nHAtoms].z = Double.valueOf(linetokens[16]);
                    this.atoms[this.nHAtoms].methyl = false;
                    ++this.nHAtoms;
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        NOEParams params = new NOEParams();
        params.setNMRfreqMHz(500.0);
        params.setCorrelationTimeTauPS(80.0);
        params.setMixingTimeSec(0.5);
        params.setCutoffAng(10.0);
        params.setRhoStar(0.1);
        params.setNoesy(true);
        new NMRNoeMatrix(params).doItAll(new File(args[0]));
    }

    private static Map<String, Lst<Atom>> createLabelMapAndIndex(Viewer viewer, BS bsMol, String[] labelArray, BS bsH, Map<Atom, String> labels, Map<Atom, Integer> indexAtomInMol) {
        Hashtable<String, Lst<Atom>> labelMap = new Hashtable<String, Lst<Atom>>();
        int pt = 0;
        int i = bsMol.nextSetBit(0);
        while (i >= 0) {
            Atom a = viewer.ms.at[i];
            indexAtomInMol.put(a, pt);
            if (labelArray != null) {
                String label = labelArray[pt];
                if (labelArray[pt] == null) {
                    labels.put(a, "");
                } else {
                    Lst<Atom> lst = (Lst<Atom>)labelMap.get(label);
                    if (lst == null) {
                        lst = new Lst<Atom>();
                        labelMap.put(label, lst);
                    } else {
                        bsH.clear(i);
                    }
                    lst.addLast(a);
                    labels.put(a, label);
                }
            }
            i = bsMol.nextSetBit(i + 1);
            ++pt;
        }
        return labelMap;
    }

    private static Lst<Object> createHAtomList(Viewer viewer, BS bsMol, BS bsH, Map<Atom, String> labels, Map<String, Lst<Atom>> labelMap) {
        Lst<Object> hAtoms = new Lst<Object>();
        try {
            if (!bsMol.isEmpty()) {
                int[][] methyls = viewer.getSmartsMap("C({[H]})({[H]}){[H]}", bsMol, 130);
                int i = methyls.length;
                while (--i >= 0) {
                    Atom[] methyl = new Atom[3];
                    for (int j = 0; j < 3; ++j) {
                        int pt = methyls[i][j];
                        methyl[j] = viewer.ms.at[pt];
                        bsH.clear(pt);
                    }
                    hAtoms.addLast(methyl);
                }
            }
        }
        catch (Exception methyls) {
            // empty catch block
        }
        int i = bsH.nextSetBit(0);
        while (i >= 0) {
            Lst<Atom> atoms;
            Atom a = viewer.ms.at[i];
            String label = labels.get(a);
            Lst<Atom> lst = atoms = label == null ? null : labelMap.get(labels.get(a));
            if (atoms != null && atoms.size() > 1) {
                hAtoms.addLast(atoms);
            } else {
                hAtoms.addLast(a);
            }
            i = bsH.nextSetBit(i + 1);
        }
        return hAtoms;
    }

    public double getJmolDistance(int a, int b) {
        return this.getDistance(this.atomMap[a - this.baseIndex], this.atomMap[b - this.baseIndex]);
    }

    private double getDistance(int i, int j) {
        return i < 0 || j < 0 || i >= this.nHAtoms ? Double.NaN : this.distanceMatrix[i][j];
    }

    public double getJmolNoe(int a, int b) {
        return this.getNoe(this.atomMap[a - this.baseIndex], this.atomMap[b - this.baseIndex]);
    }

    private double getNoe(int i, int j) {
        return i < 0 || j < 0 || i >= this.nHAtoms ? Double.NaN : this.noeM[i][j];
    }

    static {
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
    }

    static class NOEAtom {
        double x;
        double y;
        double z;
        double x1;
        double y1;
        double z1;
        double x2;
        double y2;
        double z2;
        double[] xa;
        double[] ya;
        double[] za;
        boolean methyl;
        boolean equiv;

        NOEAtom() {
        }
    }

    public static class NOEParams {
        private boolean noesy = true;
        private double tau = 8.0E-11;
        private double freq = 2.5132741228718348E9;
        private double tMix = 0.5;
        private double cutoff = 10.0;
        private double rhoStar = 0.1;
        boolean tainted = true;
        boolean mixingChanged = true;
        public int id;

        public String toString() {
            return "[id=" + this.id + " freq=" + this.getNMRfreqMHz() + " tau=" + this.tau + " tMix=" + this.tMix + " cutoff=" + this.cutoff + " rhoStar=" + this.rhoStar + " noesy=" + this.noesy + "]";
        }

        public void setCorrelationTimeTauPS(double t) {
            this.tau = t * 1.0E-12;
            this.tainted = true;
        }

        public void setMixingTimeSec(double t) {
            this.tMix = t;
            this.mixingChanged = true;
        }

        public void setNMRfreqMHz(double f) {
            this.freq = f * 2.0 * Math.PI * 1000000.0;
            this.tainted = true;
        }

        public void setCutoffAng(double c) {
            this.cutoff = c;
            this.tainted = true;
        }

        public void setRhoStar(double c) {
            this.rhoStar = c;
            this.tainted = true;
        }

        public void setNoesy(boolean b) {
            this.noesy = b;
            this.tainted = true;
        }

        public double getCorrelationTimeTauPS() {
            return this.tau;
        }

        public double getMixingTimeSec() {
            return this.tMix;
        }

        public boolean getNoesy() {
            return this.noesy;
        }

        public double getNMRfreqMHz() {
            return this.freq / 2.0 / Math.PI / 1000000.0;
        }

        public double getCutoffAng() {
            return this.cutoff;
        }
    }
}

