/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.ClientDocument;
import uk.ac.vamsas.client.IClientAppdata;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.simpleclient.VamsasArchive;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.ProvenanceStuff;

public class ClientDoc
extends ClientDocument {
    protected boolean isModified = false;
    private Log log = LogFactory.getLog((Class)ClientDoc.class);
    protected VamsasDocument doc;
    public VAMSAS[] _VamsasRoots;
    protected VamsasArchive iohandler = null;
    protected VamsasArchiveReader reader = null;
    private String user = null;
    private String app = null;
    private Hashtable objrefs = null;

    public IClientAppdata getClientAppdata() {
        throw new Error("Appdata access is not implemented in the test.simpleclient.ClientDoc instance.");
    }

    public ClientDoc(VamsasDocument doc, VamsasArchive iohandler, VamsasArchiveReader reader, String app, String user, Hashtable objrefs) {
        super(objrefs, iohandler != null ? iohandler.getVorba() : null);
        this.doc = doc;
        this.iohandler = iohandler;
        this.reader = reader;
        this.app = app;
        this.user = user;
        this.objrefs = objrefs;
        this._VamsasRoots = doc.getVAMSAS();
    }

    protected Entry getProvenanceEntry(String action) {
        Entry prov = ProvenanceStuff.newProvenanceEntry(this.app, this.user, action);
        return prov;
    }

    public VAMSAS[] getVamsasRoots() {
        if (this.doc == null) {
            this.log.debug((Object)"Null document for getVamsasRoots(), returning null");
            return null;
        }
        if (this.iohandler == null) {
            this.log.warn((Object)"getVamsasRoots() called on possibly read-only document.");
        }
        if (this._VamsasRoots != null) {
            return this._VamsasRoots;
        }
        VAMSAS[] roots = this.doc.getVAMSAS();
        if (roots == null) {
            this._VamsasRoots = new VAMSAS[]{new VAMSAS()};
            this.doc.getProvenance().addEntry(this.getProvenanceEntry("Created new document root [id=" + this._VamsasRoots[0].getId() + "]"));
            this.doc.addVAMSAS(this._VamsasRoots[0]);
        } else {
            this._VamsasRoots = new VAMSAS[roots.length];
            for (int r = 0; r < roots.length; ++r) {
                this._VamsasRoots[r] = roots[r];
            }
        }
        return this._VamsasRoots;
    }

    private int _contains(VAMSAS root, VAMSAS[] docRoots) {
        if (root == null) {
            return -1;
        }
        if (docRoots == null || docRoots.length == 0) {
            return -1;
        }
        VorbaId r_id = root.getVorbaId();
        int j = docRoots.length;
        for (int i = 0; i < j; ++i) {
            VorbaId n_id = null;
            if (docRoots[i] != root && (docRoots[i] == null || (n_id = docRoots[i].getVorbaId()) == null || !n_id.equals(r_id))) continue;
            return i;
        }
        return -1;
    }

    private boolean isValidUpdate(VAMSAS newVersion, VAMSAS oldVersion) {
        if (oldVersion == newVersion) {
            if (!newVersion.isRegistered()) {
                this.iohandler.getVorba().makeVorbaId(newVersion);
            }
            return newVersion.isValid();
        }
        if (!newVersion.isRegistered()) {
            this.iohandler.getVorba().makeVorbaId(newVersion);
        }
        return newVersion.isValid();
    }

    private VAMSAS[] _combineRoots(VAMSAS[] newr, VAMSAS[] original, ClientDoc modflag) {
        int i;
        Vector<VAMSAS> rts = new Vector<VAMSAS>();
        boolean modified = false;
        int j = original.length;
        for (i = 0; i < j; ++i) {
            int k = this._contains(original[i], newr);
            if (k > -1) {
                if (this.isValidUpdate(newr[k], original[i])) {
                    modified = true;
                    rts.add(newr[k]);
                    newr[k] = null;
                    continue;
                }
                this.log.warn((Object)("Couldn't merge new VAMSAS root " + newr[k].getId()));
                newr[k] = null;
                continue;
            }
            rts.add(original[i]);
        }
        j = newr.length;
        for (i = 0; i < j; ++i) {
            if (newr[i] == null) continue;
            rts.add(newr[i]);
            modified = true;
        }
        newr = new VAMSAS[rts.size()];
        j = rts.size();
        for (i = 0; i < j; ++i) {
            newr[i] = (VAMSAS)rts.get(i);
        }
        if (modflag != null) {
            modflag.isModified = modified;
        }
        return newr;
    }

    public void setVamsasRoots(VAMSAS[] newroots) {
        VAMSAS[] newr;
        if (this.doc == null) {
            this.log.debug((Object)"setVamsasRoots called on null document.");
            return;
        }
        if (newroots == null) {
            this.log.debug((Object)"setVamsasRoots(null) - do nothing.");
            return;
        }
        if (this._VamsasRoots != newroots) {
            newr = new VAMSAS[newroots.length];
            for (int i = 0; i < newr.length; ++i) {
                newr[i] = newroots[i];
            }
            newr = this._combineRoots(newr, this._VamsasRoots, this);
        } else {
            newr = new VAMSAS[this._VamsasRoots.length];
            for (int i = 0; i < newr.length; ++i) {
                newr[i] = this._VamsasRoots[i];
            }
        }
        this._VamsasRoots = this._combineRoots(newr, this.doc.getVAMSAS(), this);
    }

    public void addVamsasRoot(VAMSAS newroot) {
        if (this.doc == null) {
            this.log.debug((Object)"addVamsasRoots called on null document.");
            return;
        }
        VAMSAS[] newroots = this._combineRoots(new VAMSAS[]{newroot}, this._VamsasRoots, this);
        this._VamsasRoots = newroots;
    }

    public VamsasArchiveReader getReader() {
        return this.reader;
    }

    private void _finalize() {
        this.log.debug((Object)"finalizing clientDoc");
        if (this.doc != null) {
            this.doc = null;
        }
        if (this._VamsasRoots != null) {
            for (int i = 0; i < this._VamsasRoots.length; ++i) {
                this._VamsasRoots[i] = null;
            }
            this._VamsasRoots = null;
        }
        if (this.reader != null) {
            this.log.debug((Object)"Closing and removing reader reference");
            this.reader.close();
            this.reader = null;
        }
        if (this.iohandler != null) {
            this.log.debug((Object)"Removing ioHandler reference.");
            this.iohandler.cancelArchive();
            this.iohandler = null;
        }
    }

    protected void finalize() throws Throwable {
        this._finalize();
        super.finalize();
    }

    public VorbaId[] registerObjects(Vobject[] unregistered) {
        if (this.doc == null) {
            this.log.warn((Object)"registerObjects[] called on null document.");
            return null;
        }
        if (this.objrefs == null) {
            this.log.warn((Object)"registerObjects[] called for null objrefs hasharray.");
            return null;
        }
        if (unregistered != null) {
            VorbaId[] ids = new VorbaId[unregistered.length];
            int k = unregistered.length;
            for (int i = 0; i < k; ++i) {
                if (unregistered[i] != null) {
                    this.log.warn((Object)("Null Vobject passed to registerObject[] at position " + i));
                    return null;
                }
                ids[i] = this.registerObject(unregistered[i]);
            }
            this.log.debug((Object)("Registered " + unregistered.length + " objects - total of " + this.objrefs.size() + " ids."));
            return ids;
        }
        return null;
    }

    public VorbaId registerObject(Vobject unregistered) {
        if (this.doc == null) {
            this.log.warn((Object)"registerObjects called on null document.");
            return null;
        }
        if (this.objrefs == null) {
            this.log.warn((Object)"registerObjects called for null objrefs hasharray.");
            return null;
        }
        if (this.iohandler == null) {
            this.log.warn((Object)"registerObjects called for read only document.");
            return null;
        }
        if (unregistered != null) {
            VorbaId id = this._registerObject(unregistered);
            this.log.debug((Object)("Registered object - total of " + this.objrefs.size() + " ids."));
            return id;
        }
        this.log.warn((Object)"Null Vobject passed to registerObject.");
        return null;
    }

    public Vobject getObject(VorbaId id) {
        if (this.objrefs == null) {
            this.log.debug((Object)"getObject called on null objrefs list.");
            return null;
        }
        if (this.objrefs.containsKey(id.getId())) {
            return (Vobject)this.objrefs.get(id.getId());
        }
        this.log.debug((Object)("Returning null Vobject reference for id " + id.getId()));
        return null;
    }

    public Vobject[] getObjects(VorbaId[] ids) {
        if (this.objrefs == null) {
            this.log.debug((Object)"getObject[]  called on null objrefs list.");
            return null;
        }
        Vobject[] vo = new Vobject[ids.length];
        int j = ids.length;
        for (int i = 0; i < j; ++i) {
            if (this.objrefs.containsKey(ids[i])) {
                vo[i] = (Vobject)this.objrefs.get(ids[i]);
                continue;
            }
            this.log.debug((Object)("Returning null Vobject reference for id " + ids[i].getId()));
        }
        return vo;
    }

    protected void updateDocumentRoots() {
        if (this.doc == null) {
            this.log.error((Object)"updateDocumentRoots called on null document. Probably an implementation error.");
            return;
        }
        if (this.isModified && this._VamsasRoots != null) {
            this.doc.setVAMSAS(this._VamsasRoots);
            this._VamsasRoots = null;
        }
    }

    public void closeDoc() {
        if (this.doc != null) {
            this.log.debug((Object)"Closing open document.");
            this._finalize();
        } else {
            this.log.warn((Object)"Ignoring closeDoc on invalid document.");
        }
    }
}

