/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.simpleclient.ListFile;
import uk.ac.vamsas.client.simpleclient.Lock;

public class ClientsFile
extends ListFile {
    private static Log log = LogFactory.getLog((Class)ClientsFile.class);
    private int syncnum = 1;
    boolean backup = false;

    public ClientsFile(File filelist) throws IOException {
        super(filelist);
    }

    private ClientHandle[] retrieveClientHandles() {
        if (this.lockFile()) {
            try {
                ObjectInputStream is;
                Object o;
                ClientHandle[] clients = null;
                if (this.fileLock.length() > 0L && (o = (is = new ObjectInputStream(this.fileLock.getBufferedInputStream(true))).readObject()) != null) {
                    try {
                        clients = (ClientHandle[])o;
                    }
                    catch (Exception e) {
                        System.err.println("Garbage in the clientHandle list " + this.sessionFile);
                    }
                }
                return clients;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    public ClientHandle[] retrieveClientList() {
        if (this.lockFile()) {
            ClientHandle[] clients = this.retrieveClientHandles();
            this.unlockFile();
            return clients;
        }
        return null;
    }

    public ClientHandle[] retrieveClientList(Lock extantlock) {
        if (this.lockFile(extantlock)) {
            ClientHandle[] clients = this.retrieveClientHandles();
            this.unlockFile();
            return clients;
        }
        return null;
    }

    public int addClient(ClientHandle me, Lock extantLock) {
        return this.addClient(me, true, extantLock);
    }

    public int addClient(ClientHandle me, boolean disambig, Lock extantLock) {
        if (this.lockFile(extantLock)) {
            this.syncnum = this.addClient(me, disambig);
            this.unlockFile();
            return this.syncnum;
        }
        return 0;
    }

    public int addClient(ClientHandle me) {
        this.syncnum = this.addClient(me, true);
        this.unlockFile();
        return this.syncnum;
    }

    public void removeClient(ClientHandle me, Lock clientlock) {
        int mynum = -1;
        if (this.lockFile(clientlock)) {
            ClientHandle[] clients = this.retrieveClientHandles();
            if (clients != null) {
                if (this.syncnum <= 0 || this.syncnum > clients.length || clients[this.syncnum - 1] != me) {
                    int j = clients.length;
                    for (int i = 0; i < j; ++i) {
                        if (!clients[i].equals(me)) continue;
                        mynum = i;
                        break;
                    }
                } else {
                    mynum = this.syncnum - 1;
                }
                if (mynum > -1) {
                    ClientHandle[] newlist = new ClientHandle[clients.length - 1];
                    int k = 0;
                    int j = clients.length;
                    for (int i = 0; i < j; ++i) {
                        if (i == mynum) continue;
                        newlist[k++] = clients[i];
                    }
                    if (!this.putClientList(newlist)) {
                        throw new Error("Failed to write new clientList!");
                    }
                }
            }
        } else {
            throw new Error("Couldn't get lock for " + (this.sessionFile == null ? "Unitialised sessionFile in ClientsFile" : this.sessionFile.getAbsolutePath()));
        }
        this.unlockFile();
    }

    protected int addClient(ClientHandle me, boolean disambiguate) {
        int newclient = 0;
        int tries = 5;
        while (tries-- > 0 && !this.lockFile()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {}
        }
        if (this.lockFile()) {
            ClientHandle[] clients = this.retrieveClientHandles();
            if (me.getClientUrn() == null) {
                me.setClientUrn("vamsas://" + me.getClientName() + ":" + me.getVersion() + "/");
            }
            if (clients == null) {
                clients = new ClientHandle[]{me};
                newclient = 1;
            } else {
                int i;
                int k = 0;
                int j = clients.length;
                for (i = 0; i < j; ++i) {
                    if (!clients[i].equals(me)) continue;
                    if (disambiguate) {
                        while (clients[i].equals(me)) {
                            me.setClientUrn(me.getClientUrn() + k++);
                        }
                        continue;
                    }
                    return -1 - i;
                }
                ClientHandle[] newlist = new ClientHandle[clients.length + 1];
                j = clients.length;
                for (i = 0; i < j; ++i) {
                    newlist[i] = clients[i];
                }
                newlist[j] = me;
                clients = newlist;
                newclient = j + 1;
            }
            if (!this.putClientList(clients)) {
                return 0;
            }
        }
        return newclient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean putClientList(ClientHandle[] clients) {
        if (!this.lockFile()) throw new Error("Could not lock the clientList: " + (this.sessionFile == null ? "Unitialized ClientsFile" : " failed to get lock on " + this.sessionFile.getAbsolutePath()));
        File templist = null;
        if (this.backup) {
            templist = this.backupSessionFile();
        }
        if (this.backup && templist == null) throw new Error("Couldn't create backup of the clientList before writing to it!");
        int retries = 3;
        while (retries-- > 0) {
            try {
                ObjectOutputStream os = new ObjectOutputStream(this.fileLock.getBufferedOutputStream(true));
                log.debug((Object)("About to write " + clients.length + " clientHandles to output stream."));
                os.writeObject(clients);
                os.close();
                if (this.backup) {
                    templist.delete();
                }
                templist = null;
                retries = -1;
            }
            catch (Exception e) {
                System.err.println("Serious - problems writing to sessionFile.");
                if (retries > 0 && templist != null) {
                    System.err.println("Recovering from Backup in " + templist.getAbsolutePath());
                    templist.renameTo(this.fileLock.target);
                }
                e.printStackTrace(System.err);
            }
        }
        if (retries <= -2) return true;
        System.err.println("Serious - problems writing to sessionFile. Giving Up.");
        return false;
    }

    public void clearList() {
        if (this.lockFile()) {
            try {
                FileOutputStream fout = this.fileLock.getFileOutputStream(true);
                fout.flush();
                fout.close();
            }
            catch (Exception e) {
                throw new Error("Problems trying to clear clientlist!", e);
            }
        }
    }
}

