/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest;

import jalview.bin.Console;
import jalview.io.FileParse;
import jalview.io.packed.DataProvider;
import jalview.io.packed.JalviewDataset;
import jalview.io.packed.ParsePackedSet;
import jalview.io.packed.SimpleDataProvider;
import jalview.util.MessageManager;
import jalview.ws.io.mime.JalviewMimeContentHandler;
import jalview.ws.rest.RestJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;

public class HttpResultSet
extends FileParse
implements AutoCloseable {
    private HttpRequestBase cachedRequest;
    boolean repeatable = false;
    private HttpEntity en = null;
    private RestJob restJob;

    public HttpResultSet(RestJob rj, HttpResponse con, HttpRequestBase req) throws IOException {
        this.setDataName(rj.getJobId() + " Part " + rj.getJobnum());
        this.restJob = rj;
        this.cachedRequest = req;
        this.initDataSource(con);
    }

    public List<DataProvider> createResultDataProviders() {
        ArrayList<DataProvider> dp = new ArrayList<DataProvider>();
        for (DataProvider.JvDataType type : this.restJob.rsd.getResultDataTypes()) {
            dp.add(new SimpleDataProvider(type, this, null));
        }
        return dp;
    }

    public Object[] parseResultSet() throws Exception, Error {
        ArrayList<DataProvider> dp = new ArrayList();
        Object results = null;
        if (this.en == null) {
            throw new Error(MessageManager.getString("error.implementation_error_need_to_have_httpresponse"));
        }
        JalviewDataset ds = this.restJob.newJalviewDataset();
        if (this.en instanceof MultipartEntity) {
            MultipartEntity mpe = (MultipartEntity)this.en;
            JalviewMimeContentHandler handler = new JalviewMimeContentHandler(ds);
            MimeStreamParser parser = new MimeStreamParser();
            parser.setContentHandler((ContentHandler)handler);
            try {
                parser.parse(mpe.getContent());
            }
            catch (MimeException me) {
                this.error = true;
                this.errormessage = "Couldn't parse message from web service.";
                Console.warn("Failed to parse MIME multipart content", me);
                this.en.consumeContent();
            }
            return new ParsePackedSet().getAlignment(ds, handler.getJalviewDataProviders());
        }
        dp = this.createResultDataProviders();
        ParsePackedSet pps = new ParsePackedSet();
        return pps.getAlignment(ds, dp);
    }

    private void initDataSource(HttpResponse con) throws IOException {
        this.en = con.getEntity();
        this.repeatable = this.en.isRepeatable();
        if (!(this.en instanceof MultipartEntity)) {
            String enc;
            String string = enc = this.en.getContentEncoding() == null ? null : this.en.getContentEncoding().getValue();
            if (this.en.getContentType() != null) {
                Console.debug("Result Type: " + this.en.getContentType().toString());
            } else {
                Console.debug("No Result Type Specified.");
            }
            if (enc == null || enc.length() < 1) {
                Console.debug("Assuming 'Default' Result Encoding.");
            } else {
                Console.debug("Result Encoded as : " + enc);
            }
            InputStreamReader br = null;
            try {
                br = enc != null ? new InputStreamReader(this.en.getContent(), enc) : new InputStreamReader(this.en.getContent());
            }
            catch (UnsupportedEncodingException e) {
                Console.error("Can't handle encoding '" + enc + "' for response from webservice.", e);
                this.en.consumeContent();
                this.error = true;
                this.errormessage = "Can't handle encoding for response from webservice";
                return;
            }
            if (br != null) {
                this.dataIn = new BufferedReader(br);
                this.error = false;
            }
        }
    }

    @Override
    public void close() {
        this.dataIn = null;
        this.cachedRequest = null;
        try {
            if (this.en != null) {
                this.en.consumeContent();
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public String getUrl() {
        try {
            return this.cachedRequest.getURI().toURL().toString();
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }
}

