/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class JalviewColourChooser {
    public static void showColourChooser(Component parent, String title, Color initialColour, ColourChooserListener listener) {
        JColorChooser colorChooser = new JColorChooser();
        if (initialColour != null) {
            colorChooser.setColor(initialColour);
        }
        ActionListener onChoose = evt -> listener.colourSelected(colorChooser.getColor());
        ActionListener onCancel = evt -> listener.cancel();
        JDialog dialog = JColorChooser.createDialog(parent, title, true, colorChooser, onChoose, onCancel);
        dialog.setVisible(true);
    }

    public static void showColourChooser(Component parent, String title, final JComponent paintable) {
        ColourChooserListener listener = new ColourChooserListener(){

            @Override
            public void colourSelected(Color c) {
                paintable.setBackground(c);
                paintable.repaint();
            }
        };
        JalviewColourChooser.showColourChooser(parent, title, paintable.getBackground(), listener);
    }

    public static interface ColourChooserListener {
        public void colourSelected(Color var1);

        default public void cancel() {
        }
    }
}

