/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VisibleContigsIterator
implements Iterator<int[]> {
    private List<int[]> vcontigs = new ArrayList<int[]>();
    private int currentPosition = 0;
    private boolean endsAtHidden = false;

    VisibleContigsIterator(int start, int end, List<int[]> hiddenColumns) {
        if (hiddenColumns != null && hiddenColumns.size() > 0) {
            int vstart = start;
            for (int[] region : hiddenColumns) {
                this.endsAtHidden = false;
                int hideStart = region[0];
                int hideEnd = region[1];
                if (hideEnd < vstart) continue;
                if (hideStart > vstart) {
                    int[] contig;
                    if (end - 1 > hideStart - 1) {
                        contig = new int[]{vstart, hideStart - 1};
                        this.vcontigs.add(contig);
                        this.endsAtHidden = true;
                    } else {
                        contig = new int[]{vstart, end - 1};
                        this.vcontigs.add(contig);
                    }
                }
                if ((vstart = hideEnd + 1) < end) continue;
                break;
            }
            if (vstart < end) {
                int[] contig = new int[]{vstart, end - 1};
                this.vcontigs.add(contig);
                this.endsAtHidden = false;
            }
        } else {
            int[] contig = new int[]{start, end - 1};
            this.vcontigs.add(contig);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.vcontigs.size();
    }

    @Override
    public int[] next() {
        int[] result = this.vcontigs.get(this.currentPosition);
        ++this.currentPosition;
        return result;
    }

    public boolean endsAtHidden() {
        return this.endsAtHidden;
    }
}

