/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactListProviderI;
import jalview.datamodel.ContactRange;
import java.awt.Color;

public class ContactListImpl
implements ContactListI {
    ContactListProviderI clist;

    public static ContactListI newContactList(ContactListProviderI list) {
        return new ContactListImpl(list);
    }

    public ContactListImpl(ContactListProviderI list) {
        this.clist = list;
    }

    @Override
    public int getPosition() {
        return this.clist.getPosition();
    }

    @Override
    public double getContactAt(int column) {
        return this.clist.getContactAt(column);
    }

    @Override
    public int getContactHeight() {
        return this.clist.getContactHeight();
    }

    @Override
    public ContactRange getRangeFor(int from_column, int to_column) {
        if (this.clist instanceof ContactListI) {
            return ((ContactListI)this.clist).getRangeFor(from_column, to_column);
        }
        if (from_column < 0) {
            from_column = 0;
        }
        if (to_column >= this.getContactHeight()) {
            to_column = this.getContactHeight() - 1;
        }
        ContactRange cr = new ContactRange();
        cr.setFrom_column(from_column);
        cr.setTo_column(to_column);
        double tot = 0.0;
        for (int i = from_column; i <= to_column; ++i) {
            double contact = this.getContactAt(i);
            tot += contact;
            if (i == from_column) {
                cr.setMin(contact);
                cr.setMax(contact);
                cr.setMinPos(i);
                cr.setMaxPos(i);
                continue;
            }
            if (cr.getMax() < contact) {
                cr.setMax(contact);
                cr.setMaxPos(i);
            }
            if (!(cr.getMin() < contact)) continue;
            cr.setMin(contact);
            cr.setMinPos(i);
        }
        if (tot > 0.0 && to_column > from_column) {
            cr.setMean(tot / (double)(1 + to_column - from_column));
        } else {
            cr.setMean(tot);
        }
        return cr;
    }

    @Override
    public int[] getMappedPositionsFor(int cStart, int cEnd) {
        return this.clist.getMappedPositionsFor(cStart, cEnd);
    }

    @Override
    public Color getColourForGroup() {
        return this.clist.getColourForGroup();
    }
}

