/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;

public class TrimRegionCommand
extends EditCommand {
    int columnsDeleted;

    public TrimRegionCommand(String description, boolean trimLeft, SequenceI[] seqs, int column, AlignmentI al) {
        this.description = description;
        if (trimLeft) {
            if (column == 0) {
                return;
            }
            this.columnsDeleted = column;
            this.setEdit(new EditCommand.Edit((EditCommand)this, EditCommand.Action.CUT, seqs, 0, column, al));
        } else {
            int width = al.getWidth() - column - 1;
            if (width < 1) {
                return;
            }
            this.columnsDeleted = width;
            this.setEdit(new EditCommand.Edit((EditCommand)this, EditCommand.Action.CUT, seqs, column + 1, width, al));
        }
        this.performEdit(0, null);
    }

    @Override
    public int getSize() {
        return this.columnsDeleted;
    }
}

