/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgParser;
import jalview.bin.argparser.StructureLine;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AssociatePdbFileWithSeq;
import jalview.gui.Desktop;
import jalview.gui.StructureViewer;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StructuresFile {
    private boolean superpose = Cache.getDefault("AUTOSUPERIMPOSE", true);
    private String viewerid = null;
    private StructureViewer.ViewerType viewerType = StructureViewer.ViewerType.JMOL;
    private List<StructureLine> structureLines;
    private List<SequenceI> seqs = new ArrayList<SequenceI>();
    private List<PDBEntry> pdbs = new ArrayList<PDBEntry>();
    private AlignmentI alignment;

    public StructuresFile(AlignmentI al, String filename) {
        this.alignment = al;
        this.setStructureLines(this.parseStructuresFile(new File(filename)));
    }

    public boolean isSuperpose() {
        return this.superpose;
    }

    public void setSuperpose(boolean superpose) {
        this.superpose = superpose;
    }

    public String getViewerid() {
        return this.viewerid;
    }

    public void setViewerid(String viewerid) {
        this.viewerid = viewerid;
    }

    public StructureViewer.ViewerType getViewerType() {
        return this.viewerType;
    }

    public void setViewerType(StructureViewer.ViewerType viewerType) {
        this.viewerType = viewerType;
    }

    public List<StructureLine> getStructureLines() {
        return this.structureLines;
    }

    public void setStructureLines(List<StructureLine> structureLines) {
        this.structureLines = structureLines;
    }

    public List<StructureLine> parseStructuresFile(File structuresFile) {
        if (!structuresFile.exists()) {
            String message = Arg.STRUCTURESFILE.argString() + "=\"" + structuresFile.getPath() + "\": File does not exist.";
            Console.warn(message);
            return null;
        }
        List<String> lines = ArgParser.readArgFile(structuresFile);
        ArrayList<StructureLine> structurelines = new ArrayList<StructureLine>();
        if (lines != null) {
            for (String line : lines) {
                if (line.startsWith("--")) {
                    String val = StructuresFile.getArgVal(Arg.VIEWERID, line);
                    if (val != null) {
                        this.setViewerid(val);
                        continue;
                    }
                    val = StructuresFile.getArgVal(Arg.STRUCTUREVIEWER, line);
                    if (val != null) {
                        this.setViewerType(StructureViewer.ViewerType.getFromString(val));
                        continue;
                    }
                    Boolean b = StructuresFile.getArgBoolean(Arg.SUPERPOSE, line);
                    if (b != null) {
                        this.setSuperpose(b);
                        continue;
                    }
                }
                StructureLine sl = new StructureLine(line);
                structurelines.add(sl);
                String structureLocationRef = sl.getSource();
                DataSourceType structureLocationType = AppletFormatAdapter.checkProtocol(structureLocationRef);
                if (DataSourceType.FILE.equals((Object)structureLocationType)) {
                    structureLocationRef = new File(structureLocationRef).getAbsolutePath();
                }
                SequenceI seq = this.alignment.findName(sl.getSeqid());
                PDBEntry pdbEntry = new AssociatePdbFileWithSeq().associatePdbWithSeq(structureLocationRef, structureLocationType, seq, false, Desktop.instance, null, null, false);
                this.pdbs.add(pdbEntry);
                this.seqs.add(seq);
            }
        }
        return structurelines;
    }

    public SequenceI[] getSeqs() {
        SequenceI[] array = new SequenceI[this.seqs.size()];
        return this.seqs.toArray(array);
    }

    public PDBEntry[] getPdbEntries() {
        PDBEntry[] array = new PDBEntry[this.pdbs.size()];
        return this.pdbs.toArray(array);
    }

    private static String getArgVal(Arg a, String line) {
        String s = a.argString() + '=';
        if (line.startsWith(s)) {
            return line.substring(s.length());
        }
        return null;
    }

    private static Boolean getArgBoolean(Arg a, String line) {
        if (line.equals(a.argString())) {
            return true;
        }
        if (line.equals(a.negateArgString())) {
            return false;
        }
        return null;
    }
}

