/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.SequenceIdMatcher;
import jalview.bin.Console;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.DBRefUtils;
import jalview.util.MapList;
import jalview.ws.SequenceFetcherFactory;
import jalview.ws.seqfetcher.ASequenceFetcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CrossRef {
    private AlignmentI dataset;
    private SequenceI[] fromSeqs;
    SequenceIdMatcher matcher;
    List<SequenceI> rseqs;

    public CrossRef(SequenceI[] seqs, AlignmentI ds) {
        this.fromSeqs = seqs;
        this.dataset = ds.getDataset() == null ? ds : ds.getDataset();
    }

    public List<String> findXrefSourcesForSequences(boolean dna) {
        ArrayList<String> sources = new ArrayList<String>();
        for (SequenceI seq : this.fromSeqs) {
            if (seq == null) continue;
            this.findXrefSourcesForSequence(seq, dna, sources);
        }
        sources.remove("EMBL");
        if (dna) {
            sources.remove("ENSEMBL");
            sources.remove("ENSEMBLGENOMES");
        }
        return sources;
    }

    void findXrefSourcesForSequence(SequenceI seq, boolean fromDna, List<String> sources) {
        List<DBRefEntry> rfs = DBRefUtils.selectDbRefs(!fromDna, seq.getDBRefs());
        this.addXrefsToSources(rfs, sources);
        if (this.dataset != null) {
            List<DBRefEntry> lrfs = DBRefUtils.selectDbRefs(fromDna, seq.getDBRefs());
            ArrayList<SequenceI> foundSeqs = new ArrayList<SequenceI>();
            this.searchDatasetXrefs(fromDna, seq, lrfs, foundSeqs, null);
            for (SequenceI rs : foundSeqs) {
                List<DBRefEntry> xrs = DBRefUtils.selectDbRefs(!fromDna, rs.getDBRefs());
                this.addXrefsToSources(xrs, sources);
            }
        }
    }

    void addXrefsToSources(List<DBRefEntry> xrefs, List<String> sources) {
        if (xrefs != null) {
            for (DBRefEntry ref : xrefs) {
                String source = DBRefUtils.getCanonicalName(ref.getSource());
                if (sources.contains(source)) continue;
                sources.add(source);
            }
        }
    }

    public Alignment findXrefSequences(String source, boolean fromDna) {
        this.rseqs = new ArrayList<SequenceI>();
        AlignedCodonFrame cf = new AlignedCodonFrame();
        this.matcher = new SequenceIdMatcher(this.dataset.getSequences());
        SequenceI[] sequenceIArray = this.fromSeqs;
        int n = sequenceIArray.length;
        for (int i = 0; i < n; ++i) {
            SequenceI seq;
            SequenceI dss = seq = sequenceIArray[i];
            while (dss.getDatasetSequence() != null) {
                dss = dss.getDatasetSequence();
            }
            boolean found = false;
            List<DBRefEntry> xrfs = DBRefUtils.selectDbRefs(!fromDna, dss.getDBRefs());
            if ((xrfs == null || xrfs.size() == 0) && this.dataset != null) {
                List<DBRefEntry> lrfs = DBRefUtils.selectDbRefs(fromDna, seq.getDBRefs());
                found = this.searchDatasetXrefs(fromDna, dss, lrfs, this.rseqs, cf);
            }
            if (xrfs == null && !found) continue;
            List<DBRefEntry> sourceRefs = DBRefUtils.searchRefsForSource(xrfs, source);
            Iterator<DBRefEntry> refIterator = sourceRefs.iterator();
            while (refIterator.hasNext()) {
                SequenceI matchedSeq;
                SequenceI mappedTo;
                DBRefEntry xref = refIterator.next();
                found = false;
                if (xref.hasMap() && xref.getMap().getMap().isTripletMap() && (mappedTo = xref.getMap().getTo()) != null) {
                    found = true;
                    SequenceI matchInDataset = this.findInDataset(xref);
                    if (matchInDataset != null && xref.getMap().getTo() != null && matchInDataset != xref.getMap().getTo()) {
                        Console.errPrintln("Implementation problem (reopen JAL-2154): CrossRef.findInDataset seems to have recovered a different sequence than the one explicitly mapped for xref.Found:" + matchInDataset + "\nExpected:" + xref.getMap().getTo() + "\nFor xref:" + xref);
                    }
                    if (matchInDataset != null) {
                        if (!this.rseqs.contains(matchInDataset)) {
                            this.rseqs.add(matchInDataset);
                        }
                        if (xref.getMap().getMap().isTripletMap() && this.dataset.getMapping(seq, matchInDataset) == null && cf.getMappingBetween(seq, matchInDataset) == null) {
                            if (fromDna) {
                                cf.addMap(dss, matchInDataset, xref.getMap().getMap(), xref.getMap().getMappedFromId());
                            } else {
                                cf.addMap(matchInDataset, dss, xref.getMap().getMap().getInverse(), xref.getMap().getMappedFromId());
                            }
                        }
                        refIterator.remove();
                        continue;
                    }
                    Sequence rsq = new Sequence(mappedTo);
                    this.rseqs.add(rsq);
                    if (xref.getMap().getMap().isTripletMap()) {
                        if (fromDna) {
                            cf.addMap(dss, rsq, xref.getMap().getMap(), xref.getMap().getMappedFromId());
                        } else {
                            cf.addMap(rsq, dss, xref.getMap().getMap().getInverse(), xref.getMap().getMappedFromId());
                        }
                    }
                }
                if (!found && (matchedSeq = this.matcher.findIdMatch(xref.getSource() + "|" + xref.getAccessionId())) != null && matchedSeq.isProtein() == fromDna && this.constructMapping(seq, matchedSeq, xref, cf, fromDna)) {
                    found = true;
                }
                if (!found) {
                    found = this.searchDataset(fromDna, dss, xref, this.rseqs, cf, false, 15);
                }
                if (!found) continue;
                refIterator.remove();
            }
            if (sourceRefs.isEmpty()) continue;
            this.retrieveCrossRef(sourceRefs, seq, xrfs, fromDna, cf);
        }
        Alignment ral = null;
        if (this.rseqs.size() > 0) {
            ral = new Alignment(this.rseqs.toArray(new SequenceI[this.rseqs.size()]));
            if (!cf.isEmpty()) {
                this.dataset.addCodonFrame(cf);
            }
        }
        return ral;
    }

    private void retrieveCrossRef(List<DBRefEntry> sourceRefs, SequenceI seq, List<DBRefEntry> xrfs, boolean fromDna, AlignedCodonFrame cf) {
        ASequenceFetcher sftch = SequenceFetcherFactory.getSequenceFetcher();
        SequenceI[] retrieved = null;
        SequenceI dss = seq.getDatasetSequence() == null ? seq : seq.getDatasetSequence();
        this.removeAlreadyRetrievedSeqs(sourceRefs, fromDna);
        if (sourceRefs.size() == 0) {
            return;
        }
        try {
            retrieved = sftch.getSequences(sourceRefs, !fromDna);
        }
        catch (Exception e) {
            Console.errPrintln("Problem whilst retrieving cross references for Sequence : " + seq.getName());
            e.printStackTrace();
        }
        if (retrieved != null) {
            Object retrievedDss;
            boolean addedXref = false;
            ArrayList<SequenceI> newDsSeqs = new ArrayList<SequenceI>();
            ArrayList<SequenceI> doNotAdd = new ArrayList<SequenceI>();
            for (SequenceI sequenceI : retrieved) {
                retrievedDss = sequenceI.getDatasetSequence() == null ? sequenceI : sequenceI.getDatasetSequence();
                addedXref |= this.importCrossRefSeq(cf, newDsSeqs, doNotAdd, dss, (SequenceI)retrievedDss);
            }
            if (!addedXref) {
                this.updateDbrefMappings(seq, xrfs, retrieved, cf, fromDna);
                for (SequenceI sequenceI : retrieved) {
                    retrievedDss = sequenceI.getDatasetSequence() == null ? sequenceI : sequenceI.getDatasetSequence();
                    addedXref |= this.importCrossRefSeq(cf, newDsSeqs, doNotAdd, dss, (SequenceI)retrievedDss);
                }
            }
            for (SequenceI newToSeq : newDsSeqs) {
                if (doNotAdd.contains(newToSeq) || this.dataset.findIndex(newToSeq) != -1) continue;
                this.dataset.addSequence(newToSeq);
                this.matcher.add(newToSeq);
            }
        }
    }

    private void removeAlreadyRetrievedSeqs(List<DBRefEntry> sourceRefs, boolean fromDna) {
        ArrayList<DBRefEntry> dbrSourceSet = new ArrayList<DBRefEntry>(sourceRefs);
        List<SequenceI> dsSeqs = this.dataset.getSequences();
        int nds = dsSeqs.size();
        for (int ids = 0; ids < nds; ++ids) {
            SequenceI sq = dsSeqs.get(ids);
            boolean dupeFound = false;
            if (sq.isProtein() == fromDna) {
                List<DBRefEntry> sqdbrefs = sq.getPrimaryDBRefs();
                int ndb = sqdbrefs.size();
                for (int idb = 0; idb < ndb; ++idb) {
                    DBRefEntry dbr = sqdbrefs.get(idb);
                    List<DBRefEntry> searchrefs = DBRefUtils.searchRefs(dbrSourceSet, dbr, 15);
                    int nsr = searchrefs.size();
                    for (int isr = 0; isr < nsr; ++isr) {
                        sourceRefs.remove(searchrefs.get(isr));
                        dupeFound = true;
                    }
                }
            }
            if (!dupeFound) continue;
            dbrSourceSet.clear();
            dbrSourceSet.addAll(sourceRefs);
        }
    }

    private boolean importCrossRefSeq(AlignedCodonFrame cf, List<SequenceI> newDsSeqs, List<SequenceI> doNotAdd, SequenceI sourceSequence, SequenceI retrievedSequence) {
        boolean imported = false;
        Sequence.DBModList<DBRefEntry> dbr = retrievedSequence.getDBRefs();
        if (dbr != null) {
            int nb = dbr.size();
            for (int ib = 0; ib < nb; ++ib) {
                SequenceI ms;
                Mapping map;
                DBRefEntry dbref = (DBRefEntry)dbr.get(ib);
                SequenceI matched = this.findInDataset(dbref);
                if (matched == sourceSequence) {
                    imported = true;
                }
                if ((map = dbref.getMap()) == null || (ms = map.getTo()) == null || map.getMap() == null || ms == sourceSequence) continue;
                if (matched == null) {
                    newDsSeqs.add(ms);
                    continue;
                }
                try {
                    int sf = map.getMap().getToLowest();
                    int st = map.getMap().getToHighest();
                    SequenceI mappedrg = ms.getSubSequence(sf, st);
                    if (mappedrg.getLength() > 0 && ms.getSequenceAsString().equals(matched.getSequenceAsString())) {
                        String msg = "Mapping updated from " + ms.getName() + " to retrieved crossreference " + matched.getName();
                        Console.outPrintln(msg);
                        Sequence.DBModList<DBRefEntry> toRefs = map.getTo().getDBRefs();
                        if (toRefs != null) {
                            for (DBRefEntry ref : toRefs) {
                                if (dbref.getSrcAccString().equals(ref.getSrcAccString())) continue;
                                matched.addDBRef(ref);
                            }
                        }
                        doNotAdd.add(map.getTo());
                        map.setTo(matched);
                        this.setReverseMapping(matched, dbref, cf);
                        List<SequenceFeature> sfs = ms.getFeatures().getAllFeatures(new String[0]);
                        for (SequenceFeature feat : sfs) {
                            SequenceFeature newFeature = new SequenceFeature(feat){

                                @Override
                                public boolean equals(Object o) {
                                    return super.equals(o, true);
                                }
                            };
                            matched.addSequenceFeature(newFeature);
                        }
                    }
                    cf.addMap(retrievedSequence, map.getTo(), map.getMap());
                    continue;
                }
                catch (Exception e) {
                    Console.errPrintln("Exception when consolidating Mapped sequence set...");
                    e.printStackTrace(System.err);
                }
            }
        }
        if (imported) {
            retrievedSequence.updatePDBIds();
            this.rseqs.add(retrievedSequence);
            if (this.dataset.findIndex(retrievedSequence) == -1) {
                this.dataset.addSequence(retrievedSequence);
                this.matcher.add(retrievedSequence);
            }
        }
        return imported;
    }

    void setReverseMapping(SequenceI mapFrom, DBRefEntry dbref, AlignedCodonFrame mappings) {
        SequenceI mapTo = dbref.getMap().getTo();
        if (mapTo == null) {
            return;
        }
        Sequence.DBModList<DBRefEntry> dbrefs = mapTo.getDBRefs();
        if (dbrefs == null) {
            return;
        }
        for (DBRefEntry toRef : dbrefs) {
            if (!toRef.hasMap() || mapFrom != toRef.getMap().getTo() || toRef.getMap().getMap() != null) continue;
            MapList inverse = dbref.getMap().getMap().getInverse();
            toRef.getMap().setMap(inverse);
            mappings.addMap(mapTo, mapFrom, inverse);
        }
    }

    SequenceI findInDataset(DBRefEntry xref) {
        SequenceI dss;
        if (xref == null || !xref.hasMap() || xref.getMap().getTo() == null) {
            return null;
        }
        SequenceI mapsTo = xref.getMap().getTo();
        String name = xref.getAccessionId();
        String name2 = xref.getSource() + "|" + name;
        SequenceI sequenceI = dss = mapsTo.getDatasetSequence() == null ? mapsTo : mapsTo.getDatasetSequence();
        if (this.dataset.findIndex(dss) > -1) {
            return dss;
        }
        DBRefEntry template = new DBRefEntry(xref.getSource(), null, xref.getAccessionId());
        SequenceI firstIdMatch = null;
        for (SequenceI seq : this.dataset.getSequences()) {
            List<DBRefEntry> match = DBRefUtils.searchRefs(seq.getPrimaryDBRefs(), template, 15);
            if (match != null && match.size() == 1 && CrossRef.sameSequence(seq, dss)) {
                return seq;
            }
            if (firstIdMatch != null || !name.equals(seq.getName()) && !seq.getName().startsWith(name2) || !CrossRef.sameSequence(seq, dss)) continue;
            firstIdMatch = seq;
        }
        return firstIdMatch;
    }

    static boolean sameSequence(SequenceI seq1, SequenceI seq2) {
        if (seq1 == seq2) {
            return true;
        }
        if (seq1 == null || seq2 == null) {
            return false;
        }
        if (seq1.getLength() != seq2.getLength()) {
            return false;
        }
        int length = seq1.getLength();
        for (int i = 0; i < length; ++i) {
            int diff = seq1.getCharAt(i) - seq2.getCharAt(i);
            if (diff == 0 || diff == 32 || diff == -32) continue;
            return false;
        }
        return true;
    }

    void updateDbrefMappings(SequenceI mapFrom, List<DBRefEntry> xrefs, SequenceI[] retrieved, AlignedCodonFrame acf, boolean fromDna) {
        SequenceIdMatcher idMatcher = new SequenceIdMatcher(retrieved);
        for (DBRefEntry xref : xrefs) {
            if (xref.hasMap()) continue;
            String targetSeqName = xref.getSource() + "|" + xref.getAccessionId();
            SequenceI[] matches = idMatcher.findAllIdMatches(targetSeqName);
            if (matches == null) {
                return;
            }
            for (SequenceI seq : matches) {
                this.constructMapping(mapFrom, seq, xref, acf, fromDna);
            }
        }
    }

    boolean constructMapping(SequenceI mapFrom, SequenceI mapTo, DBRefEntry xref, AlignedCodonFrame mappings, boolean fromDna) {
        SequenceI dsmapTo;
        MapList mapping = null;
        SequenceI dsmapFrom = mapFrom.getDatasetSequence() == null ? mapFrom : mapFrom.getDatasetSequence();
        SequenceI sequenceI = dsmapTo = mapTo.getDatasetSequence() == null ? mapTo : mapTo.getDatasetSequence();
        if (dsmapTo.getDBRefs() != null) {
            for (DBRefEntry dbref : dsmapTo.getDBRefs()) {
                String name = dbref.getSource() + "|" + dbref.getAccessionId();
                if (!dbref.hasMap() || !dsmapFrom.getName().startsWith(name)) continue;
                MapList reverse = dbref.getMap().getMap().getInverse();
                xref.setMap(new Mapping(dsmapTo, reverse));
                mappings.addMap(mapFrom, dsmapTo, reverse);
                return true;
            }
        }
        if (fromDna) {
            mapping = AlignmentUtils.mapCdnaToProtein(mapTo, mapFrom);
        } else {
            mapping = AlignmentUtils.mapCdnaToProtein(mapFrom, mapTo);
            if (mapping != null) {
                mapping = mapping.getInverse();
            }
        }
        if (mapping == null) {
            return false;
        }
        xref.setMap(new Mapping(mapTo, mapping));
        if (mapFrom.getDatasetSequence() != null) {
            // empty if block
        }
        if (fromDna) {
            mappings.addMap(mapFrom, mapTo, mapping);
        } else {
            mappings.addMap(mapTo, mapFrom, mapping.getInverse());
        }
        return true;
    }

    private boolean searchDatasetXrefs(boolean fromDna, SequenceI sequenceI, List<DBRefEntry> lrfs, List<SequenceI> foundSeqs, AlignedCodonFrame cf) {
        boolean found = false;
        if (lrfs == null) {
            return false;
        }
        int n = lrfs.size();
        for (int i = 0; i < n; ++i) {
            found |= this.searchDataset(fromDna, sequenceI, lrfs.get(i), foundSeqs, cf, false, 5);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean searchDataset(boolean fromDna, SequenceI fromSeq, DBRefEntry xrf, List<SequenceI> foundSeqs, AlignedCodonFrame mappings, boolean direct, int mode) {
        List<SequenceI> ds;
        boolean found = false;
        if (this.dataset == null) {
            return false;
        }
        if (this.dataset.getSequences() == null) {
            Console.errPrintln("Empty dataset sequence set - NO VECTOR");
            return false;
        }
        List<SequenceI> list = ds = this.dataset.getSequences();
        synchronized (list) {
            for (SequenceI nxt : ds) {
                boolean isDna;
                if (nxt == null) continue;
                if (nxt.getDatasetSequence() != null) {
                    Console.errPrintln("Implementation warning: CrossRef initialised with a dataset alignment with non-dataset sequences in it! (" + nxt.getDisplayId(true) + " has ds reference " + nxt.getDatasetSequence().getDisplayId(true) + ")");
                }
                if (nxt == fromSeq || nxt == fromSeq.getDatasetSequence()) continue;
                boolean bl = isDna = !nxt.isProtein();
                if (direct ? isDna != fromDna : isDna == fromDna) continue;
                Sequence.DBModList<DBRefEntry> poss = nxt.getDBRefs();
                List<DBRefEntry> cands = null;
                cands = DBRefUtils.searchRefs(poss, xrf, mode);
                if (cands.isEmpty() || foundSeqs.contains(nxt)) continue;
                found = true;
                foundSeqs.add(nxt);
                if (mappings == null || direct) continue;
                for (DBRefEntry candidate : cands) {
                    Mapping mapping = candidate.getMap();
                    if (mapping == null) continue;
                    MapList map = mapping.getMap();
                    if (mapping.getTo() == null || map.getFromRatio() == map.getToRatio()) continue;
                    if (map.getFromRatio() == 3) {
                        mappings.addMap(nxt, fromSeq, map);
                        continue;
                    }
                    mappings.addMap(nxt, fromSeq, map.getInverse());
                }
            }
        }
        return found;
    }
}

