/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2;

import ext.edu.ucsf.rbvi.strucviz2.ChimeraChain;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraManager;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraResidue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ChimeraTreeModel
extends DefaultTreeModel {
    private ChimeraManager chimeraManager;
    private JTree navigationTree;
    private int residueDisplay = 1;

    public ChimeraTreeModel(ChimeraManager chimeraManager, JTree tree) {
        super(new DefaultMutableTreeNode());
        this.chimeraManager = chimeraManager;
        this.navigationTree = tree;
        DefaultMutableTreeNode rootNode = this.buildTree();
        this.setRoot(rootNode);
    }

    public void setResidueDisplay(int newDisplay) {
        this.residueDisplay = newDisplay;
    }

    @Override
    public void reload() {
        DefaultMutableTreeNode rootNode = this.buildTree();
        this.setRoot(rootNode);
        super.reload();
    }

    public void rebuildTree() {
        DefaultMutableTreeNode rootNode = this.buildTree();
        DefaultTreeModel model = (DefaultTreeModel)this.navigationTree.getModel();
        model.setRoot(rootNode);
        model.reload();
    }

    private DefaultMutableTreeNode buildTree() {
        int modelCount = this.chimeraManager.getChimeraModelsCount(true);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(modelCount + " Open Chimera Models");
        TreePath rootPath = new TreePath(rootNode);
        TreePath path = null;
        DefaultMutableTreeNode model = null;
        for (ChimeraModel chimeraModel : this.chimeraManager.getChimeraModels()) {
            model = new DefaultMutableTreeNode(chimeraModel);
            path = rootPath.pathByAddingChild(model);
            chimeraModel.setUserData(path);
            this.addChainNodes(chimeraModel, model, path);
            rootNode.add(model);
        }
        return rootNode;
    }

    private void addChainNodes(ChimeraModel chimeraModel, DefaultMutableTreeNode treeModel, TreePath treePath) {
        DefaultMutableTreeNode chain = null;
        TreePath chainPath = null;
        Collection<ChimeraChain> chainList = chimeraModel.getChains();
        if (chainList.size() == 0) {
            this.addResidues(chimeraModel.getResidues(), treeModel, treePath);
            return;
        }
        for (ChimeraChain chimeraChain : chainList) {
            chain = new DefaultMutableTreeNode(chimeraChain);
            chainPath = treePath.pathByAddingChild(chain);
            chimeraChain.setUserData(chainPath);
            this.addResidues(chimeraChain.getResidues(), chain, chainPath);
            treeModel.add(chain);
        }
    }

    private void addResidues(Collection<ChimeraResidue> residues, DefaultMutableTreeNode treeModel, TreePath treePath) {
        DefaultMutableTreeNode residue = null;
        TreePath residuePath = null;
        ArrayList<ChimeraResidue> sortedResidues = new ArrayList<ChimeraResidue>(residues);
        Collections.sort(sortedResidues);
        for (ChimeraResidue res : sortedResidues) {
            ChimeraResidue.setDisplayType(this.residueDisplay);
            residue = new DefaultMutableTreeNode(res);
            residuePath = treePath.pathByAddingChild(residue);
            res.setUserData(residuePath);
            treeModel.add(residue);
        }
    }
}

