/*
 * Decompiled with CFR 0.152.
 */
package intervalstore.impl;

import intervalstore.api.IntervalI;
import intervalstore.impl.NCList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class NCNode<T extends IntervalI>
implements IntervalI {
    private T region;
    private NCList<T> subregions;

    NCNode(List<T> ranges) {
        if (ranges.isEmpty()) {
            throw new IllegalArgumentException("List may not be empty");
        }
        this.region = (IntervalI)ranges.get(0);
        if (ranges.size() > 1) {
            this.subregions = new NCList<T>(ranges.subList(1, ranges.size()));
        }
    }

    NCNode(T range) {
        this.region = range;
    }

    @Override
    public int getBegin() {
        return this.region.getBegin();
    }

    @Override
    public int getEnd() {
        return this.region.getEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(10 * this.size());
        sb.append(this.region.toString());
        if (this.subregions != null) {
            sb.append(" ").append(this.subregions.toString());
        }
        return sb.toString();
    }

    void prettyPrint(StringBuilder sb, int offset, int indent) {
        int i = 0;
        while (i < offset) {
            sb.append(" ");
            ++i;
        }
        sb.append(this.region.toString());
        if (this.subregions != null) {
            sb.append(System.lineSeparator());
            this.subregions.prettyPrint(sb, offset + 2, indent);
        }
    }

    void findOverlaps(long from, long to, List<T> result) {
        if ((long)this.region.getBegin() <= to && (long)this.region.getEnd() >= from) {
            result.add(this.region);
            if (this.subregions != null) {
                this.subregions.findOverlaps(from, to, result);
            }
        }
    }

    synchronized void addNode(NCNode<T> entry) {
        if (!this.region.containsInterval(entry)) {
            throw new IllegalArgumentException(String.format("adding improper subrange %d-%d to range %d-%d", entry.getBegin(), entry.getEnd(), this.region.getBegin(), this.region.getEnd()));
        }
        if (this.subregions == null) {
            this.subregions = new NCList();
        }
        this.subregions.addNode(entry);
    }

    boolean isValid() {
        if (this.region != null && this.region.getBegin() > this.region.getEnd()) {
            return false;
        }
        if (this.subregions == null) {
            return true;
        }
        if (this.subregions.isEmpty()) {
            return false;
        }
        return this.subregions.isValid(this.getBegin(), this.getEnd());
    }

    void getEntries(List<T> entries) {
        entries.add(this.region);
        if (this.subregions != null) {
            this.subregions.getEntries(entries);
        }
    }

    boolean contains(IntervalI entry) {
        if (entry == null) {
            return false;
        }
        if (entry.equals(this.region)) {
            return true;
        }
        return this.subregions == null ? false : this.subregions.contains(entry);
    }

    T getRegion() {
        return this.region;
    }

    NCList<T> getSubRegions() {
        return this.subregions;
    }

    int size() {
        return this.subregions == null ? 1 : 1 + this.subregions.size();
    }

    int getDepth() {
        return this.subregions == null ? 1 : 1 + this.subregions.getDepth();
    }

    public Iterator<T> iterator() {
        return new NCNodeIterator();
    }

    boolean remove(T entry) {
        if (this.region.equals(entry)) {
            throw new IllegalArgumentException("NCNode can't remove self");
        }
        if (this.subregions == null) {
            return false;
        }
        if (this.subregions.remove(entry)) {
            if (this.subregions.isEmpty()) {
                this.subregions = null;
            }
            return true;
        }
        return false;
    }

    private class NCNodeIterator
    implements Iterator<T> {
        boolean first = true;
        Iterator<T> subregionIterator;

        private NCNodeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.first || this.subregionIterator != null && this.subregionIterator.hasNext();
        }

        @Override
        public T next() {
            if (this.first) {
                this.subregionIterator = NCNode.this.subregions == null ? null : NCNode.this.subregions.iterator();
                this.first = false;
                return NCNode.this.region;
            }
            if (this.subregionIterator == null || !this.subregionIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            return (IntervalI)this.subregionIterator.next();
        }
    }
}

