/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.newGUI;

import fr.orsay.lri.varna.applications.newGUI.VARNAGUIModel;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class VARNAGUITreeModel
extends DefaultTreeModel {
    private TreeSet<String> _folders = new TreeSet();
    private TreeSet<String> _ids = new TreeSet();
    private Hashtable<String, TreeSet<VARNAGUIModel>> _criterionToFiles = new Hashtable();
    private Hashtable<String, DefaultMutableTreeNode> _criterionToNodes = new Hashtable();
    private ArrayList<DefaultMutableTreeNode> _fileNodes = new ArrayList();
    private SORT_MODE _mode = SORT_MODE.PATH;
    FilenameFilter _f = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".dbn") || string.toLowerCase().endsWith(".ct") || string.toLowerCase().endsWith(".bpseq") || string.toLowerCase().endsWith(".rnaml");
        }
    };

    public VARNAGUITreeModel() {
        super(new DefaultMutableTreeNode("Folders"));
    }

    public void removeFolder(String string) {
        if (this._mode == SORT_MODE.PATH) {
            int n = this._folders.headSet(string).size();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot().getChildAt(n);
            defaultMutableTreeNode.removeAllChildren();
            this.reload(defaultMutableTreeNode);
            this.getRoot().remove(defaultMutableTreeNode);
            this._criterionToNodes.remove(string);
            this._criterionToFiles.remove(string);
        } else if (this._mode == SORT_MODE.ID) {
            Object object;
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            for (DefaultMutableTreeNode defaultMutableTreeNode : this._fileNodes) {
                object = (VARNAGUIModel)defaultMutableTreeNode.getUserObject();
                if (!((VARNAGUIModel)object).getFolder().equals(string)) continue;
                arrayList.add(defaultMutableTreeNode);
            }
            for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
                this._fileNodes.remove(defaultMutableTreeNode);
                object = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                ((DefaultMutableTreeNode)object).remove(defaultMutableTreeNode);
            }
        }
        this._folders.remove(string);
    }

    public DefaultMutableTreeNode insertGroupNode(String string, TreeSet<String> treeSet) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getRoot();
        int n = treeSet.headSet(string).size();
        defaultMutableTreeNode2.insert(defaultMutableTreeNode, n);
        this.reload(defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    public void insertLeafNode(DefaultMutableTreeNode defaultMutableTreeNode, VARNAGUIModel vARNAGUIModel, TreeSet<VARNAGUIModel> treeSet) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(vARNAGUIModel);
        int n = treeSet.headSet(vARNAGUIModel).size();
        defaultMutableTreeNode.insert(defaultMutableTreeNode2, n);
        this._fileNodes.add(defaultMutableTreeNode2);
    }

    public DefaultMutableTreeNode addFolder(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        try {
            if (!this._folders.contains(string)) {
                System.out.println("Folder: " + string);
                File file = new File(string);
                if (file.isDirectory()) {
                    string = file.getCanonicalPath();
                    this._folders.add(string);
                    if (this._mode == SORT_MODE.PATH) {
                        System.out.println("  Adding: " + string);
                        defaultMutableTreeNode = this.insertGroupNode(string, this._folders);
                        this._criterionToNodes.put(string, defaultMutableTreeNode);
                        this._criterionToFiles.put(string, new TreeSet());
                    }
                    for (File file2 : file.listFiles(this._f)) {
                        this.addFile(string, file2.getCanonicalPath());
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return defaultMutableTreeNode;
    }

    private void addFile(String string, String string2) {
        System.out.println("  => " + string2);
        VARNAGUIModel vARNAGUIModel = new VARNAGUIModel(string, string2);
        if (this._mode == SORT_MODE.PATH) {
            this.addFolder(string);
            this.insertLeafNode(this._criterionToNodes.get(string), vARNAGUIModel, this._criterionToFiles.get(string));
        } else if (this._mode == SORT_MODE.ID) {
            String string3 = vARNAGUIModel.getID();
            if (!this._criterionToNodes.containsKey(string3)) {
                this._criterionToNodes.put(string3, this.insertGroupNode(string3, this._ids));
            }
            this.insertLeafNode(this._criterionToNodes.get(string3), vARNAGUIModel, this._criterionToFiles.get(string3));
        }
    }

    @Override
    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    public ArrayList<String> getFolders() {
        ArrayList<String> arrayList = new ArrayList<String>(this._folders);
        return arrayList;
    }

    public FilenameFilter getFileNameFilter() {
        return this._f;
    }

    public void setFileNameFilter(FilenameFilter filenameFilter) {
        this._f = filenameFilter;
    }

    public static enum SORT_MODE {
        PATH,
        ID;

    }
}

