/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.api.GenericZipInputStream;
import javajs.api.ZInputStream;
import javajs.util.BArray;
import javajs.util.CBZip2InputStream;
import javajs.util.Lst;
import javajs.util.Rdr;
import javajs.util.SB;

public class ZipTools {
    private static byte[] b512;

    public static ZInputStream newZipInputStream(InputStream is) {
        return ZipTools.newZIS(is);
    }

    private static ZInputStream newZIS(InputStream is) {
        return is instanceof ZInputStream ? (ZInputStream)((Object)is) : (is instanceof BufferedInputStream ? new GenericZipInputStream(is) : new GenericZipInputStream(new BufferedInputStream(is)));
    }

    public static Object getZipFileDirectory(BufferedInputStream bis, String[] list, int listPtr, boolean asBufferedInputStream) {
        boolean justDir = list == null || listPtr >= list.length;
        String fileName = justDir ? "." : list[listPtr];
        boolean isTar = Rdr.isTar(bis);
        if (isTar) {
            return ZipTools.getTarFileDirectory(bis, fileName, asBufferedInputStream);
        }
        if (justDir) {
            return ZipTools.getZipDirectoryAsStringAndClose(bis);
        }
        bis = ZipTools.getPngZipStream(bis, true);
        ZipInputStream zis = new ZipInputStream(bis);
        try {
            ZipEntry ze;
            boolean asBinaryString;
            boolean isAll = fileName.equals(".");
            if (isAll || fileName.lastIndexOf("/") == fileName.length() - 1) {
                ZipEntry ze2;
                SB ret = new SB();
                while ((ze2 = zis.getNextEntry()) != null) {
                    String name = ze2.getName();
                    if (!isAll && !name.startsWith(fileName)) continue;
                    ret.append(name).appendC('\n');
                }
                String str = ret.toString();
                return asBufferedInputStream ? Rdr.getBIS(str.getBytes()) : str;
            }
            int pt = fileName.indexOf(":asBinaryString");
            boolean bl = asBinaryString = pt > 0;
            if (asBinaryString) {
                fileName = fileName.substring(0, pt);
            }
            fileName = fileName.replace('\\', '/');
            while ((ze = zis.getNextEntry()) != null && !fileName.equals(ze.getName())) {
            }
            byte[] bytes = ze == null ? null : Rdr.getLimitedStreamBytes(zis, ze.getSize());
            ze = null;
            zis.close();
            if (bytes == null) {
                return "";
            }
            if (Rdr.isZipB(bytes) || Rdr.isPngZipB(bytes)) {
                return ZipTools.getZipFileDirectory(Rdr.getBIS(bytes), list, ++listPtr, asBufferedInputStream);
            }
            if (asBufferedInputStream) {
                return Rdr.getBIS(bytes);
            }
            if (asBinaryString) {
                SB ret = new SB();
                for (int i = 0; i < bytes.length; ++i) {
                    ret.append(Integer.toHexString(bytes[i] & 0xFF)).appendC(' ');
                }
                return ret.toString();
            }
            if (Rdr.isGzipB(bytes)) {
                bytes = Rdr.getLimitedStreamBytes(ZipTools.getUnGzippedInputStream(bytes), -1L);
            }
            return Rdr.fixUTF(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Object getTarFileDirectory(BufferedInputStream bis, String fileName, boolean asBufferedInputStream) {
        try {
            boolean isAll = fileName.equals(".");
            if (isAll || fileName.lastIndexOf("/") == fileName.length() - 1) {
                SB ret = new SB();
                ZipTools.getTarContents(bis, fileName, ret);
                String str = ret.toString();
                return asBufferedInputStream ? Rdr.getBIS(str.getBytes()) : str;
            }
            fileName = fileName.replace('\\', '/');
            byte[] bytes = ZipTools.getTarContents(bis, fileName, null);
            bis.close();
            return bytes == null ? "" : (asBufferedInputStream ? Rdr.getBIS(bytes) : Rdr.fixUTF(bytes));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] getZipFileContentsAsBytes(BufferedInputStream bis, String[] list, int listPtr) {
        byte[] ret = new byte[]{};
        String fileName = list[listPtr];
        if (fileName.lastIndexOf("/") == fileName.length() - 1) {
            return ret;
        }
        try {
            ZipEntry ze;
            if (Rdr.isTar(bis)) {
                return ZipTools.getTarContents(bis, fileName, null);
            }
            bis = ZipTools.getPngZipStream(bis, true);
            ZipInputStream zis = new ZipInputStream(bis);
            while ((ze = zis.getNextEntry()) != null) {
                if (!fileName.equals(ze.getName())) continue;
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, ze.getSize());
                return (Rdr.isZipB(bytes) || Rdr.isPngZipB(bytes)) && ++listPtr < list.length ? ZipTools.getZipFileContentsAsBytes(Rdr.getBIS(bytes), list, listPtr) : bytes;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static byte[] getTarContents(BufferedInputStream bis, String fileName, SB sb) throws IOException {
        if (b512 == null) {
            b512 = new byte[512];
        }
        int len = fileName.length();
        while (bis.read(b512, 0, 512) > 0) {
            byte[] bytes = ZipTools.getTarFile(bis, fileName, len, sb, null, false);
            if (bytes == null) continue;
            return bytes;
        }
        return null;
    }

    private static byte[] getTarFile(BufferedInputStream bis, String fileName, int len, SB sb, Map<String, Object> cache, boolean oneFile) throws IOException {
        int j = 124;
        while (b512[j] == 48) {
            ++j;
        }
        boolean isAll = sb != null && fileName.equals(".");
        int nbytes = 0;
        while (j < 135) {
            nbytes = (nbytes << 3) + (b512[j++] - 48);
        }
        if (nbytes == 0) {
            return null;
        }
        String fname = new String(b512, 0, 100).trim();
        String prefix = new String(b512, 345, 155).trim();
        String name = prefix + fname;
        boolean found = false;
        if (sb != null) {
            if (name.length() == 0) {
                return null;
            }
            if (isAll || (oneFile ? name.equalsIgnoreCase(fileName) : name.startsWith(fileName))) {
                found = cache != null;
                sb.append(name).appendC('\n');
            }
            len = -1;
        }
        int nul = (512 - nbytes % 512) % 512;
        if (!(found || len == name.length() && fileName.equals(name))) {
            int nBlocks;
            int i = nBlocks = nbytes + nul >> 9;
            while (--i >= 0) {
                bis.read(b512, 0, 512);
            }
            return null;
        }
        byte[] bytes = Rdr.getLimitedStreamBytes(bis, nbytes);
        if (cache != null) {
            cache.put(name, new BArray(bytes));
            bis.read(b512, 0, nul);
        }
        return bytes;
    }

    public static String getZipDirectoryAsStringAndClose(BufferedInputStream bis) {
        SB sb = new SB();
        String[] s = new String[]{};
        try {
            s = ZipTools.getZipDirectoryOrErrorAndClose(bis, null);
            bis.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]).appendC('\n');
        }
        return sb.toString();
    }

    public static String[] getZipDirectoryAndClose(BufferedInputStream bis, String manifestID) {
        String[] s = new String[]{};
        try {
            s = ZipTools.getZipDirectoryOrErrorAndClose(bis, manifestID);
            bis.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return s;
    }

    private static String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bis, String manifestID) throws IOException {
        ZipEntry ze;
        bis = ZipTools.getPngZipStream(bis, true);
        Lst<String> v = new Lst<String>();
        ZipInputStream zis = new ZipInputStream(bis);
        String manifest = null;
        while ((ze = zis.getNextEntry()) != null) {
            String fileName = ze.getName();
            if (manifestID != null && fileName.startsWith(manifestID)) {
                manifest = ZipTools.getStreamAsString(zis);
                continue;
            }
            if (fileName.startsWith("__MACOS")) continue;
            v.addLast(fileName);
        }
        zis.close();
        if (manifestID != null) {
            v.add(0, manifest == null ? "" : manifest + "\n############\n");
        }
        return v.toArray(new String[v.size()]);
    }

    public static String getStreamAsString(InputStream is) throws IOException {
        return Rdr.fixUTF(Rdr.getLimitedStreamBytes(is, -1L));
    }

    public static InputStream newGZIPInputStream(InputStream is) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(is, 512));
    }

    public static InputStream newBZip2InputStream(InputStream is) throws IOException {
        is.read(new byte[2], 0, 2);
        return new BufferedInputStream(new CBZip2InputStream(is));
    }

    public static BufferedInputStream getUnGzippedInputStream(byte[] bytes) {
        try {
            return ZipTools.getUnzippedInputStream(Rdr.getBIS(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getGzippedBytesAsString(byte[] bytes) {
        String s;
        try {
            BufferedInputStream bis = ZipTools.getUnGzippedInputStream(bytes);
            s = ZipTools.getStreamAsString(bis);
            bis.close();
        }
        catch (Exception e) {
            s = "";
        }
        return s;
    }

    public static BufferedInputStream getUnzippedInputStream(BufferedInputStream bis) throws IOException {
        while (Rdr.isGzipS(bis)) {
            bis = new BufferedInputStream(ZipTools.newGZIPInputStream(bis));
        }
        return bis;
    }

    public static BufferedInputStream getUnzippedInputStreamBZip2(BufferedInputStream bis) throws IOException {
        while (Rdr.isBZip2S(bis)) {
            bis = new BufferedInputStream(ZipTools.newBZip2InputStream(bis));
        }
        return bis;
    }

    static void getPngZipPointAndCount(BufferedInputStream bis, int[] pt_count) {
        bis.mark(75);
        try {
            byte[] data = Rdr.getLimitedStreamBytes(bis, 74L);
            bis.reset();
            int pt = 0;
            int i = 64;
            int f = 1;
            while (--i > 54) {
                pt += (data[i] - 48) * f;
                f *= 10;
            }
            int n = 0;
            int i2 = 74;
            int f2 = 1;
            while (--i2 > 64) {
                n += (data[i2] - 48) * f2;
                f2 *= 10;
            }
            pt_count[0] = pt;
            pt_count[1] = n;
        }
        catch (Throwable e) {
            pt_count[1] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedInputStream getPngZipStream(BufferedInputStream bis, boolean asNewStream) {
        if (!Rdr.isPngZipStream(bis)) {
            return bis;
        }
        byte[] data = new byte[]{};
        bis.mark(75);
        try {
            int[] pt_count = new int[2];
            ZipTools.getPngZipPointAndCount(bis, pt_count);
            if (pt_count[1] != 0) {
                int pt = pt_count[0];
                while (pt > 0) {
                    pt = (int)((long)pt - bis.skip(pt));
                }
                if (!asNewStream) {
                    BufferedInputStream bufferedInputStream = bis;
                    return bufferedInputStream;
                }
                data = Rdr.getLimitedStreamBytes(bis, pt_count[1]);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (asNewStream) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
        return Rdr.getBIS(data);
    }

    public static void addZipEntry(Object zos, String fileName) throws IOException {
        ((ZipOutputStream)zos).putNextEntry(new ZipEntry(fileName));
    }

    public static void closeZipEntry(Object zos) throws IOException {
        ((ZipOutputStream)zos).closeEntry();
    }

    public static Object getZipOutputStream(Object bos) {
        return new ZipOutputStream((OutputStream)bos);
    }

    public static int getCrcValue(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes, 0, bytes.length);
        return (int)crc.getValue();
    }

    public static void readFileAsMap(BufferedInputStream bis, Map<String, Object> bdata, String name) {
        ZipTools.readFileAsMapStatic(bis, bdata, name);
    }

    private static void readFileAsMapStatic(BufferedInputStream bis, Map<String, Object> bdata, String name) {
        int pt = name == null ? -1 : name.indexOf("|");
        name = pt >= 0 ? name.substring(pt + 1) : null;
        try {
            boolean isZip = false;
            if (Rdr.isPngZipStream(bis)) {
                boolean isImage = "_IMAGE_".equals(name);
                if (name == null || isImage) {
                    bdata.put(isImage ? "_DATA_" : "_IMAGE_", new BArray(ZipTools.getPngImageBytes(bis)));
                }
                isZip = !isImage;
            } else if (Rdr.isZipS(bis)) {
                isZip = true;
            } else if (Rdr.isTar(bis)) {
                ZipTools.cacheTarContentsStatic(bis, name, bdata);
            } else if (name == null) {
                bdata.put("_DATA_", new BArray(Rdr.getLimitedStreamBytes(bis, -1L)));
            } else {
                throw new IOException("ZIP file " + name + " not found");
            }
            if (isZip) {
                ZipTools.cacheZipContentsStatic(bis, name, bdata, true);
            }
            bdata.put("$_BINARY_$", Boolean.TRUE);
        }
        catch (IOException e) {
            bdata.clear();
            bdata.put("_ERROR_", e.getMessage());
        }
    }

    public static String cacheZipContents(BufferedInputStream bis, String fileName, Map<String, Object> cache, boolean asByteArray) {
        return ZipTools.cacheZipContentsStatic(bis, fileName, cache, asByteArray);
    }

    private static String cacheZipContentsStatic(BufferedInputStream bis, String fileName, Map<String, Object> cache, boolean asByteArray) {
        String zipEntryRoot;
        ZipInputStream zis = (ZipInputStream)((Object)ZipTools.newZIS(bis));
        SB listing = new SB();
        long n = 0L;
        if (fileName != null && fileName.endsWith("/.")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        boolean isPath = fileName != null && fileName.endsWith("/");
        boolean oneFile = fileName != null && !isPath && asByteArray;
        int pt = oneFile ? fileName.indexOf("|") : -1;
        String string = zipEntryRoot = pt >= 0 ? fileName : null;
        if (pt >= 0) {
            fileName = fileName.substring(0, pt);
        }
        String prefix = fileName == null || isPath ? "" : fileName + "|";
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                Object object;
                if (ze.isDirectory()) continue;
                String name = ze.getName();
                if (fileName != null) {
                    if (oneFile) {
                        if (!name.equalsIgnoreCase(fileName)) {
                            continue;
                        }
                    } else {
                        if (isPath && !name.startsWith(fileName)) continue;
                        listing.append(name).appendC('\n');
                    }
                }
                long nBytes = ze.getSize();
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, nBytes);
                if (zipEntryRoot != null) {
                    ZipTools.readFileAsMapStatic(Rdr.getBIS(bytes), cache, zipEntryRoot);
                    return null;
                }
                n += (long)bytes.length;
                if (asByteArray) {
                    BArray bArray;
                    object = bArray;
                    bArray = new BArray(bytes);
                } else {
                    object = bytes;
                }
                Object o = object;
                cache.put(oneFile ? "_DATA_" : prefix + name, o);
                if (!oneFile) continue;
                break;
            }
            zis.close();
        }
        catch (Exception e) {
            try {
                zis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (n == 0L || fileName == null) {
            return null;
        }
        System.out.println("ZipTools cached " + n + " bytes from " + fileName);
        return listing.toString();
    }

    private static String cacheTarContentsStatic(BufferedInputStream bis, String fileName, Map<String, Object> cache) {
        SB listing = new SB();
        long n = 0L;
        if (fileName != null && fileName.endsWith("/.")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        boolean isPath = fileName != null && fileName.endsWith("/");
        boolean oneFile = fileName != null && !isPath;
        try {
            if (b512 == null) {
                b512 = new byte[512];
            }
            while (bis.read(b512, 0, 512) > 0) {
                byte[] bytes = ZipTools.getTarFile(bis, fileName == null ? "." : fileName, -1, listing, cache, oneFile);
                if (bytes == null) continue;
                n += (long)bytes.length;
                if (!oneFile) continue;
                break;
            }
            bis.close();
        }
        catch (Exception e) {
            try {
                bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (n == 0L || fileName == null) {
            return null;
        }
        System.out.println("ZipTools cached " + n + " bytes from " + fileName);
        return listing.toString();
    }

    private static byte[] getPngImageBytes(BufferedInputStream bis) {
        try {
            if (Rdr.isPngZipStream(bis)) {
                int[] pt_count = new int[2];
                ZipTools.getPngZipPointAndCount(bis, pt_count);
                if (pt_count[1] != 0) {
                    return ZipTools.deActivatePngZipB(Rdr.getLimitedStreamBytes(bis, pt_count[0]));
                }
            }
            return Rdr.getLimitedStreamBytes(bis, -1L);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static byte[] deActivatePngZipB(byte[] bytes) {
        if (Rdr.isPngZipB(bytes)) {
            bytes[51] = 32;
        }
        return bytes;
    }
}

