/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Console;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SimpleBlastFile
extends AlignFile {
    StringBuffer headerLines;
    StringBuffer footerLines;
    Vector seqids;

    public SimpleBlastFile() {
    }

    public SimpleBlastFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public SimpleBlastFile(FileParse source) throws IOException {
        super(source);
    }

    @Override
    public void initData() {
        super.initData();
        this.headerLines = new StringBuffer();
        this.footerLines = new StringBuffer();
        this.seqids = new Vector();
    }

    @Override
    public void parse() throws IOException {
        String line;
        char gapc = ' ';
        Hashtable<String, Object> seqhash = new Hashtable<String, Object>();
        boolean inAlignments = false;
        int padding = -1;
        int numcol = -1;
        int aligcol = -1;
        int lastcol = -1;
        long qlen = 0L;
        boolean padseq = false;
        while ((line = this.nextLine()) != null) {
            String ln;
            if (line.indexOf("ALIGNMENTS") == 0) {
                inAlignments = true;
                continue;
            }
            if (inAlignments) {
                if (line.trim().length() == 0) continue;
                if (line.indexOf("Query") == 0) {
                    padding = -1;
                    numcol = -1;
                    aligcol = -1;
                    lastcol = -1;
                    int mLen = line.length();
                    for (int p = 5; p < mLen; ++p) {
                        char c = line.charAt(p);
                        if (c >= '0' && c <= '9') {
                            if (numcol == -1) {
                                numcol = p;
                                continue;
                            }
                            if (aligcol == -1 || lastcol != -1) continue;
                            lastcol = p;
                            continue;
                        }
                        if (c >= 'A' && c <= 'z') {
                            if (aligcol != -1) continue;
                            aligcol = p;
                            padding = -1;
                            continue;
                        }
                        if (padding != -1) continue;
                        padding = p;
                    }
                    if (padding == -1) {
                        padding = aligcol;
                    }
                }
                if (line.indexOf("Database:") > -1 || aligcol == -1 || numcol == -1 || lastcol == -1 || line.length() < lastcol) {
                    inAlignments = false;
                } else {
                    String sqid = line.substring(0, numcol).trim();
                    String stindx = line.substring(numcol, aligcol).trim();
                    String aligseg = line.substring(aligcol, padding);
                    String endindx = line.substring(lastcol).trim();
                    long rstart = 1L;
                    long rend = 0L;
                    try {
                        rstart = Long.parseLong(stindx);
                    }
                    catch (Exception e) {
                        Console.errPrintln("Couldn't parse '" + stindx + "' as start of row");
                    }
                    try {
                        rend = Long.parseLong(endindx);
                    }
                    catch (Exception e) {
                        Console.errPrintln("Couldn't parse '" + endindx + "' as end of row");
                    }
                    Vector<Object[]> seqentries = (Vector<Object[]>)seqhash.get(sqid);
                    if (seqentries == null) {
                        seqentries = new Vector<Object[]>();
                        seqhash.put(sqid, seqentries);
                        this.seqids.addElement(sqid);
                    }
                    Object[] seqentry = null;
                    Enumeration sqent = seqentries.elements();
                    while (seqentry == null && sqent.hasMoreElements()) {
                        seqentry = (Object[])sqent.nextElement();
                        if (((long[])seqentry[1])[1] + 1L == rstart) continue;
                        seqentry = null;
                    }
                    padseq = false;
                    if (seqentry == null) {
                        padseq = true;
                        seqentry = new Object[]{new StringBuffer(), new long[]{rstart, rend}};
                        seqentries.addElement(seqentry);
                        seqhash.put(sqid, seqentry);
                    }
                    if (sqid.equals("Query")) {
                        qlen = ((StringBuffer)seqentry[0]).length();
                    }
                    StringBuffer sqs = (StringBuffer)seqentry[0];
                    if (padseq) {
                        for (long c = (long)sqs.length(); c < qlen; ++c) {
                            sqs.append(gapc);
                        }
                    }
                    sqs.append(aligseg);
                    if (rend > 0L) {
                        ((long[])seqentry[1])[1] = rend;
                    }
                }
            }
            if (inAlignments || (ln = line.trim()).length() <= 0) continue;
            StringBuffer addto = seqhash.size() > 0 ? this.footerLines : this.headerLines;
            addto.append(line);
            addto.append("\n");
        }
        if (seqhash.size() > 0) {
            Enumeration seqid = this.seqids.elements();
            while (seqid.hasMoreElements()) {
                String idstring = (String)seqid.nextElement();
                Object[] seqentry = (Object[])seqhash.get(idstring);
                try {
                    Sequence newseq = new Sequence(idstring, ((StringBuffer)seqentry[0]).toString(), (int)((long[])seqentry[1])[0], (int)((long[])seqentry[1])[1]);
                    if (newseq.getEnd() == 0) {
                        newseq.setEnd(newseq.findPosition(newseq.getLength()));
                    }
                    this.seqs.addElement(newseq);
                }
                catch (Exception e) {
                    if (this.warningMessage == null) {
                        this.warningMessage = "";
                    }
                    this.warningMessage = this.warningMessage + "Couldn't add Sequence - ID is '" + idstring + "' : Exception was " + e.toString() + "\n";
                }
            }
            if (this.headerLines.length() > 1) {
                this.setAlignmentProperty("HEADER", this.headerLines.toString());
            }
            if (this.footerLines.length() > 1) {
                this.setAlignmentProperty("FOOTER", this.footerLines.toString());
            }
        }
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        return new String("Not Implemented.");
    }
}

