/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.FeatureColourI;
import jalview.bin.Console;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.util.StringUtils;
import jalview.util.UrlLink;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class SequenceAnnotationReport {
    private static final int MAX_DESCRIPTION_LENGTH = 40;
    private static final String COMMA = ",";
    private static final String ELLIPSIS = "...";
    private static final int MAX_REFS_PER_SOURCE = 4;
    private static final int MAX_SOURCES = 5;
    private static String linkImageURL;
    private static Comparator<DBRefEntry> comparator;
    private boolean forTooltip;

    public SequenceAnnotationReport(boolean isForTooltip) {
        this.forTooltip = isForTooltip;
        if (linkImageURL == null) {
            linkImageURL = this.getClass().getResource("/images/link.gif").toString();
        }
    }

    public int appendFeatures(StringBuilder sb, int residuePos, List<SequenceFeature> features, FeatureRendererModel fr, int maxlength) {
        for (int i = 0; i < features.size(); ++i) {
            SequenceFeature feature = features.get(i);
            if (!this.appendFeature(sb, residuePos, fr, feature, null, maxlength)) continue;
            return features.size() - i;
        }
        return 0;
    }

    public int appendFeatures(StringBuilder sb, int residuePos, MappedFeatures mf, FeatureRendererModel fr, int maxlength) {
        for (int i = 0; i < mf.features.size(); ++i) {
            SequenceFeature feature = mf.features.get(i);
            if (!this.appendFeature(sb, residuePos, fr, feature, mf, maxlength)) continue;
            return mf.features.size() - i;
        }
        return 0;
    }

    boolean appendFeature(StringBuilder sb0, int rpos, FeatureRendererModel fr, SequenceFeature feature, MappedFeatures mf, int maxlength) {
        boolean linkOnly;
        int begin = feature.getBegin();
        int end = feature.getEnd();
        int[] beginRange = null;
        int[] endRange = null;
        if (mf != null) {
            if (feature.isContactFeature()) {
                beginRange = mf.getMappedPositions(begin, begin);
                endRange = begin == end ? beginRange : mf.getMappedPositions(end, end);
            } else {
                endRange = beginRange = mf.getMappedPositions(begin, end);
            }
            if (beginRange == null || endRange == null) {
                return false;
            }
            begin = beginRange[0];
            end = endRange[endRange.length - 1];
        }
        StringBuilder sb = new StringBuilder();
        if (feature.isContactFeature()) {
            boolean showMappedContact;
            boolean showContact = mf == null && (rpos == begin || rpos == end);
            boolean bl = showMappedContact = mf != null && (rpos >= beginRange[0] && rpos <= beginRange[beginRange.length - 1] || rpos >= endRange[0] && rpos <= endRange[endRange.length - 1]);
            if (showContact || showMappedContact) {
                if (sb0.length() > 6) {
                    sb.append("<br/>");
                }
                sb.append(feature.getType()).append(" ").append(begin).append(":").append(end);
            }
            return SequenceAnnotationReport.appendText(sb0, sb, maxlength);
        }
        if (sb0.length() > 6) {
            sb.append("<br/>");
        }
        boolean bl = linkOnly = feature.getValue("linkonly") != null;
        if (!linkOnly) {
            String variants;
            CharSequence[] attName;
            String attVal;
            FeatureColourI fc;
            String status;
            Object description;
            sb.append(feature.getType()).append(" ");
            if (rpos != 0) {
                sb.append(begin);
                if (begin != end) {
                    sb.append(" ").append(end);
                }
            }
            if ((description = feature.getDescription()) != null && !((String)description).equals(feature.getType())) {
                boolean hasLink;
                int linkindex = ((String)(description = StringUtils.stripHtmlTags((String)description))).toLowerCase(Locale.ROOT).indexOf("<a ");
                boolean bl2 = hasLink = linkindex > -1 && linkindex < 40;
                if (((String)description).length() > 40 && !hasLink) {
                    description = ((String)description).substring(0, 40) + ELLIPSIS;
                }
                sb.append("; ").append((String)description);
            }
            if (this.showScore(feature, fr)) {
                sb.append(" Score=").append(String.valueOf(feature.getScore()));
            }
            if ((status = (String)feature.getValue("status")) != null && status.length() > 0) {
                sb.append("; (").append(status).append(")");
            }
            if (fr != null && (fc = fr.getFeatureColours().get(feature.getType())) != null && fc.isColourByAttribute() && (attVal = feature.getValueAsString((String[])(attName = fc.getAttributeName()))) != null) {
                sb.append("; ").append(String.join((CharSequence)":", attName)).append("=").append(attVal);
            }
            if (mf != null && !(variants = mf.findProteinVariants(feature)).isEmpty()) {
                sb.append(" ").append(variants);
            }
        }
        return SequenceAnnotationReport.appendText(sb0, sb, maxlength);
    }

    private static boolean appendText(StringBuilder sb0, StringBuilder sb, int maxlength) {
        if (maxlength == 0 || sb0.length() + sb.length() < maxlength) {
            sb0.append((CharSequence)sb);
            return false;
        }
        return true;
    }

    boolean showScore(SequenceFeature feature, FeatureRendererModel fr) {
        if (Float.isNaN(feature.getScore())) {
            return false;
        }
        if (fr == null) {
            return true;
        }
        float[][] minMax = fr.getMinMax().get(feature.getType());
        return minMax != null && minMax[0] != null && minMax[0][0] != minMax[0][1];
    }

    void appendLinks(StringBuffer sb, SequenceFeature feature) {
        if (feature.links != null) {
            if (linkImageURL != null) {
                sb.append(" <img src=\"" + linkImageURL + "\">");
            } else {
                for (String urlstring : feature.links) {
                    try {
                        for (List<String> urllink : this.createLinksFrom(null, urlstring)) {
                            sb.append("<br/> <a href=\"" + urllink.get(3) + "\" target=\"" + urllink.get(0) + "\">" + (String)(urllink.get(0).toLowerCase(Locale.ROOT).equals(urllink.get(1).toLowerCase(Locale.ROOT)) ? urllink.get(0) : urllink.get(0) + ":" + urllink.get(1)) + "</a><br/>");
                        }
                    }
                    catch (Exception x) {
                        Console.errPrintln("problem when creating links from " + urlstring);
                        x.printStackTrace();
                    }
                }
            }
        }
    }

    Collection<List<String>> createLinksFrom(SequenceI seq, String link) {
        LinkedHashMap<String, List<String>> urlSets = new LinkedHashMap<String, List<String>>();
        UrlLink urlLink = new UrlLink(link);
        if (!urlLink.isValid()) {
            Console.errPrintln(urlLink.getInvalidMessage());
            return null;
        }
        urlLink.createLinksFromSeq(seq, urlSets);
        return urlSets.values();
    }

    public void createSequenceAnnotationReport(StringBuilder tip, SequenceI sequence, boolean showDbRefs, boolean showNpFeats, FeatureRendererModel fr) {
        this.createSequenceAnnotationReport(tip, sequence, showDbRefs, showNpFeats, fr, false);
    }

    int createSequenceAnnotationReport(StringBuilder sb, SequenceI sequence, boolean showDbRefs, boolean showNpFeats, FeatureRendererModel fr, boolean summary) {
        sb.append("<i>");
        int maxWidth = 0;
        if (sequence.getDescription() != null) {
            String tmp = sequence.getDescription();
            sb.append(tmp);
            maxWidth = Math.max(maxWidth, tmp.length());
        }
        sb.append("\n");
        SequenceI ds = sequence;
        while (ds.getDatasetSequence() != null) {
            ds = ds.getDatasetSequence();
        }
        if (showDbRefs) {
            maxWidth = Math.max(maxWidth, this.appendDbRefs(sb, ds, summary));
        }
        sb.append("\n");
        if (showNpFeats) {
            for (SequenceFeature sf : sequence.getFeatures().getNonPositionalFeatures(new String[0])) {
                int sz = -sb.length();
                this.appendFeature(sb, 0, fr, sf, null, 0);
                maxWidth = Math.max(maxWidth, sz += sb.length());
            }
        }
        sb.append("</i>");
        return maxWidth;
    }

    protected int appendDbRefs(StringBuilder sb, SequenceI ds, boolean summary) {
        Sequence.DBModList<DBRefEntry> dbrefset = ds.getDBRefs();
        if (dbrefset == null) {
            return 0;
        }
        ArrayList<DBRefEntry> dbrefs = new ArrayList<DBRefEntry>();
        dbrefs.addAll(dbrefset);
        dbrefs.sort(comparator);
        boolean ellipsis = false;
        String source = null;
        String lastSource = null;
        int countForSource = 0;
        int sourceCount = 0;
        boolean moreSources = false;
        int maxLineLength = 0;
        int lineLength = 0;
        for (DBRefEntry ref : dbrefs) {
            boolean sourceChanged;
            source = ref.getSource();
            if (source == null) continue;
            boolean bl = sourceChanged = !source.equals(lastSource);
            if (sourceChanged) {
                lineLength = 0;
                countForSource = 0;
                ++sourceCount;
            }
            if (sourceCount > 5 && summary) {
                ellipsis = true;
                moreSources = true;
                break;
            }
            lastSource = source;
            if (++countForSource == 1 || !summary) {
                sb.append("<br/>\n");
            }
            if (countForSource <= 4 || !summary) {
                String accessionId = ref.getAccessionId();
                lineLength += accessionId.length() + 1;
                if (countForSource > 1 && summary) {
                    sb.append(",\n ").append(accessionId);
                    ++lineLength;
                } else {
                    sb.append(source).append(" ").append(accessionId);
                    lineLength += source.length();
                }
                maxLineLength = Math.max(maxLineLength, lineLength);
            }
            if (countForSource != 4 || !summary) continue;
            sb.append(COMMA).append(ELLIPSIS);
            ellipsis = true;
        }
        if (moreSources) {
            sb.append("<br/>\n").append(source).append(COMMA).append(ELLIPSIS);
        }
        if (ellipsis) {
            sb.append("<br/>\n(");
            sb.append(MessageManager.getString("label.output_seq_details"));
            sb.append(")");
        }
        return maxLineLength;
    }

    public void createTooltipAnnotationReport(StringBuilder tip, SequenceI sequence, boolean showDbRefs, boolean showNpFeats, FeatureRendererModel fr) {
        int maxWidth = this.createSequenceAnnotationReport(tip, sequence, showDbRefs, showNpFeats, fr, true);
        if (maxWidth > 60) {
            // empty if block
        }
    }

    static {
        comparator = new Comparator<DBRefEntry>(){

            @Override
            public int compare(DBRefEntry ref1, DBRefEntry ref2) {
                int comp;
                if (ref1 instanceof GeneLociI) {
                    return -1;
                }
                if (ref2 instanceof GeneLociI) {
                    return 1;
                }
                String s1 = ref1.getSource();
                String s2 = ref2.getSource();
                boolean s1Primary = DBRefSource.isPrimarySource(s1);
                boolean s2Primary = DBRefSource.isPrimarySource(s2);
                if (ref1.isCanonical() && !ref2.isCanonical()) {
                    return -1;
                }
                if (!ref1.isCanonical() && ref2.isCanonical()) {
                    return 1;
                }
                if (s1Primary && !s2Primary) {
                    return -1;
                }
                if (!s1Primary && s2Primary) {
                    return 1;
                }
                int n = s1 == null ? -1 : (comp = s2 == null ? 1 : s1.compareToIgnoreCase(s2));
                if (comp == 0) {
                    String a1 = ref1.getAccessionId();
                    String a2 = ref2.getAccessionId();
                    comp = a1 == null ? -1 : (a2 == null ? 1 : a1.compareToIgnoreCase(a2));
                }
                return comp;
            }
        };
    }
}

