/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import java.io.IOException;
import java.util.Vector;

public class BLCFile
extends AlignFile {
    Vector titles;
    int iterationSkips = 0;
    int iterationCount = 0;

    public BLCFile() {
    }

    public BLCFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public BLCFile(FileParse source) throws IOException {
        super(source);
    }

    @Override
    public void initData() {
        super.initData();
        this.titles = new Vector();
    }

    @Override
    public void parse() throws IOException {
        StringBuffer headerLines = new StringBuffer();
        int numHeaderLines = 0;
        StringBuffer[] seqstrings = null;
        if (this.suffix != null) {
            try {
                this.iterationSkips = Integer.parseInt(this.suffix);
            }
            catch (NumberFormatException e) {
                this.iterationSkips = 0;
            }
        }
        String line = null;
        do {
            int i;
            boolean idsFound = false;
            boolean newids = false;
            while ((line = this.nextLine()) != null) {
                if (line.indexOf("*") > -1) {
                    idsFound = true;
                    break;
                }
                int abracket = line.indexOf(">");
                if (abracket > -1) {
                    if (this.iterationCount > 0 && !newids) {
                        newids = true;
                        this.seqs.removeAllElements();
                    }
                    line = line.substring(abracket + 1);
                    Sequence seq = this.parseId(line);
                    this.seqs.addElement(seq);
                } else {
                    headerLines.append(line);
                    headerLines.append(this.newline);
                    ++numHeaderLines;
                }
                if (!idsFound) continue;
            }
            if (line == null) break;
            int starCol = line.indexOf("*");
            seqstrings = new StringBuffer[this.seqs.size()];
            for (i = 0; i < this.seqs.size(); ++i) {
                if (seqstrings[i] != null) continue;
                seqstrings[i] = new StringBuffer();
            }
            try {
                line = this.nextLine();
                while (line != null && line.indexOf("*") == -1) {
                    for (i = 0; i < this.seqs.size(); ++i) {
                        if (line.length() <= i + starCol) continue;
                        seqstrings[i].append(line.charAt(i + starCol));
                    }
                    line = this.nextLine();
                }
            }
            catch (IOException e) {
                if (this.iterationCount == 0) {
                    throw e;
                }
                this.iterationSkips = 0;
            }
            ++this.iterationCount;
        } while (--this.iterationSkips != -1);
        for (int i = 0; i < this.seqs.size(); ++i) {
            Sequence newSeq = (Sequence)this.seqs.elementAt(i);
            newSeq.setSequence(seqstrings[i].toString());
        }
        if (this.seqs.size() > 0) {
            if (headerLines.length() > 1 + numHeaderLines) {
                this.setAlignmentProperty("Comments", headerLines.toString());
            }
            this.setAlignmentProperty("iteration", "" + this.iterationCount);
        }
    }

    @Override
    public String print(SequenceI[] s, boolean jvsuffix) {
        int i;
        StringBuffer out = new StringBuffer();
        int max = -1;
        for (i = 0; i < s.length && s[i] != null; ++i) {
            out.append(">" + this.printId(s[i], jvsuffix));
            if (s[i].getDescription() != null) {
                out.append(" " + s[i].getDescription());
            }
            out.append(this.newline);
            max = Math.max(max, s[i].getLength());
        }
        out.append("* iteration 1");
        out.append(this.newline);
        for (int j = 0; j < max; ++j) {
            for (i = 0; i < s.length && s[i] != null; ++i) {
                if (s[i].getSequence().length > j) {
                    out.append(s[i].getSequenceAsString(j, j + 1));
                    continue;
                }
                out.append("-");
            }
            out.append(this.newline);
        }
        out.append("*");
        out.append(this.newline);
        return out.toString();
    }
}

