/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AlignmentFileWriterI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.MessageManager;
import jalview.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public abstract class AlignFile
extends FileParse
implements AlignmentFileReaderI,
AlignmentFileWriterI {
    int noSeqs = 0;
    int maxLength = 0;
    protected Vector<SequenceI> seqs;
    protected Vector<AlignmentAnnotation> annotations;
    protected List<SequenceGroup> seqGroups;
    private Hashtable properties;
    long start;
    long end;
    private boolean parseCalled = false;
    private boolean parseImmediately = true;
    private boolean dataClosed = false;
    private boolean doXferSettings = true;
    Vector<String[]> newickStrings = null;

    protected boolean isParseImmediately() {
        return this.parseImmediately;
    }

    public AlignFile() {
        this.initData();
    }

    public AlignFile(SequenceI[] seqs) {
        this();
        this.setSeqs(seqs);
    }

    public AlignFile(Object dataObject, DataSourceType sourceType) throws IOException {
        this(true, dataObject, sourceType);
    }

    public AlignFile(boolean parseImmediately, Object dataObject, DataSourceType sourceType) throws IOException {
        super(dataObject, sourceType);
        this.initData();
        if (parseImmediately) {
            this.doParse();
        }
    }

    public AlignFile(FileParse source, boolean doXferSettings) throws IOException {
        this(true, source, true, doXferSettings);
    }

    public AlignFile(FileParse source) throws IOException {
        this(true, source);
    }

    public AlignFile(boolean parseImmediately, FileParse source) throws IOException {
        this(parseImmediately, source, true);
    }

    public AlignFile(boolean parseImmediately, FileParse source, boolean closeData) throws IOException {
        this(parseImmediately, source, closeData, true);
    }

    public AlignFile(boolean parseImmediately, FileParse source, boolean closeData, boolean doXferSettings) throws IOException {
        super(source);
        this.initData();
        this.parseImmediately = parseImmediately;
        this.doXferSettings = doXferSettings;
        if (parseImmediately) {
            this.doParse(closeData);
        }
    }

    public void doParse() throws IOException {
        this.doParse(true);
    }

    public void doParse(boolean closeData) throws IOException {
        if (this.parseCalled) {
            throw new IOException("Implementation error: Parser called twice for same data.\nNeed to call initData() again before parsing can be reattempted.");
        }
        this.parseCalled = true;
        this.parse(this.doXferSettings);
        if (closeData && !this.dataClosed) {
            this.dataIn.close();
            this.dataClosed = true;
        }
    }

    public Vector<SequenceI> getSeqs() {
        return this.seqs;
    }

    public List<SequenceGroup> getSeqGroups() {
        return this.seqGroups;
    }

    @Override
    public SequenceI[] getSeqsAsArray() {
        SequenceI[] s = new SequenceI[this.seqs.size()];
        for (int i = 0; i < this.seqs.size(); ++i) {
            s[i] = this.seqs.elementAt(i);
        }
        return s;
    }

    @Override
    public void addAnnotations(AlignmentI al) {
        this.addProperties(al);
        for (int i = 0; i < this.annotations.size(); ++i) {
            AlignmentAnnotation an = this.annotations.elementAt(i);
            an.validateRangeAndDisplay();
            al.addAnnotation(an);
        }
    }

    public void addSeqGroups(AlignmentI al) {
        this.seqGroups = al.getGroups();
    }

    public void addProperties(AlignmentI al) {
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration keys = this.properties.keys();
            Enumeration vals = this.properties.elements();
            while (keys.hasMoreElements()) {
                al.setProperty(keys.nextElement(), vals.nextElement());
            }
        }
    }

    protected void setAlignmentProperty(Object key, Object value) {
        if (key == null) {
            throw new Error(MessageManager.getString("error.implementation_error_cannot_have_null_alignment"));
        }
        if (value == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    protected Object getAlignmentProperty(Object key) {
        if (this.properties != null && key != null) {
            return this.properties.get(key);
        }
        return null;
    }

    protected void initData() {
        this.seqs = new Vector();
        this.annotations = new Vector();
        this.seqGroups = new ArrayList<SequenceGroup>();
        this.parseCalled = false;
    }

    @Override
    public void setSeqs(SequenceI[] s) {
        this.seqs = new Vector();
        for (int i = 0; i < s.length; ++i) {
            this.seqs.addElement(s[i]);
        }
    }

    public abstract void parse() throws IOException;

    public void parse(boolean doXferSettings) throws IOException {
        this.parse();
    }

    Sequence parseId(String id) {
        Sequence seq = null;
        int space = StringUtils.indexOfFirstWhitespace(id = id.trim());
        if (space > -1) {
            seq = new Sequence(id.substring(0, space), "");
            String desc = id.substring(space + 1);
            seq.setDescription(desc);
        } else {
            seq = new Sequence(id, "");
        }
        return seq;
    }

    String printId(SequenceI seq, boolean jvsuffix) {
        return seq.getDisplayId(jvsuffix);
    }

    String printId(SequenceI seq) {
        return this.printId(seq, true);
    }

    protected void addNewickTree(String treeName, String newickString) {
        if (this.newickStrings == null) {
            this.newickStrings = new Vector();
        }
        this.newickStrings.addElement(new String[]{treeName, newickString});
    }

    protected int getTreeCount() {
        return this.newickStrings == null ? 0 : this.newickStrings.size();
    }

    @Override
    public void addGroups(AlignmentI al) {
        for (SequenceGroup sg : this.getSeqGroups()) {
            al.addGroup(sg);
        }
    }

    protected void addSequence(SequenceI seq) {
        this.seqs.add(seq);
    }

    public void setDoXferSettings(boolean b) {
        this.doXferSettings = b;
    }

    public boolean getDoXferSettings() {
        return this.doXferSettings;
    }
}

