/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.FeatureSettingsModelI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceI;
import jalview.fts.core.GFTSPanel;
import jalview.fts.service.pdb.PDBFTSPanel;
import jalview.fts.service.threedbeacons.TDBeaconsFTSPanel;
import jalview.fts.service.uniprot.UniprotFTSPanel;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.io.FileFormatI;
import jalview.util.DBRefUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SequenceFetcher
extends JPanel
implements Runnable {
    private static jalview.ws.SequenceFetcher sfetch = null;
    JLabel exampleAccession;
    JComboBox<StringPair> database;
    JCheckBox removeVersions = null;
    JCheckBox replacePunctuation;
    JButton okBtn;
    JButton exampleBtn;
    JButton closeBtn;
    JButton backBtn;
    JTextArea textArea;
    JInternalFrame frame;
    IProgressIndicator guiWindow;
    AlignFrame alignFrame;
    GFTSPanel parentSearchPanel;
    IProgressIndicator progressIndicator;
    volatile boolean _isConstructing = false;

    public static jalview.ws.SequenceFetcher getSequenceFetcherSingleton() {
        if (sfetch == null) {
            sfetch = new jalview.ws.SequenceFetcher();
        }
        return sfetch;
    }

    public SequenceFetcher(IProgressIndicator guiIndic) {
        this(guiIndic, null, null);
    }

    public SequenceFetcher(IProgressIndicator guiIndic, String selectedDb, String queryString) {
        this.progressIndicator = guiIndic;
        SequenceFetcher.getSequenceFetcherSingleton();
        this.guiWindow = this.progressIndicator;
        if (this.progressIndicator instanceof AlignFrame) {
            this.alignFrame = (AlignFrame)this.progressIndicator;
        }
        this.jbInit(selectedDb);
        this.textArea.setText(queryString);
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.frame.setFrameIcon(null);
        Desktop.addInternalFrame(this.frame, this.getFrameTitle(), true, 400, Platform.isAMacAndNotJS() ? 240 : 180);
    }

    private String getFrameTitle() {
        return this.alignFrame == null ? MessageManager.getString("label.new_sequence_fetcher") : MessageManager.getString("label.additional_sequence_fetcher");
    }

    private void jbInit(String selectedDb) {
        this.setLayout(new BorderLayout());
        this.removeVersions = new JCheckBox(MessageManager.getString("label.remove_version_numbers_from_ids"));
        this.removeVersions.setHorizontalAlignment(2);
        this.removeVersions.setFont(new Font("Verdana", 2, 11));
        boolean removeVersionsDefault = Cache.getDefault("REMOVE_VERSION_FROM_IDENTIFIERS_DEFAULT", true);
        this.removeVersions.setSelected(removeVersionsDefault);
        this.removeVersions.setEnabled(false);
        this.removeVersions.setVisible(false);
        this.database = new JComboBox();
        this.database.setFont(JvSwingUtils.getLabelFont());
        StringPair instructionItem = new StringPair(MessageManager.getString("action.select_ddbb"));
        this.database.setPrototypeDisplayValue(instructionItem);
        String[] sources = new jalview.ws.SequenceFetcher().getSupportedDb();
        Arrays.sort(sources, String.CASE_INSENSITIVE_ORDER);
        this.database.addItem(instructionItem);
        for (String source : sources) {
            List<DbSourceProxy> slist = sfetch.getSourceProxy(source);
            if (slist.size() == 1 && slist.get(0) != null) {
                this.database.addItem(new StringPair(source, slist.get(0).getDbName()));
                continue;
            }
            this.database.addItem(new StringPair(source));
        }
        this.setDatabaseSelectedItem(selectedDb);
        if (this.database.getSelectedIndex() == -1) {
            this.database.setSelectedIndex(0);
        }
        this.database.setMaximumRowCount(this.database.getItemCount());
        this.database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentSelection = ((StringPair)SequenceFetcher.this.database.getSelectedItem()).getKey();
                SequenceFetcher.this.updateExampleQuery(currentSelection);
                boolean showRemoveVersions = false;
                if ("pdb".equalsIgnoreCase(currentSelection)) {
                    SequenceFetcher.this.frame.dispose();
                    new PDBFTSPanel(SequenceFetcher.this);
                } else if ("uniprot".equalsIgnoreCase(currentSelection)) {
                    SequenceFetcher.this.frame.dispose();
                    new UniprotFTSPanel(SequenceFetcher.this);
                    showRemoveVersions = true;
                } else if ("3d-beacons".equalsIgnoreCase(currentSelection)) {
                    SequenceFetcher.this.frame.dispose();
                    new TDBeaconsFTSPanel(SequenceFetcher.this);
                } else {
                    SequenceFetcher.this.otherSourceAction();
                }
                SequenceFetcher.this.removeVersions.setEnabled(showRemoveVersions);
                SequenceFetcher.this.removeVersions.setVisible(showRemoveVersions);
            }
        });
        this.exampleAccession = new JLabel("");
        this.exampleAccession.setFont(new Font("Verdana", 1, 11));
        JLabel jLabel1 = new JLabel(MessageManager.getString("label.separate_multiple_accession_ids"));
        jLabel1.setFont(new Font("Verdana", 2, 11));
        jLabel1.setHorizontalAlignment(2);
        this.replacePunctuation = new JCheckBox(MessageManager.getString("label.replace_commas_semicolons"));
        this.replacePunctuation.setHorizontalAlignment(2);
        this.replacePunctuation.setFont(new Font("Verdana", 2, 11));
        this.okBtn = new JButton(MessageManager.getString("action.ok"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.ok_actionPerformed();
            }
        });
        JButton clear = new JButton(MessageManager.getString("action.clear"));
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.clear_actionPerformed();
            }
        });
        this.exampleBtn = new JButton(MessageManager.getString("label.example"));
        this.exampleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.example_actionPerformed();
            }
        });
        this.closeBtn = new JButton(MessageManager.getString("action.cancel"));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.close_actionPerformed(e);
            }
        });
        this.backBtn = new JButton(MessageManager.getString("action.back"));
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.parentSearchPanel.btn_back_ActionPerformed();
            }
        });
        this.backBtn.setVisible(false);
        this.textArea = new JTextArea();
        this.textArea.setFont(JvSwingUtils.getLabelFont());
        this.textArea.setLineWrap(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SequenceFetcher.this.ok_actionPerformed();
                }
            }
        });
        JPanel actionPanel = new JPanel();
        actionPanel.add(this.backBtn);
        actionPanel.add(this.exampleBtn);
        actionPanel.add(clear);
        actionPanel.add(this.okBtn);
        actionPanel.add(this.closeBtn);
        JPanel databasePanel = new JPanel();
        databasePanel.setLayout(new BorderLayout());
        databasePanel.add(this.database, "North");
        databasePanel.add((Component)this.exampleAccession, "Center");
        JPanel jPanel2a = new JPanel(new BorderLayout());
        jPanel2a.add((Component)jLabel1, "North");
        jPanel2a.add((Component)this.removeVersions, "Center");
        jPanel2a.add((Component)this.replacePunctuation, "South");
        databasePanel.add((Component)jPanel2a, "South");
        JPanel idsPanel = new JPanel();
        idsPanel.setLayout(new BorderLayout(0, 5));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add(this.textArea);
        idsPanel.add((Component)jScrollPane1, "Center");
        this.add((Component)actionPanel, "South");
        this.add((Component)idsPanel, "Center");
        this.add((Component)databasePanel, "North");
    }

    private void setDatabaseSelectedItem(String db) {
        for (int i = 0; i < this.database.getItemCount(); ++i) {
            StringPair sp = this.database.getItemAt(i);
            if (sp == null || db == null || !db.equals(sp.getKey())) continue;
            this.database.setSelectedIndex(i);
            return;
        }
    }

    protected String getExampleQueries(String db) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> hs = new HashSet<String>();
        for (DbSourceProxy dbs : sfetch.getSourceProxy(db)) {
            String tq = dbs.getTestQuery();
            if (!hs.add(tq)) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(tq);
        }
        return sb.toString();
    }

    protected void otherSourceAction() {
        try {
            String eq = this.exampleAccession.getText();
            boolean enablePunct = eq == null || eq.indexOf(",") <= -1;
            this.replacePunctuation.setEnabled(enablePunct);
        }
        catch (Exception ex) {
            this.exampleAccession.setText("");
            this.replacePunctuation.setEnabled(true);
        }
        this.repaint();
    }

    protected String updateExampleQuery(String selectedDatabase) {
        String eq = this.getExampleQueries(selectedDatabase);
        this.exampleAccession.setText(MessageManager.formatMessage("label.example_query_param", new String[]{eq}));
        return eq;
    }

    protected void example_actionPerformed() {
        String eq = this.getExampleQueries(((StringPair)this.database.getSelectedItem()).getKey());
        this.textArea.setText(eq);
        this.repaint();
    }

    protected void clear_actionPerformed() {
        this.textArea.setText("");
        this.repaint();
    }

    protected void close_actionPerformed(ActionEvent e) {
        try {
            this.frame.setClosed(true);
            if (this.parentSearchPanel != null) {
                this.parentSearchPanel.btn_cancel_ActionPerformed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ok_actionPerformed() {
        String text;
        String t0 = this.textArea.getText();
        if (!t0.equals(text = SequenceFetcher.replaceQueryText(t0, this.replacePunctuation.isEnabled() && this.replacePunctuation.isSelected(), this.removeVersions.isEnabled() && this.removeVersions.isSelected()))) {
            this.textArea.setText(text);
        }
        if (text.isEmpty()) {
            this.showErrorMessage("Please enter a (semi-colon separated list of) database id(s)");
            this.resetDialog();
            return;
        }
        if (this.database.getSelectedIndex() == 0) {
            this.showErrorMessage("Please choose a database");
            this.resetDialog();
            return;
        }
        this.exampleBtn.setEnabled(false);
        this.textArea.setEnabled(false);
        this.okBtn.setEnabled(false);
        this.closeBtn.setEnabled(false);
        this.backBtn.setEnabled(false);
        Thread worker = new Thread(this);
        worker.start();
    }

    protected static String replaceQueryText(String text0, boolean replaceSemiColons, boolean removeVersions) {
        String text = text0.trim();
        if (replaceSemiColons) {
            text = text.replace(",", ";");
        }
        text = text.replaceAll("(\\s|[; ])+", ";");
        if (removeVersions) {
            Console.debug("search text was '" + text + "'");
            text = text.replaceAll("\\.[0-9]+([^0-9a-zA-Z\\.]|$)", "$1");
            Console.debug("search text now '" + text + "'");
        }
        return text;
    }

    private void resetDialog() {
        this.exampleBtn.setEnabled(true);
        this.textArea.setEnabled(true);
        this.okBtn.setEnabled(true);
        this.closeBtn.setEnabled(true);
        this.backBtn.setEnabled(this.parentSearchPanel != null);
    }

    @Override
    public void run() {
        boolean addToLast = false;
        ArrayList<String> aresultq = new ArrayList<String>();
        ArrayList<Object> presultTitle = new ArrayList<Object>();
        ArrayList<AlignmentI> presult = new ArrayList<AlignmentI>();
        ArrayList<AlignmentI> aresult = new ArrayList<AlignmentI>();
        List<DbSourceProxy> sources = sfetch.getSourceProxy(((StringPair)this.database.getSelectedItem()).getKey());
        Iterator<DbSourceProxy> proxies = sources.iterator();
        String[] qries = this.textArea.getText().trim().split(";");
        List<String> nextFetch = Arrays.asList(qries);
        Iterator<String> en = Arrays.asList(new String[0]).iterator();
        int nqueries = qries.length;
        FeatureSettingsModelI preferredFeatureColours = null;
        while (proxies.hasNext() && (en.hasNext() || nextFetch.size() > 0)) {
            if (!en.hasNext() && nextFetch.size() > 0) {
                en = nextFetch.iterator();
                nqueries = nextFetch.size();
                qries = nextFetch.toArray(new String[nqueries]);
                nextFetch = new ArrayList<String>();
            }
            DbSourceProxy proxy = proxies.next();
            try {
                this.guiWindow.setProgressBar(MessageManager.formatMessage("status.fetching_sequence_queries_from", new String[]{Integer.valueOf(nqueries).toString(), proxy.getDbName()}), Thread.currentThread().hashCode());
                if (proxy.getMaximumQueryCount() == 1) {
                    while (en.hasNext()) {
                        String acc = en.next();
                        if (this.fetchSingleAccession(proxy, acc, aresultq, aresult)) continue;
                        nextFetch.add(acc);
                    }
                } else {
                    this.fetchMultipleAccessions(proxy, en, aresultq, aresult, nextFetch);
                }
            }
            catch (Exception e) {
                this.showErrorMessage("Error retrieving " + this.textArea.getText() + " from " + ((StringPair)this.database.getSelectedItem()).getDisplay());
                Console.errPrintln("Retrieval failed for source ='" + ((StringPair)this.database.getSelectedItem()).getDisplay() + "' and query\n'" + this.textArea.getText() + "'\n");
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                this.showErrorMessage("Out of Memory when retrieving " + this.textArea.getText() + " from " + ((StringPair)this.database.getSelectedItem()).getDisplay() + "\nPlease see the Jalview FAQ for instructions for increasing the memory available to Jalview.\n");
                e.printStackTrace();
            }
            catch (Error e) {
                this.showErrorMessage("Serious Error retrieving " + this.textArea.getText() + " from " + ((StringPair)this.database.getSelectedItem()).getDisplay());
                e.printStackTrace();
            }
            if (aresult != null && aresult.size() > 0) {
                FeatureSettingsModelI proxyColourScheme = proxy.getFeatureColourScheme();
                if (proxyColourScheme != null) {
                    preferredFeatureColours = proxyColourScheme;
                }
                AlignmentI ar = null;
                if (proxy.isAlignmentSource()) {
                    addToLast = false;
                    while (aresult.size() > 0) {
                        presult.add((AlignmentI)aresult.remove(0));
                        presultTitle.add((String)aresultq.remove(0) + " " + this.getDefaultRetrievalTitle());
                    }
                } else {
                    String titl = null;
                    if (addToLast && presult.size() > 0) {
                        ar = (AlignmentI)presult.remove(presult.size() - 1);
                        titl = (String)presultTitle.remove(presultTitle.size() - 1);
                    }
                    while (aresult.size() > 0) {
                        if (ar == null) {
                            ar = (AlignmentI)aresult.remove(0);
                            continue;
                        }
                        ar.append((AlignmentI)aresult.remove(0));
                    }
                    addToLast = true;
                    presult.add(ar);
                    presultTitle.add(titl);
                }
            }
            this.guiWindow.setProgressBar(MessageManager.getString("status.finshed_querying"), Thread.currentThread().hashCode());
        }
        this.guiWindow.setProgressBar(presult.size() > 0 ? MessageManager.getString("status.parsing_results") : MessageManager.getString("status.processing"), Thread.currentThread().hashCode());
        while (presult.size() > 0) {
            this.parseResult((AlignmentI)presult.remove(0), (String)presultTitle.remove(0), null, preferredFeatureColours);
        }
        this.guiWindow.setProgressBar(null, Thread.currentThread().hashCode());
        if (nextFetch.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Didn't retrieve the following " + (String)(nextFetch.size() == 1 ? "query" : nextFetch.size() + " queries") + ": \n");
            int l = sb.length();
            int lr = 0;
            for (String s : nextFetch) {
                if (l != sb.length()) {
                    sb.append("; ");
                }
                if (lr - sb.length() > 40) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            this.showErrorMessage(sb.toString());
        }
        this.resetDialog();
    }

    void fetchMultipleAccessions(DbSourceProxy proxy, Iterator<String> accessions, List<String> aresultq, List<AlignmentI> aresult, List<String> nextFetch) throws Exception {
        StringBuilder multiacc = new StringBuilder();
        ArrayList<String> tosend = new ArrayList<String>();
        while (accessions.hasNext()) {
            String nel = accessions.next();
            tosend.add(nel);
            multiacc.append(nel);
            if (!accessions.hasNext()) continue;
            multiacc.append(proxy.getAccessionSeparator());
        }
        try {
            String query = multiacc.toString();
            AlignmentI rslt = proxy.getSequenceRecords(query);
            if (rslt == null || rslt.getHeight() == 0) {
                nextFetch.addAll(tosend);
            } else {
                aresultq.add(query);
                aresult.add(rslt);
                if (tosend.size() > 1) {
                    this.checkResultForQueries(rslt, tosend, nextFetch, proxy);
                }
            }
        }
        catch (OutOfMemoryError oome) {
            new OOMWarning("fetching " + multiacc + " from " + ((StringPair)this.database.getSelectedItem()).getDisplay(), oome, this);
        }
    }

    boolean fetchSingleAccession(DbSourceProxy proxy, String accession, List<String> aresultq, List<AlignmentI> aresult) {
        boolean success = false;
        try {
            if (aresult != null) {
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AlignmentI indres = null;
            try {
                indres = proxy.getSequenceRecords(accession);
            }
            catch (OutOfMemoryError oome) {
                new OOMWarning("fetching " + accession + " from " + proxy.getDbName(), oome, this);
            }
            if (indres != null) {
                aresultq.add(accession);
                aresult.add(indres);
                success = true;
            }
        }
        catch (Exception e) {
            Console.info("Error retrieving " + accession + " from " + proxy.getDbName(), e);
        }
        return success;
    }

    void checkResultForQueries(AlignmentI rslt, List<String> queries, List<String> nextFetch, DbSourceProxy proxy) {
        SequenceI[] rs = rslt.getSequencesArray();
        for (String q : queries) {
            String accId = proxy.getAccessionIdFromQuery(q);
            boolean rfound = false;
            int nr = rs.length;
            for (int r = 0; r < nr; ++r) {
                List<DBRefEntry> found;
                if (rs[r] == null || (found = DBRefUtils.searchRefs(rs[r].getDBRefs(), accId)).isEmpty()) continue;
                rfound = true;
                break;
            }
            if (rfound) continue;
            nextFetch.add(q);
        }
    }

    public String getDefaultRetrievalTitle() {
        return "Retrieved from " + ((StringPair)this.database.getSelectedItem()).getDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlignmentI parseResult(AlignmentI al, String title, FileFormatI currentFileFormat, FeatureSettingsModelI preferredFeatureColours) {
        if (al != null && al.getHeight() > 0) {
            if (title == null) {
                title = this.getDefaultRetrievalTitle();
            }
            if (this.alignFrame == null) {
                List<SequenceI> alsqs;
                AlignFrame af = new AlignFrame(al, 700, 500);
                if (currentFileFormat != null) {
                    af.currentFileFormat = currentFileFormat;
                }
                List<SequenceI> list = alsqs = al.getSequences();
                synchronized (list) {
                    for (SequenceI sq : alsqs) {
                        if (!sq.getFeatures().hasFeatures()) continue;
                        af.setShowSeqFeatures(true);
                        break;
                    }
                }
                af.getViewport().applyFeaturesStyle(preferredFeatureColours);
                if (Cache.getDefault("HIDE_INTRONS", true)) {
                    af.hideFeatureColumns("exon", false);
                }
                af.alignPanel.alignmentChanged();
                Desktop.addInternalFrame(af, title, 700, 500);
                af.setStatus(MessageManager.getString("label.successfully_pasted_alignment_file"));
                try {
                    af.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                }
                catch (Exception exception) {}
            } else {
                this.alignFrame.viewport.addAlignment(al, title);
            }
        }
        return al;
    }

    void showErrorMessage(final String error) {
        this.resetDialog();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, error, MessageManager.getString("label.error_retrieving_data"), 2);
            }
        });
    }

    public IProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void setProgressIndicator(IProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    void hidePanel() {
        this.frame.setVisible(false);
    }

    public void setQuery(String ids) {
        this.textArea.setText(ids);
    }

    public void embedIn(GFTSPanel parentPanel) {
        this.database.setVisible(false);
        this.backBtn.setVisible(true);
        this.parentSearchPanel = parentPanel;
    }

    private class StringPair {
        private String key;
        private String display;

        public StringPair(String s1, String s2) {
            this.key = s1;
            this.display = s2;
        }

        public StringPair(String s) {
            this(s, s);
        }

        public String getKey() {
            return this.key;
        }

        public String getDisplay() {
            return this.display;
        }

        public String toString() {
            return this.display;
        }

        public boolean equals(StringPair other) {
            return other.key == this.key;
        }
    }
}

