/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.bin.Console;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.datamodel.StructureViewerModel;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.ProgressBar;
import jalview.gui.PymolBindingModel;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class PymolViewer
extends StructureViewerBase {
    private static final int myWidth = 500;
    private static final int myHeight = 150;
    private PymolBindingModel binding;
    private String pymolSessionFile;
    JMenuItem writeFeatures = null;

    public PymolViewer() {
        this.setDefaultCloseOperation(0);
    }

    public PymolViewer(PDBEntry pdb, SequenceI[] seqs, Object object, AlignmentPanel ap) {
        this();
        this.openNewPymol(ap, new PDBEntry[]{pdb}, new SequenceI[][]{seqs});
    }

    public PymolViewer(PDBEntry[] pe, boolean alignAdded, SequenceI[][] seqs, AlignmentPanel ap) {
        this();
        this.setAlignAddedStructures(alignAdded);
        this.openNewPymol(ap, pe, seqs);
    }

    public PymolViewer(StructureViewerModel viewerModel, AlignmentPanel alignPanel, String sessionFile, String vid) {
        this();
        this.setViewId(vid);
        this.pymolSessionFile = sessionFile;
        Map<File, StructureViewerModel.StructureData> pdbData = viewerModel.getFileData();
        PDBEntry[] pdbArray = new PDBEntry[pdbData.size()];
        SequenceI[][] seqsArray = new SequenceI[pdbData.size()][];
        int i = 0;
        for (StructureViewerModel.StructureData data : pdbData.values()) {
            PDBEntry pdbentry;
            pdbArray[i] = pdbentry = new PDBEntry(data.getPdbId(), null, PDBEntry.Type.PDB, data.getFilePath());
            List<SequenceI> sequencesForPdb = data.getSeqList();
            seqsArray[i] = sequencesForPdb.toArray(new SequenceI[sequencesForPdb.size()]);
            ++i;
        }
        this.openNewPymol(alignPanel, pdbArray, seqsArray);
        if (viewerModel.isColourByViewer()) {
            this.binding.setColourBySequence(false);
            this.seqColour.setSelected(false);
            this.viewerColour.setSelected(true);
        } else if (viewerModel.isColourWithAlignPanel()) {
            this.binding.setColourBySequence(true);
            this.seqColour.setSelected(true);
            this.viewerColour.setSelected(false);
        }
    }

    private void openNewPymol(AlignmentPanel ap, PDBEntry[] pe, SequenceI[][] seqs) {
        this.createProgressBar();
        this.binding = new PymolBindingModel(this, ap.getStructureSelectionManager(), pe, seqs);
        this.addAlignmentPanel(ap);
        this.useAlignmentPanelForColourbyseq(ap);
        if (pe.length > 1) {
            this.useAlignmentPanelForSuperposition(ap);
        }
        this.binding.setColourBySequence(true);
        this.setSize(500, 150);
        this.initMenus();
        this.viewerActionMenu.setText("PyMOL");
        this.updateTitleAndMenus();
        this.addingStructures = false;
        this.worker = new Thread(this);
        this.worker.start();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                PymolViewer.this.closeViewer(false);
            }
        });
    }

    protected void createProgressBar() {
        if (this.getProgressIndicator() == null) {
            this.setProgressIndicator(new ProgressBar(this.statusPanel, this.statusBar));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder errormsgs = new StringBuilder(128);
        ArrayList<PDBEntry> filePDB = new ArrayList<PDBEntry>();
        ArrayList<Integer> filePDBpos = new ArrayList<Integer>();
        String[] curfiles = this.binding.getStructureFiles();
        for (int pi = 0; pi < this.binding.getPdbCount(); ++pi) {
            Object file = null;
            PDBEntry thePdbEntry = this.binding.getPdbEntry(pi);
            if (thePdbEntry.getFile() == null) {
                file = this.fetchPdbFile(thePdbEntry);
                if (file == null) {
                    errormsgs.append("'" + thePdbEntry.getId() + "' ");
                }
            } else {
                file = new File(thePdbEntry.getFile()).getAbsoluteFile().getPath();
            }
            if (file == null) continue;
            filePDB.add(thePdbEntry);
            filePDBpos.add(pi);
        }
        if (!filePDB.isEmpty()) {
            this.binding.setFinishedInit(false);
            if (!this.addingStructures) {
                try {
                    this.initPymol();
                }
                catch (Exception ex) {
                    Console.error("Couldn't open PyMOL viewer!", ex);
                    return;
                }
            }
            if (!this.binding.isViewerRunning()) {
                return;
            }
            int num = -1;
            for (PDBEntry pe : filePDB) {
                ++num;
                if (pe.getFile() == null) continue;
                try {
                    int pos = (Integer)filePDBpos.get(num);
                    long startTime = this.startProgressBar(this.getViewerName() + " " + MessageManager.getString("status.opening_file_for") + " " + pe.getId());
                    this.binding.openFile(pe);
                    this.binding.addSequence(pos, this.binding.getSequence()[pos]);
                    File fl = new File(pe.getFile());
                    DataSourceType protocol = DataSourceType.URL;
                    try {
                        if (fl.exists()) {
                            protocol = DataSourceType.FILE;
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.stopProgressBar("", startTime);
                    }
                    StructureFile pdb = null;
                    if (pe.hasStructureFile()) {
                        pdb = pe.getStructureFile();
                        Console.debug("(Re)Using StructureFile " + pdb.getId());
                    } else {
                        pdb = this.binding.getSsm().setMapping(true, this.binding.getSequence()[pos], pe, this.binding.getChains()[pos], this.getProgressIndicator());
                    }
                    this.binding.stashFoundChains(pdb, pe.getFile());
                }
                catch (Exception ex) {
                    Console.error("Couldn't open " + pe.getFile() + " in " + this.getViewerName() + "!", ex);
                }
            }
            this.binding.refreshGUI();
            this.binding.setFinishedInit(true);
            this.binding.setLoadingFromArchive(false);
            FeatureRenderer fr = this.getBinding().getFeatureRenderer(null);
            if (fr != null) {
                fr.featuresAdded();
            }
            for (AlignmentViewPanel ap : this._colourwith) {
                this.binding.updateColours(ap);
            }
            if (this.alignAddedStructures) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PymolViewer.this.alignStructsWithAllAlignPanels();
                    }
                }).start();
            }
            this.addingStructures = false;
        }
        this._started = false;
        this.worker = null;
    }

    void initPymol() {
        boolean opened;
        Desktop.addInternalFrame(this, this.getViewerTitle(), this.getBounds().width, this.getBounds().height);
        if (!this.binding.launchPymol()) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.open_viewer_failed", this.getViewerName()), MessageManager.getString("label.error_loading_file"), 0);
            this.binding.closeViewer(true);
            this.dispose();
            return;
        }
        if (this.pymolSessionFile != null && !(opened = this.binding.openSession(this.pymolSessionFile))) {
            Console.error("An error occurred opening PyMOL session file " + this.pymolSessionFile);
        }
    }

    @Override
    public AAStructureBindingModel getBinding() {
        return this.binding;
    }

    @Override
    public StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.PYMOL;
    }

    @Override
    protected String getViewerName() {
        return "PyMOL";
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.savemenu.setVisible(false);
        this.viewMenu.add(this.fitToWindow);
        this.writeFeatures = new JMenuItem(MessageManager.getString("label.create_viewer_attributes"));
        this.writeFeatures.setToolTipText(MessageManager.getString("label.create_viewer_attributes_tip"));
        this.writeFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PymolViewer.this.sendFeaturesToPymol();
            }
        });
        this.viewerActionMenu.add(this.writeFeatures);
    }

    @Override
    protected void buildActionMenu() {
        super.buildActionMenu();
        this.viewerActionMenu.add(this.writeFeatures);
    }

    protected void sendFeaturesToPymol() {
        int count = this.binding.sendFeaturesToViewer(this.getAlignmentPanel());
        this.statusBar.setText(MessageManager.formatMessage("label.attributes_set", count, this.getViewerName()));
    }
}

