/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeLoader;
import jalview.schemes.ColourSchemes;
import jalview.schemes.UserColourScheme;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class ColourMenuHelper {
    public static ButtonGroup addMenuItems(final JMenu colourMenu, final ColourChangeListener client, AnnotatedCollectionI coll, boolean simpleOnly) {
        ButtonGroup colours = new ButtonGroup();
        if (!simpleOnly) {
            JRadioButtonMenuItem noColourmenuItem = new JRadioButtonMenuItem(MessageManager.getString("label.none"));
            noColourmenuItem.setName("None");
            noColourmenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    client.changeColour_actionPerformed("None");
                }
            });
            colourMenu.add(noColourmenuItem);
            colours.add(noColourmenuItem);
        }
        Iterable<ColourSchemeI> colourSchemes = ColourSchemes.getInstance().getColourSchemes();
        for (ColourSchemeI scheme : colourSchemes) {
            if (simpleOnly && !scheme.isSimple()) continue;
            final String name = scheme.getSchemeName();
            String label = MessageManager.getStringOrReturn("label.colourScheme_", name);
            final JRadioButtonMenuItem radioItem = new JRadioButtonMenuItem(label);
            radioItem.setName(name);
            radioItem.setEnabled(scheme.isApplicableTo(coll));
            if (scheme instanceof UserColourScheme) {
                radioItem.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        if (evt.isPopupTrigger() && !radioItem.isSelected()) {
                            this.offerRemoval();
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent evt) {
                        if (evt.isPopupTrigger() && !radioItem.isSelected()) {
                            this.offerRemoval();
                        }
                    }

                    void offerRemoval() {
                        ActionListener al = radioItem.getActionListeners()[0];
                        radioItem.removeActionListener(al);
                        int option = JvOptionPane.showInternalConfirmDialog((Component)Desktop.desktop, MessageManager.getString("label.remove_from_default_list"), MessageManager.getString("label.remove_user_defined_colour"), 0);
                        if (option == 0) {
                            ColourSchemes.getInstance().removeColourScheme(radioItem.getName());
                            colourMenu.remove(radioItem);
                            ColourMenuHelper.updatePreferences();
                        } else {
                            radioItem.addActionListener(al);
                        }
                    }
                });
            }
            radioItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    client.changeColour_actionPerformed(name);
                }
            });
            colourMenu.add(radioItem);
            colours.add(radioItem);
        }
        if (client instanceof AlignFrame) {
            String label = MessageManager.getString("action.user_defined");
            JRadioButtonMenuItem userDefinedColour = new JRadioButtonMenuItem(label);
            userDefinedColour.setName("*User Defined*");
            userDefinedColour.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    client.changeColour_actionPerformed("*User Defined*");
                }
            });
            colourMenu.add(userDefinedColour);
            colours.add(userDefinedColour);
        }
        return colours;
    }

    public static void setColourSelected(JMenu colourMenu, ColourSchemeI cs) {
        String colourName = cs == null ? "None" : cs.getSchemeName();
        AbstractButton none = null;
        AbstractButton userDefined = null;
        for (Component menuItem : colourMenu.getMenuComponents()) {
            if (!(menuItem instanceof JRadioButtonMenuItem)) continue;
            JRadioButtonMenuItem radioButton = (JRadioButtonMenuItem)menuItem;
            String buttonName = radioButton.getName();
            if (buttonName.equals(colourName)) {
                radioButton.setSelected(true);
                return;
            }
            if ("None".equals(buttonName)) {
                none = radioButton;
            }
            if (!"*User Defined*".equals(buttonName)) continue;
            userDefined = radioButton;
        }
        if (cs instanceof UserColourScheme && userDefined != null) {
            userDefined.setSelected(true);
        } else if (none != null) {
            none.setSelected(true);
        }
    }

    static void updatePreferences() {
        String[] files;
        StringBuilder coloursFound = new StringBuilder();
        for (String file : files = Cache.getProperty("USER_DEFINED_COLOURS").split("\\|")) {
            try {
                UserColourScheme ucs = ColourSchemeLoader.loadColourScheme(file);
                if (ucs == null || !ColourSchemes.getInstance().nameExists(ucs.getName())) continue;
                if (coloursFound.length() > 0) {
                    coloursFound.append("|");
                }
                coloursFound.append(file);
            }
            catch (Exception ex) {
                Console.outPrintln("Error loading User ColourFile\n" + ex);
            }
        }
        if (coloursFound.toString().length() > 1) {
            Cache.setProperty("USER_DEFINED_COLOURS", coloursFound.toString());
        } else {
            Cache.applicationProperties.remove("USER_DEFINED_COLOURS");
        }
    }

    public static interface ColourChangeListener {
        public void changeColour_actionPerformed(String var1);
    }
}

