/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

public enum MappingType {
    NucleotideToPeptide(3, 1){

        @Override
        public MappingType getInverse() {
            return PeptideToNucleotide;
        }
    }
    ,
    PeptideToNucleotide(1, 3){

        @Override
        public MappingType getInverse() {
            return NucleotideToPeptide;
        }
    }
    ,
    NucleotideToNucleotide(1, 1){

        @Override
        public MappingType getInverse() {
            return NucleotideToNucleotide;
        }
    }
    ,
    PeptideToPeptide(1, 1){

        @Override
        public MappingType getInverse() {
            return PeptideToPeptide;
        }
    };

    private int fromRatio;
    private int toRatio;

    private MappingType(int fromSize, int toSize) {
        this.fromRatio = fromSize;
        this.toRatio = toSize;
    }

    public abstract MappingType getInverse();

    public int getFromRatio() {
        return this.fromRatio;
    }

    public int getToRatio() {
        return this.toRatio;
    }
}

