/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactMapHolderI;
import jalview.datamodel.ContactMatrixI;
import jalview.ws.datamodel.MappableContactMatrixI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ContactMapHolder
implements ContactMapHolderI {
    Map<Object, ContactMatrixI> contactmaps = new HashMap<Object, ContactMatrixI>();

    @Override
    public Collection<ContactMatrixI> getContactMaps() {
        if (this.contactmaps != null && this.contactmaps.size() > 0) {
            return new HashSet<ContactMatrixI>(this.contactmaps.values());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public ContactListI getContactListFor(AlignmentAnnotation _aa, int column) {
        ContactMatrixI cm = this.contactmaps.get(_aa.annotationId);
        if (cm == null) {
            return null;
        }
        if (cm instanceof MappableContactMatrixI && _aa.sequenceRef != null) {
            return ((MappableContactMatrixI)cm).getMappableContactList(_aa.sequenceRef, column);
        }
        return cm.getContactList(column);
    }

    @Override
    public AlignmentAnnotation addContactList(ContactMatrixI cm) {
        AlignmentAnnotation aa = new AlignmentAnnotation(cm.getAnnotLabel(), cm.getAnnotDescr(), new Annotation[0]);
        aa.graph = 4;
        aa.graphMin = cm.getMin();
        aa.graphMax = cm.getMax();
        aa.editable = false;
        aa.calcId = cm.getType();
        this.contactmaps.put(aa.annotationId, cm);
        if (cm instanceof MappableContactMatrixI) {
            aa.setSequenceRef(((MappableContactMatrixI)cm).getReferenceSeq());
        }
        return aa;
    }

    @Override
    public ContactMatrixI getContactMatrixFor(AlignmentAnnotation ann) {
        return this.contactmaps == null ? null : this.contactmaps.get(ann.annotationId);
    }

    @Override
    public void addContactListFor(AlignmentAnnotation annotation, ContactMatrixI cm) {
        annotation.graphMin = cm.getMin();
        annotation.graphMax = cm.getMax();
        annotation.editable = false;
        annotation.graph = 4;
        annotation.calcId = cm.getType();
        if (annotation.label == null || "".equals(annotation.label)) {
            annotation.label = cm.getAnnotLabel();
        }
        if (annotation.description == null || "".equals(annotation.description)) {
            annotation.description = cm.getAnnotDescr();
        }
        this.contactmaps.put(annotation.annotationId, cm);
    }
}

