/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;

public class RemoveGapColCommand
extends EditCommand {
    int columnsDeleted;

    public RemoveGapColCommand(String description, SequenceI[] seqs, int start, int end, AlignmentI al) {
        this.description = description;
        int jSize = seqs.length;
        int startCol = -1;
        int endCol = -1;
        this.columnsDeleted = 0;
        this.clearEdits();
        boolean delete = true;
        for (int i = start; i <= end; ++i) {
            delete = true;
            for (int j = 0; j < jSize; ++j) {
                if (seqs[j].getLength() <= i || Comparison.isGap(seqs[j].getCharAt(i))) continue;
                if (delete) {
                    endCol = i;
                }
                delete = false;
                break;
            }
            if (delete && startCol == -1) {
                startCol = i;
            }
            if (delete || startCol <= -1) continue;
            this.appendEdit(EditCommand.Action.DELETE_GAP, seqs, startCol - this.columnsDeleted, endCol - startCol, al, false, null);
            this.columnsDeleted += endCol - startCol;
            startCol = -1;
            endCol = -1;
        }
        if (delete && startCol > -1) {
            this.appendEdit(EditCommand.Action.DELETE_GAP, seqs, startCol - this.columnsDeleted, end - startCol + 1, al, false, null);
            this.columnsDeleted += end - startCol + 1;
        }
        this.performEdit(0, null);
    }

    @Override
    public int getSize() {
        return this.columnsDeleted;
    }
}

