/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.ConnectivityException;
import jalview.datamodel.SequenceI;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Component;
import java.util.Hashtable;

public class Connectivity {
    public static Hashtable<SequenceI, Integer> getConnectivityForAlignmentView(AlignmentViewport av, float[][] scores, byte dim) {
        boolean isSelection = av.getSelectionGroup() != null && av.getSelectionGroup().getSize() > 0;
        SequenceI[] sequences = isSelection ? (SequenceI[])av.getAlignmentView(isSelection).getAlignmentAndHiddenColumns(av.getGapCharacter())[0] : av.getAlignment().getSequencesArray();
        return Connectivity.getConnectivity(sequences, scores, dim);
    }

    public static Hashtable<SequenceI, Integer> getConnectivity(SequenceI[] sequences, float[][] scores, byte dim) throws RuntimeException {
        Hashtable<SequenceI, Integer> connectivity = new Hashtable<SequenceI, Integer>();
        for (int i = 0; i < sequences.length; ++i) {
            connectivity.putIfAbsent(sequences[i], 0);
            for (int j = 0; j < i; ++j) {
                connectivity.putIfAbsent(sequences[j], 0);
                int iOld = connectivity.get(sequences[i]);
                int jOld = connectivity.get(sequences[j]);
                if (Float.isNaN(scores[i][j])) continue;
                connectivity.put(sequences[i], ++iOld);
                connectivity.put(sequences[j], ++jOld);
            }
        }
        connectivity.forEach((sequence, connection) -> {
            System.out.println(String.format("%s: %d", sequence.getName(), connection));
            if (connection < dim) {
                JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, String.format("Insufficient number of connections for %s (%d, should be %d or more)", sequence.getName(), connection, dim), "Connectivity Error", 2);
                throw new ConnectivityException(sequence.getName(), (int)connection, dim);
            }
        });
        return connectivity;
    }
}

