/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.Pthings;
import com.stevesoft.pat.StringLike;
import com.stevesoft.pat.patInf;
import com.stevesoft.pat.patInt;
import jalview.util.MessageManager;
import java.util.Hashtable;

public abstract class Pattern {
    public static final char ESC = '\\';
    static final String PROTECT_THESE = "[]{}(),$,-\"^.";
    Pattern next = null;
    Pattern parent = null;
    int mfrom = 0;

    public abstract int matchInternal(int var1, Pthings var2);

    public abstract String toString();

    public Pattern getNext() {
        return this.next != null ? this.next : (this.parent == null ? null : this.parent.getNext());
    }

    public void setParent(Pattern p) {
        if (this.next != null) {
            this.next.setParent(p);
        } else {
            this.parent = p;
        }
    }

    public int nextMatch(int i, Pthings pt) {
        Pattern p = this.getNext();
        return p == null ? i : p.matchInternal(i, pt);
    }

    public String nextString() {
        if (this.next == null) {
            return "";
        }
        return this.next.toString();
    }

    static final boolean inString(char c, String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    static final String protect(String s, String PROTECT_THESE, char esc) {
        StringBuffer sb = new StringBuffer();
        String p = PROTECT_THESE + esc;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Pattern.inString(c, p)) {
                sb.append(esc);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public int match(StringLike s, Pthings pt) {
        return this.matchAt(s, 0, pt);
    }

    public int matchAt(StringLike s, int i, Pthings pt) {
        pt.src = s;
        int r = this.matchInternal(i, pt);
        if (r < 0) {
            return -1;
        }
        this.mfrom = r < i ? r + 1 : i;
        return r < i ? i - r - 1 : r - i;
    }

    final boolean Masked(int i, Pthings pt) {
        return pt.cbits == null ? false : pt.cbits.get(i);
    }

    public Pattern add(Pattern p) {
        if (this.next == null) {
            if (p == null) {
                return this;
            }
            this.next = p;
            p.parent = this.parent;
            this.parent = null;
        } else {
            this.next.add(p);
        }
        return this;
    }

    public patInt minChars() {
        return new patInt(0);
    }

    public patInt maxChars() {
        return new patInf();
    }

    public final patInt countMinChars() {
        Pattern p = this;
        patInt sum = new patInt(0);
        while (p != null) {
            sum.pluseq(p.minChars());
            p = p.next;
        }
        return sum;
    }

    public final patInt countMaxChars() {
        Pattern p = this;
        patInt sum = new patInt(0);
        while (p != null) {
            sum.pluseq(p.maxChars());
            p = p.next;
        }
        return sum;
    }

    final int testMatch(Pattern p, int pos, Pthings pt) {
        int ret;
        int[] tab = null;
        if (pt.marks != null) {
            try {
                tab = new int[pt.marks.length];
                for (int i = 0; i < tab.length; ++i) {
                    tab[i] = pt.marks[i];
                }
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        if ((ret = p.matchInternal(pos, pt)) < 0) {
            pt.marks = tab;
        }
        return ret;
    }

    Pattern clone1(Hashtable h) {
        throw new Error(MessageManager.formatMessage("error.no_such_method_as_clone1_for", new String[]{this.getClass().getName()}));
    }

    Pattern clone(Hashtable h) {
        Pattern p = (Pattern)h.get(this);
        if (p != null) {
            return p;
        }
        p = this.clone1(h);
        if (p == null) {
            throw new Error(MessageManager.getString("error.null_from_clone1"));
        }
        h.put(this, p);
        h.put(p, p);
        if (this.next != null) {
            p.next = this.next.clone(h);
        }
        if (this.parent != null) {
            p.parent = this.parent.clone(h);
        }
        return p;
    }

    public boolean equals(Object o) {
        return o == this;
    }
}

