/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.MsaWS;
import compbio.data.msa.SequenceAnnotation;
import java.net.URL;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;

public final class Services
extends Enum<Services> {
    public static final /* enum */ Services MafftWS = new Services();
    public static final /* enum */ Services MuscleWS = new Services();
    public static final /* enum */ Services ClustalWS = new Services();
    public static final /* enum */ Services ClustalOWS = new Services();
    public static final /* enum */ Services TcoffeeWS = new Services();
    public static final /* enum */ Services ProbconsWS = new Services();
    public static final /* enum */ Services MSAprobsWS = new Services();
    public static final /* enum */ Services GLprobsWS = new Services();
    public static final /* enum */ Services AAConWS = new Services();
    public static final /* enum */ Services JronnWS = new Services();
    public static final /* enum */ Services DisemblWS = new Services();
    public static final /* enum */ Services GlobPlotWS = new Services();
    public static final /* enum */ Services IUPredWS = new Services();
    public static final /* enum */ Services RNAalifoldWS = new Services();
    static ServiceInfo AACON_INFO;
    static ServiceInfo CLUSTAL_INFO;
    static ServiceInfo CLUSTAL_OMEGA_INFO;
    static ServiceInfo DISEMBL_INFO;
    static ServiceInfo GLOBPLOT_INFO;
    static ServiceInfo IUPRED_INFO;
    static ServiceInfo TCOFFEE_INFO;
    static ServiceInfo MUSCLE_INFO;
    static ServiceInfo PROBCONS_INFO;
    static ServiceInfo MSAPROBS_INFO;
    static ServiceInfo GLPROBS_INFO;
    static ServiceInfo JRONN_INFO;
    static ServiceInfo MAFFT_INFO;
    static ServiceInfo RNAALIFOLD_INFO;
    private static final /* synthetic */ Services[] $VALUES;

    public static Services[] values() {
        return (Services[])$VALUES.clone();
    }

    public static Services valueOf(String name) {
        return Enum.valueOf(Services.class, name);
    }

    public static Services getService(String servName) {
        servName = servName.trim().toLowerCase();
        for (Services service : Services.values()) {
            if (!service.toString().equalsIgnoreCase(servName)) continue;
            return service;
        }
        return null;
    }

    Service getService(URL url, String sqname) {
        QName qname = new QName(sqname, this.toString());
        return Service.create((URL)url, (QName)qname);
    }

    public String getJabawsVersion() {
        return "2.2";
    }

    public static String toString(Set<Services> services) {
        if (services == null || services.isEmpty()) {
            return "No known services...\n";
        }
        String value = "";
        for (Services serv : services) {
            if (null != serv) {
                value = value + (Object)((Object)serv) + "\n";
                continue;
            }
            value = value + "Unknown Service\n";
        }
        return value;
    }

    Class<? extends JABAService> getServiceType() {
        switch (this) {
            case AAConWS: 
            case JronnWS: 
            case DisemblWS: 
            case GlobPlotWS: 
            case IUPredWS: 
            case RNAalifoldWS: {
                return SequenceAnnotation.class;
            }
            case ClustalWS: 
            case ClustalOWS: 
            case MafftWS: 
            case MuscleWS: 
            case ProbconsWS: 
            case MSAprobsWS: 
            case GLprobsWS: 
            case TcoffeeWS: {
                return MsaWS.class;
            }
        }
        throw new RuntimeException("Unrecognised Web Service Type " + (Object)((Object)this) + " - Should never happen!");
    }

    String getServiceNamespace() {
        switch (this) {
            case AAConWS: 
            case JronnWS: 
            case DisemblWS: 
            case GlobPlotWS: 
            case IUPredWS: 
            case RNAalifoldWS: 
            case ClustalOWS: 
            case MSAprobsWS: 
            case GLprobsWS: {
                return "http://msa.data.compbio/01/12/2010/";
            }
            case ClustalWS: 
            case MafftWS: 
            case MuscleWS: 
            case ProbconsWS: 
            case TcoffeeWS: {
                return "http://msa.data.compbio/01/01/2010/";
            }
        }
        throw new RuntimeException("Unrecognised JABAWS Namespace for service " + (Object)((Object)this) + "!");
    }

    JABAService getInterface(Service service) {
        assert (service != null);
        QName portName = new QName(service.getServiceName().getNamespaceURI(), this.toString() + "Port");
        return (JABAService)service.getPort(portName, this.getServiceType());
    }

    public String getServiceInfo() {
        switch (this) {
            case AAConWS: {
                return AACON_INFO.toString();
            }
            case ClustalOWS: {
                return CLUSTAL_OMEGA_INFO.toString();
            }
            case ClustalWS: {
                return CLUSTAL_INFO.toString();
            }
            case DisemblWS: {
                return DISEMBL_INFO.toString();
            }
            case GlobPlotWS: {
                return GLOBPLOT_INFO.toString();
            }
            case IUPredWS: {
                return IUPRED_INFO.toString();
            }
            case JronnWS: {
                return JRONN_INFO.toString();
            }
            case MafftWS: {
                return MAFFT_INFO.toString();
            }
            case MuscleWS: {
                return MUSCLE_INFO.toString();
            }
            case ProbconsWS: {
                return PROBCONS_INFO.toString();
            }
            case MSAprobsWS: {
                return MSAPROBS_INFO.toString();
            }
            case GLprobsWS: {
                return GLPROBS_INFO.toString();
            }
            case TcoffeeWS: {
                return TCOFFEE_INFO.toString();
            }
            case RNAalifoldWS: {
                return RNAALIFOLD_INFO.toString();
            }
        }
        throw new RuntimeException("Unrecognised Web Service Type " + (Object)((Object)this) + " - Should never happen!");
    }

    public String getServiceReference() {
        switch (this) {
            case AAConWS: {
                return AACON_INFO.getReference();
            }
            case ClustalOWS: {
                return CLUSTAL_OMEGA_INFO.getReference();
            }
            case ClustalWS: {
                return CLUSTAL_INFO.getReference();
            }
            case DisemblWS: {
                return DISEMBL_INFO.getReference();
            }
            case GlobPlotWS: {
                return GLOBPLOT_INFO.getReference();
            }
            case IUPredWS: {
                return IUPRED_INFO.getReference();
            }
            case JronnWS: {
                return JRONN_INFO.getReference();
            }
            case MafftWS: {
                return MAFFT_INFO.getReference();
            }
            case MuscleWS: {
                return MUSCLE_INFO.getReference();
            }
            case ProbconsWS: {
                return PROBCONS_INFO.getReference();
            }
            case MSAprobsWS: {
                return MSAPROBS_INFO.getReference();
            }
            case GLprobsWS: {
                return GLPROBS_INFO.getReference();
            }
            case TcoffeeWS: {
                return TCOFFEE_INFO.getReference();
            }
            case RNAalifoldWS: {
                return RNAALIFOLD_INFO.getReference();
            }
        }
        throw new RuntimeException("Unrecognised Web Service Type " + (Object)((Object)this) + " - Should never happen!");
    }

    public String getServiceVersion() {
        switch (this) {
            case AAConWS: {
                return AACON_INFO.getVersion();
            }
            case ClustalOWS: {
                return CLUSTAL_OMEGA_INFO.getVersion();
            }
            case ClustalWS: {
                return CLUSTAL_INFO.getVersion();
            }
            case DisemblWS: {
                return DISEMBL_INFO.getVersion();
            }
            case GlobPlotWS: {
                return GLOBPLOT_INFO.getVersion();
            }
            case IUPredWS: {
                return IUPRED_INFO.getVersion();
            }
            case JronnWS: {
                return JRONN_INFO.getVersion();
            }
            case MafftWS: {
                return MAFFT_INFO.getVersion();
            }
            case MuscleWS: {
                return MUSCLE_INFO.getVersion();
            }
            case ProbconsWS: {
                return PROBCONS_INFO.getVersion();
            }
            case MSAprobsWS: {
                return MSAPROBS_INFO.getVersion();
            }
            case GLprobsWS: {
                return GLPROBS_INFO.getVersion();
            }
            case TcoffeeWS: {
                return TCOFFEE_INFO.getVersion();
            }
            case RNAalifoldWS: {
                return RNAALIFOLD_INFO.getVersion();
            }
        }
        throw new RuntimeException("Unrecognised Web Service Type " + (Object)((Object)this) + " - Should never happen!");
    }

    public String getServiceGroup() {
        switch (this) {
            case AAConWS: {
                return "annotation";
            }
            case ClustalOWS: {
                return "alignment";
            }
            case ClustalWS: {
                return "alignment";
            }
            case DisemblWS: {
                return "disorder";
            }
            case GlobPlotWS: {
                return "disorder";
            }
            case IUPredWS: {
                return "disorder";
            }
            case JronnWS: {
                return "disorder";
            }
            case MafftWS: {
                return "alignment";
            }
            case MuscleWS: {
                return "alignment";
            }
            case ProbconsWS: {
                return "alignment";
            }
            case GLprobsWS: {
                return "alignment";
            }
            case MSAprobsWS: {
                return "alignment";
            }
            case TcoffeeWS: {
                return "alignment";
            }
            case RNAalifoldWS: {
                return "annotation";
            }
        }
        throw new RuntimeException("Unrecognised Web Service Type " + (Object)((Object)this) + " - Should never happen!");
    }

    public static void main(String[] args) {
        System.out.println(MUSCLE_INFO);
    }

    static {
        $VALUES = new Services[]{MafftWS, MuscleWS, ClustalWS, ClustalOWS, TcoffeeWS, ProbconsWS, MSAprobsWS, GLprobsWS, AAConWS, JronnWS, DisemblWS, GlobPlotWS, IUPredWS, RNAalifoldWS};
        AACON_INFO = new ServiceInfo(AAConWS, "Peter V. Troshin, Agnieszka Golicz, David M. A. Martin, F\u00e1bio Madeira, James B. Procter and Geoffrey J. Barton\r\n\"AACon: A Fast Amino Acid Conservation Calculation Service\"\r\n(2017) Paper in preparation.", "1.1", "http://www.compbio.dundee.ac.uk/aacon");
        CLUSTAL_INFO = new ServiceInfo(ClustalWS, "Larkin MA, Blackshields G, Brown NP, Chenna R, McGettigan PA, McWilliam H, Valentin F, Wallace IM, Wilm A, Lopez R, Thompson JD, Gibson TJ, Higgins DG,\r\n\"Clustal W and Clustal X version 2.0\"\r\nBioinformatics, 23: 2947 (2007)", "2.1", "http://www.clustal.org/clustal2/");
        CLUSTAL_OMEGA_INFO = new ServiceInfo(ClustalOWS, "Sievers F, Wilm A, Dineen D, Gibson TJ, Karplus K, Li W, Lopez R, McWilliam H, Remmert M, S\u00f6ding J, Thompson JD, Higgins DG,\r\n\"Fast, scalable generation of high quality protein multiple sequence alignments using Clustal Omega\"\r\nMol Syst Biol. 7:539 (2011)", "1.2.4", "http://www.clustal.org/omega/");
        DISEMBL_INFO = new ServiceInfo(DisemblWS, "Linding R, Jensen LJ, Diella F, Bork P, Gibson TJ, and Russell RB,\r\n\"Protein disorder prediction: implications for structural proteomics\"\r\nStructure 11(11):1453 (2003)", "1.5", "http://dis.embl.de/");
        GLOBPLOT_INFO = new ServiceInfo(GlobPlotWS, "Linding R, Russell RB, Neduva V and Gibson TJ,\r\nGlobPlot: exploring protein sequences for globularity and disorder\r\nNucl. Acids Res. 31 (13):3701 (2003)", "2.3", "http://globplot.embl.de/");
        IUPRED_INFO = new ServiceInfo(IUPredWS, "Doszt\u00e1nyi Z, Csizm\u00f3k V, Tompa P, and Simon I,\r\n\"The Pairwise Energy Content Estimated from Amino Acid Composition Discriminates between Folded and Intrinsically Unstructured Proteins\"\r\nJ. Mol. Biol. 347:827 (2005)", "1.0", "http://iupred.enzim.hu/");
        TCOFFEE_INFO = new ServiceInfo(TcoffeeWS, "Notredame C, Higgins DG, Heringa L,\r\n\"T-Coffee: A novel method for multiple sequence alignments\"\r\nJMB, 302(1):205 (2000)", "11.00.8cbe486", "http://tcoffee.crg.cat/apps/tcoffee/index.html");
        MUSCLE_INFO = new ServiceInfo(MuscleWS, "Edgar RC,\r\n\"MUSCLE: multiple sequence alignment with high accuracy and high throughput\"\r\nNucleic Acids Res. 32(5):1792 (2004)", "3.8.31", "http://www.drive5.com/muscle/");
        PROBCONS_INFO = new ServiceInfo(ProbconsWS, "Do CB, Mahabhashyam MSP, Brudno M, and Batzoglou S,\r\n\"PROBCONS: Probabilistic Consistency-based Multiple Sequence Alignment\"\r\nGenome Research 15:330 (2005)", "1.12", "http://probcons.stanford.edu/");
        MSAPROBS_INFO = new ServiceInfo(MSAprobsWS, "Liu Y, Schmidt B, and Maskell DL,\r\n\"MSAProbs: multiple sequence alignment based on pair hidden Markov models and partition function posterior probabilities\"\r\nBioinformatics, 26 (16):1958 (2010)", "0.9.7", "http://msaprobs.sourceforge.net/");
        GLPROBS_INFO = new ServiceInfo(GLprobsWS, "Yongtao Ye, Siu-Ming Yiu, David W. Cheung, Qing Zhan, Hing-Fung Ting, Yadong Wang, Tak-Wah Lam,\r\n\"GLProbs: Aligning multiple sequences adaptively\"\r\nin progress (2013)", "1.0", "http://sourceforge.net/projects/glprobs/");
        JRONN_INFO = new ServiceInfo(JronnWS, "unpublished, original algorithm Yang ZR, Thomson R, McMeil P, and Esnouf RM,\r\n\"RONN: the bio-basis function neural network technique applied to the dectection of natively disordered regions in proteins\"\r\nBioinformatics 21:3369 (2005)\r\n", "1.0", "http://www.compbio.dundee.ac.uk/jabaws/");
        MAFFT_INFO = new ServiceInfo(MafftWS, "Katoh K, Toh H,\r\n\"Parallelization of the MAFFT multiple sequence alignment program\"\r\nBioinformatics 26:1899 (2010)", "7.310", "http://mafft.cbrc.jp/alignment/software/");
        RNAALIFOLD_INFO = new ServiceInfo(RNAalifoldWS, "Hofacker IL, Fekete M, and Stadler PV,\r\n\"Secondary Structure Prediction for Aligned RNA Sequences\"\r\nJ.Mol.Biol. 319:1059 (2002) and\r\n Bernhart SH, Hofacker IL Will S, Gruber AR, and Stadler PF,\r\n\"RNAalifold: Improved consensus structure prediction for RNA alignments\"\r\nBMC Bioinformatics, 9:474 (2008)\r\n", "2.1.2", "http://www.tbi.univie.ac.at/RNA/");
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ServiceInfo {
        Services service;
        String reference;
        String version;
        String moreinfo;
        static final String line_delimiter = "\n";

        private ServiceInfo() {
        }

        private ServiceInfo(Services service, String reference, String version, String moreinfo) {
            this.service = service;
            this.reference = reference;
            this.version = version;
            this.moreinfo = moreinfo;
        }

        public String toString() {
            String value = "SERVICE: " + (Object)((Object)this.service) + " version " + this.version + line_delimiter + line_delimiter;
            value = value + "JABAWS v. 2.2\n";
            value = value + "REFERENCE: " + this.reference + line_delimiter + line_delimiter;
            value = value + "MORE INFORMATION: " + this.moreinfo + line_delimiter;
            return value;
        }

        public String getReference() {
            return "REFERENCE: " + this.reference + line_delimiter + "<br>MORE INFORMATION: " + this.moreinfo + line_delimiter;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

