/*
 * Decompiled with CFR 0.152.
 */
package compbio.util;

import compbio.util.NullOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.TimeUnit;

public class Timer {
    private long checkPoint;
    private final long startTime;
    private TimeUnit reportTimeUnit;
    private PrintWriter statWriter;

    public Timer() {
        this.checkPoint = this.startTime = System.nanoTime();
        this.reportTimeUnit = TimeUnit.SECONDS;
    }

    public Timer(Timer timer) {
        this();
        this.reportTimeUnit = timer.reportTimeUnit;
        this.statWriter = timer.getStatWriter();
    }

    public Timer(OutputStream statistics) throws IOException {
        this();
        this.setStatOutput(statistics);
    }

    public synchronized void setStatOutput(OutputStream statistics) {
        this.statWriter = statistics != null ? new PrintWriter((Writer)new OutputStreamWriter(statistics), true) : new PrintWriter(new NullOutputStream());
    }

    public PrintWriter getStatWriter() {
        if (this.statWriter == null) {
            throw new IllegalStateException("Must use file or Output stream constructor is writer is required!");
        }
        return this.statWriter;
    }

    public void print(String statMessage) {
        this.getStatWriter().print(statMessage);
    }

    public void println(String statMessage) {
        this.getStatWriter().println(statMessage);
    }

    public Timer(TimeUnit reportIn) {
        this();
        this.reportTimeUnit = reportIn;
    }

    public static Timer getMicroSecondsTimer() {
        return new Timer(TimeUnit.MICROSECONDS);
    }

    public static Timer getMinutesTimer() {
        return new Timer(TimeUnit.MINUTES);
    }

    public static Timer getMilliSecondsTimer() {
        return new Timer(TimeUnit.MILLISECONDS);
    }

    private void checkPoint() {
        this.checkPoint = System.nanoTime();
    }

    public long getStepTime(TimeUnit tunit) {
        long duration = tunit.convert(System.nanoTime() - this.checkPoint, TimeUnit.NANOSECONDS);
        this.checkPoint();
        return duration;
    }

    public long getStepTime() {
        return this.getStepTime(this.reportTimeUnit);
    }

    public long getTotalTime() {
        return this.getTotalTime(this.reportTimeUnit);
    }

    public long getTotalTime(TimeUnit tunit) {
        return tunit.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
    }
}

