/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.SessionFile;
import uk.ac.vamsas.client.simpleclient.SessionFileWatcherElement;
import uk.ac.vamsas.client.simpleclient.VamsasFileWatcherElement;
import uk.ac.vamsas.client.simpleclient.WatcherCallBack;

public class ClientSessionFileWatcherElement
extends SessionFileWatcherElement {
    private static Log log = LogFactory.getLog((Class)VamsasFileWatcherElement.class);
    private int timeoutBeforeLastCycle = -1;
    private boolean isTimeOutEnable = false;
    protected int cycleCountSinceModif = 0;

    public ClientSessionFileWatcherElement(SessionFile watcher, WatcherCallBack handler) {
        super(watcher, handler);
    }

    public ClientSessionFileWatcherElement(SessionFile watcher, WatcherCallBack handler, boolean enableWatching) {
        super(watcher, handler, enableWatching);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWatch() {
        if (!this.watchForChange || this.handler == null) {
            return false;
        }
        if (this.watcher == null) {
            this.initWatch();
        }
        this.handlerCalled = false;
        Lock doclock = null;
        try {
            doclock = this.watcher.getChangedState();
        }
        catch (Exception e) {
            log.error((Object)("Whilst watching " + this.watcher.getSubject()), (Throwable)e);
        }
        if (doclock == null) {
            ++this.cycleCountSinceModif;
            if (this.isTimeOutEnable && this.cycleCountSinceModif > this.timeoutBeforeLastCycle && this.handler != null) {
                WatcherCallBack watcherCallBack = this.handler;
                synchronized (watcherCallBack) {
                    this.callHandler(doclock);
                }
            }
            return false;
        }
        if (this.isTimeOutEnable) {
            this.cycleCountSinceModif = 0;
        }
        if (this.handler != null) {
            WatcherCallBack watcherCallBack = this.handler;
            synchronized (watcherCallBack) {
                this.callHandler(doclock);
            }
        }
        return true;
    }

    protected void resetCycleCount() {
        this.cycleCountSinceModif = 0;
    }

    protected void increaseCycleCount() {
        ++this.cycleCountSinceModif;
    }

    public void setTimeoutBeforeLastCycle(int timeoutBeforeLastCycle) {
        this.timeoutBeforeLastCycle = timeoutBeforeLastCycle;
        if (this.timeoutBeforeLastCycle > 0) {
            this.isTimeOutEnable = true;
        }
    }

    public void disableCycleTimeOut() {
        this.isTimeOutEnable = false;
    }
}

