/*
 * Decompiled with CFR 0.152.
 */
package org.stackoverflowusers.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Locale;

public class WindowsShortcut {
    private boolean isDirectory;
    private boolean isLocal;
    private String real_file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPotentialValidLink(File file) throws IOException {
        int minimum_length = 100;
        boolean isPotentiallyValid = false;
        try (FileInputStream fis = new FileInputStream(file);){
            isPotentiallyValid = file.isFile() && file.getName().toLowerCase(Locale.ROOT).endsWith(".lnk") && ((InputStream)fis).available() >= 100 && WindowsShortcut.isMagicPresent(WindowsShortcut.getBytes(fis, 32));
        }
        return isPotentiallyValid;
    }

    public WindowsShortcut(File file) throws IOException, ParseException {
        try (FileInputStream in = new FileInputStream(file);){
            this.parseLink(WindowsShortcut.getBytes(in));
        }
    }

    public String getRealFilename() {
        return this.real_file;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    private static byte[] getBytes(InputStream in) throws IOException {
        return WindowsShortcut.getBytes(in, null);
    }

    private static byte[] getBytes(InputStream in, Integer max) throws IOException {
        int n;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buff = new byte[256];
        while ((max == null || max > 0) && (n = in.read(buff)) != -1) {
            bout.write(buff, 0, n);
            if (max == null) continue;
            max = max - n;
        }
        in.close();
        return bout.toByteArray();
    }

    private static boolean isMagicPresent(byte[] link) {
        int magic = 76;
        boolean magic_offset = false;
        return link.length >= 32 && WindowsShortcut.bytesToDword(link, 0) == 76;
    }

    private void parseLink(byte[] link) throws ParseException {
        try {
            if (!WindowsShortcut.isMagicPresent(link)) {
                throw new ParseException("Invalid shortcut; magic is missing", 0);
            }
            byte flags = link[20];
            int file_atts_offset = 24;
            byte file_atts = link[24];
            int is_dir_mask = 16;
            this.isDirectory = (file_atts & is_dir_mask) > 0;
            int shell_offset = 76;
            boolean has_shell_mask = true;
            int shell_len = 0;
            if ((flags & 1) > 0) {
                shell_len = WindowsShortcut.bytesToWord(link, 76) + 2;
            }
            int file_start = 76 + shell_len;
            int file_location_info_flag_offset_offset = 8;
            byte file_location_info_flag = link[file_start + 8];
            this.isLocal = (file_location_info_flag & 2) == 0;
            int basename_offset_offset = 16;
            int networkVolumeTable_offset_offset = 20;
            int finalname_offset_offset = 24;
            int finalname_offset = link[file_start + 24] + file_start;
            String finalname = WindowsShortcut.getNullDelimitedString(link, finalname_offset);
            if (this.isLocal) {
                int basename_offset = link[file_start + 16] + file_start;
                String basename = WindowsShortcut.getNullDelimitedString(link, basename_offset);
                this.real_file = basename + finalname;
            } else {
                int networkVolumeTable_offset = link[file_start + 20] + file_start;
                int shareName_offset_offset = 8;
                int shareName_offset = link[networkVolumeTable_offset + shareName_offset_offset] + networkVolumeTable_offset;
                String shareName = WindowsShortcut.getNullDelimitedString(link, shareName_offset);
                this.real_file = shareName + "\\" + finalname;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Could not be parsed, probably not a valid WindowsShortcut", 0);
        }
    }

    private static String getNullDelimitedString(byte[] bytes, int off) {
        int len = 0;
        while (bytes[off + len] != 0) {
            ++len;
        }
        return new String(bytes, off, len);
    }

    private static int bytesToWord(byte[] bytes, int off) {
        return (bytes[off + 1] & 0xFF) << 8 | bytes[off] & 0xFF;
    }

    private static int bytesToDword(byte[] bytes, int off) {
        return WindowsShortcut.bytesToWord(bytes, off + 2) << 16 | WindowsShortcut.bytesToWord(bytes, off);
    }
}

