/*
 * Decompiled with CFR 0.152.
 */
package javajs.async;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.Timer;

public class SwingJSUtils {
    public static Dimension setDim(int w, int h) {
        boolean isTest;
        String baseURI = null;
        boolean bl = isTest = baseURI == null || baseURI.indexOf("_applet.html") >= 0;
        if (!isTest) {
            return null;
        }
        return new Dimension(w, h);
    }

    public static Object getResource(Class<?> baseClass, String filename, Class<?> cl) {
        System.out.println("mpUtils.SwingJSUtils.getResource " + baseClass.getCanonicalName() + " " + filename);
        InputStream is = baseClass.getResourceAsStream(filename);
        if (cl == Image.class) {
            try {
                return ImageIO.read(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (cl == String.class) {
            return new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
        }
        return is;
    }

    public static void loadImagesStatic(Class<?> cl, Image[] images, String root, String ext, int nImages) {
        int i = nImages;
        while (--i >= 0) {
            images[i] = (Image)SwingJSUtils.getResource(cl, root + i + "." + ext, Image.class);
        }
    }

    public static void loadImagesStatic(Class<?> cl, String root, String[] names, Image[] images) {
        int i = names.length;
        while (--i >= 0) {
            images[i] = (Image)SwingJSUtils.getResource(cl, root + names[i], Image.class);
        }
    }

    public static Image getImage(Component c, String fileName) {
        return SwingJSUtils.getImage(c.getClass(), fileName);
    }

    public static Image getImage(Class<?> c, String fileName) {
        return (Image)SwingJSUtils.getResource(c, fileName, Image.class);
    }

    public static void clearComponent(Component c) {
        Graphics gc = c.getGraphics();
        gc.clearRect(0, 0, c.getWidth(), c.getHeight());
        gc.dispose();
    }

    public static BufferedInputStream openStream(Class<?> base, String fileName) {
        String s = (String)SwingJSUtils.getResource(base, fileName, String.class);
        return new BufferedInputStream(new ByteArrayInputStream(s.getBytes()));
    }

    public static class Performance {
        public static final int TIME_RESET = 0;
        public static final int TIME_MARK = 1;
        public static final int TIME_SET = 2;
        public static final int TIME_GET = 3;
        public static long time;
        public static long mark;
        public static long set;
        public static long duration;

        public static void timeCheck(String msg, int mode) {
            if ((msg = Performance.timeCheckStr(msg, mode)) != null) {
                System.err.println(msg);
            }
        }

        public static long now(long t) {
            return System.currentTimeMillis() - t;
        }

        public static String timeCheckStr(String msg, int mode) {
            long t = System.currentTimeMillis();
            switch (mode) {
                case 0: {
                    time = mark = t;
                    set = 0L;
                    duration = 0L;
                    if (msg == null) break;
                    return "Platform: timer reset\t\t\t" + msg;
                }
                case 2: {
                    if (time == 0L) {
                        time = t;
                    }
                    set = t;
                    break;
                }
                case 1: {
                    if (set > 0L) {
                        duration += t - set;
                        break;
                    }
                    if (time == 0L) {
                        time = mark = t;
                    }
                    if (msg != null) {
                        long m0 = mark;
                        mark = t;
                        return "Platform: timer mark\t" + (float)(t - time) / 1000.0f + "\t" + (float)(t - m0) / 1000.0f + "\t" + msg;
                    }
                    mark = t;
                    break;
                }
                case 3: {
                    if (msg != null) {
                        if (mark < set) {
                            duration = t - set;
                        }
                        return "Platform: timer get\t" + (float)(t - time) / 1000.0f + "\t" + (float)duration / 1000.0f + "\t" + msg;
                    }
                    set = 0L;
                }
            }
            return null;
        }
    }

    public static class StateHelper {
        public static final int UNCHANGED = Integer.MIN_VALUE;
        private StateMachine machine;
        private int state;
        private int level;
        private boolean interrupted;
        private Timer stateTimer;
        private int stateNext;
        private int levelNext;

        public StateHelper(StateMachine machine) {
            this.machine = machine;
        }

        public void interrupt() {
            this.interrupted = true;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public boolean isAlive() {
            return !this.interrupted;
        }

        public void restart() {
            this.interrupted = false;
        }

        public void setState(int state) {
            this.state = this.stateNext = state;
        }

        public int getState() {
            return this.state;
        }

        public void setLevel(int level) {
            this.level = this.levelNext = level;
        }

        public int getLevel() {
            return this.level;
        }

        public void setNextState(int next) {
            this.stateNext = next;
        }

        public int getNextState() {
            return this.stateNext;
        }

        public int getNextLevel() {
            return this.levelNext;
        }

        public void setNextLevel(int next) {
            this.levelNext = next;
        }

        private boolean nextState() {
            return this.next(this.stateNext, this.levelNext);
        }

        public boolean next(int state) {
            return this.next(state, 0);
        }

        public boolean next(int state, int level) {
            return StateHelper.nextStatePriv(this, state, level);
        }

        private static boolean nextStatePriv(Object oThis, int state, int level) {
            StateHelper me = (StateHelper)oThis;
            if (me.interrupted) {
                return false;
            }
            if (level != Integer.MIN_VALUE) {
                me.level = level;
            }
            if (state != Integer.MIN_VALUE) {
                me.state = state;
            }
            return me.machine.stateLoop();
        }

        public boolean delayedState(int ms, int stateNext) {
            return this.delayedState(ms, stateNext, this.level);
        }

        public boolean delayedState(int ms, int stateNext, int levelNext) {
            if (this.interrupted) {
                return false;
            }
            if (ms == 0) {
                return this.next(stateNext, levelNext);
            }
            if (stateNext != Integer.MIN_VALUE) {
                this.stateNext = stateNext;
            }
            if (levelNext != Integer.MIN_VALUE) {
                this.levelNext = levelNext;
            }
            if (this.stateTimer == null) {
                this.stateTimer = new Timer(ms, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.nextState();
                    }
                });
                this.stateTimer.setRepeats(false);
                this.stateTimer.start();
            } else {
                this.stateTimer.restart();
            }
            return true;
        }

        public boolean delayedAction(int ms, int id, String command, ActionListener listener) {
            return this.delayedAction(ms, id, command, listener, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public boolean delayedAction(int ms, int id, String command, ActionListener listener, int state) {
            return this.delayedAction(ms, id, command, listener, state, Integer.MIN_VALUE);
        }

        public boolean delayedAction(int ms, int id, String command, final ActionListener listener, final int stateNext, final int levelNext) {
            if (this.interrupted) {
                return false;
            }
            final ActionEvent event = new ActionEvent(this, id, command);
            if (ms == 0) {
                listener.actionPerformed(event);
                return stateNext == Integer.MIN_VALUE && levelNext == Integer.MIN_VALUE || StateHelper.nextStatePriv(this, stateNext == Integer.MIN_VALUE ? this.state : stateNext, levelNext == Integer.MIN_VALUE ? this.level : levelNext);
            }
            final StateHelper me = this;
            Timer timer = new Timer(ms, id == 1001 ? listener : new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!interrupted) {
                        listener.actionPerformed(event);
                    }
                    if (!(interrupted || stateNext == Integer.MIN_VALUE && levelNext == Integer.MIN_VALUE)) {
                        StateHelper.nextStatePriv(me, stateNext == Integer.MIN_VALUE ? state : stateNext, levelNext == Integer.MIN_VALUE ? level : levelNext);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
            return true;
        }

        public static void delayedRun(int ms, Runnable runnable) {
            new StateHelper(null).delayedRun(ms, runnable, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public boolean delayedRun(int ms, final Runnable runnable, final int stateNext, final int levelNext) {
            if (this.interrupted) {
                return false;
            }
            if (ms == 0) {
                return stateNext == Integer.MIN_VALUE && levelNext == Integer.MIN_VALUE || this.nextStateIfUnchanged(this, runnable, stateNext == Integer.MIN_VALUE ? this.state : stateNext, levelNext == Integer.MIN_VALUE ? this.level : levelNext);
            }
            final StateHelper me = this;
            Timer timer = new Timer(ms, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.nextStateIfUnchanged(me, runnable, stateNext, levelNext);
                }
            });
            timer.setRepeats(false);
            timer.start();
            return true;
        }

        protected boolean nextStateIfUnchanged(Object oThis, Object runnable, int stateNext, int levelNext) {
            StateHelper me = (StateHelper)oThis;
            if (!me.interrupted) {
                ((Runnable)runnable).run();
            }
            if (!(me.interrupted || stateNext == Integer.MIN_VALUE && levelNext == Integer.MIN_VALUE)) {
                StateHelper.nextStatePriv(oThis, stateNext == Integer.MIN_VALUE ? me.state : stateNext, levelNext == Integer.MIN_VALUE ? me.level : levelNext);
            }
            return true;
        }

        public void sleep(int ms) {
            int next = this.stateNext;
            this.delayedState(ms, next);
        }
    }

    public static interface StateMachine {
        public boolean stateLoop();
    }
}

