/*
 * Decompiled with CFR 0.152.
 */
package javajs.async;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.function.Function;
import javajs.async.AsyncDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class AsyncFileChooser
extends JFileChooser
implements PropertyChangeListener {
    private int optionSelected;
    private Runnable ok;
    private Runnable cancel;
    private boolean isAsyncSave = true;
    private static boolean notified;

    public AsyncFileChooser() {
    }

    public AsyncFileChooser(File file) {
        super(file);
    }

    public AsyncFileChooser(File file, FileSystemView view) {
        super(file, view);
    }

    @Override
    @Deprecated
    public int showDialog(Component frame, String btnText) {
        return super.showDialog(frame, btnText);
    }

    private int err() {
        try {
            throw new IllegalAccessException("Warning! AsyncFileChooser interface bypassed!");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    @Deprecated
    public int showOpenDialog(Component frame) {
        return this.err();
    }

    @Override
    public int showSaveDialog(Component frame) {
        this.isAsyncSave = false;
        return super.showSaveDialog(frame);
    }

    public void showDialog(Component frame, String btnLabel, Runnable ok, Runnable cancel) {
        this.ok = ok;
        if (this.getDialogType() != 1 && cancel != null) {
            this.notifyCancel();
        }
        this.process(super.showDialog(frame, btnLabel));
    }

    public void showOpenDialog(Component frame, Runnable ok, Runnable cancel) {
        this.ok = ok;
        if (cancel != null) {
            this.notifyCancel();
        }
        this.process(super.showOpenDialog(frame));
    }

    public void showSaveDialog(Component frame, Runnable ok, Runnable cancel) {
        this.ok = ok;
        this.cancel = cancel;
        this.process(super.showSaveDialog(frame));
    }

    public static void getFileAsync(Component parent, String title, int mode, final Function<File, Void> processFile) {
        final AsyncFileChooser fc = new AsyncFileChooser();
        fc.setDialogTitle(title);
        Runnable after = new Runnable(){

            @Override
            public void run() {
                processFile.apply(fc.getSelectedFile());
            }
        };
        if (mode == 0) {
            fc.showOpenDialog(parent, after, after);
        } else {
            fc.showSaveDialog(parent, after, after);
        }
    }

    public static void checkReplaceFileAsync(Component parent, File outfile, String title, final Runnable yes, final Runnable no) {
        if (outfile.exists()) {
            AsyncDialog.showYesNoAsync(parent, outfile + " exists. Replace it?", null, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 0: {
                            yes.run();
                            break;
                        }
                        default: {
                            if (no == null) break;
                            no.run();
                        }
                    }
                }
            });
        } else {
            yes.run();
        }
    }

    private void notifyCancel() {
        if (!notified) {
            System.err.println("developer note: JavaScript cannot fire a FileChooser CANCEL action");
        }
        notified = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "SelectedFile": 
            case "SelectedFiles": {
                this.optionSelected = evt.getNewValue() == null ? 1 : 0;
                this.process(this.optionSelected);
            }
        }
    }

    private void process(int ret) {
        if (ret != -(-ret)) {
            return;
        }
        this.optionSelected = ret;
        File f = this.getSelectedFile();
        if (f == null) {
            if (this.cancel != null) {
                this.cancel.run();
            }
        } else if (this.ok != null) {
            this.ok.run();
        }
    }

    public int getSelectedOption() {
        return this.optionSelected;
    }

    public static byte[] getFileBytes(File f) {
        return null;
    }
}

