/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.gui;

import jalview.api.FeatureColourI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.schemes.FeatureSettingsAdapter;
import jalview.util.MathUtils;
import jalview.ws2.actions.annotation.AlignCalcWorkerAdapter;
import jalview.ws2.actions.annotation.AnnotationAction;
import jalview.ws2.actions.annotation.AnnotationResult;

public class AnnotationServiceGuiHandler
implements AlignCalcWorkerAdapter.WorkerListener {
    private final long progressId = MathUtils.getUID();
    private final AlignFrame alignFrame;
    private final AlignmentPanel alignPanel;
    private final IProgressIndicator progressIndicator;
    private final AnnotationAction action;

    public AnnotationServiceGuiHandler(AnnotationAction action, AlignFrame frame) {
        this.alignFrame = frame;
        this.alignPanel = frame.alignPanel;
        this.progressIndicator = frame;
        this.action = action;
    }

    @Override
    public void workerStarted(final AlignCalcWorkerAdapter source) {
        this.progressIndicator.addProgressBar(this.progressId, this.action.getFullName());
        this.progressIndicator.registerHandler(this.progressId, new IProgressIndicatorHandler(){

            @Override
            public boolean cancelActivity(long id) {
                source.cancel();
                return true;
            }

            @Override
            public boolean canCancel() {
                return true;
            }
        });
    }

    @Override
    public void workerStopped(AlignCalcWorkerAdapter source) {
        this.progressIndicator.removeProgressBar(this.progressId);
    }

    @Override
    public void workerHasResult(AlignCalcWorkerAdapter source, final AnnotationResult result) {
        if (result == null) {
            return;
        }
        if (result.getHasFeatures()) {
            this.alignFrame.getViewport().applyFeaturesStyle(new FeatureSettingsAdapter(){

                @Override
                public FeatureColourI getFeatureColour(String type) {
                    return result.getFeatureColours().get(type);
                }

                @Override
                public FeatureMatcherSetI getFeatureFilters(String type) {
                    return result.getFeatureFilters().get(type);
                }

                @Override
                public boolean isFeatureDisplayed(String type) {
                    return result.getFeatureColours().containsKey(type);
                }
            });
            if (this.alignFrame.alignPanel == this.alignPanel) {
                this.alignFrame.getViewport().setShowSequenceFeatures(true);
                this.alignFrame.setMenusForViewport();
            }
        }
        this.alignPanel.adjustAnnotationHeight();
    }
}

