/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.slivka;

import com.stevesoft.pat.NotImplementedError;
import jalview.bin.Console;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import jalview.ws.params.WsParamSetI;
import jalview.ws.params.simple.BooleanOption;
import jalview.ws.params.simple.DoubleParameter;
import jalview.ws.params.simple.IntegerParameter;
import jalview.ws.params.simple.Option;
import jalview.ws.params.simple.StringParameter;
import jalview.ws2.params.SimpleParamDatastore;
import jalview.ws2.params.SimpleParamSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import uk.ac.dundee.compbio.slivkaclient.Parameter;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

class SlivkaParamStoreFactory {
    private final SlivkaService service;
    private final ParamManager manager;

    SlivkaParamStoreFactory(SlivkaService service, ParamManager manager) {
        this.service = service;
        this.manager = manager;
    }

    ParamDatastoreI createParamDatastore() {
        URL url = null;
        try {
            url = this.service.getUrl().toURL();
        }
        catch (MalformedURLException e) {
            Console.warn("Invalid service url " + this.service.getUrl(), e);
        }
        ArrayList<WsParamSetI> presets = new ArrayList<WsParamSetI>(this.service.getPresets().size());
        for (SlivkaService.Preset preset : this.service.getPresets()) {
            presets.add(this.createPreset(preset));
        }
        List<ArgumentI> arguments = this.createPresetArguments(Collections.emptyMap());
        return new SimpleParamDatastore(url, arguments, presets, this.manager);
    }

    WsParamSetI createPreset(SlivkaService.Preset preset) {
        SimpleParamSet.Builder builder = SimpleParamSet.newBuilder();
        builder.name(preset.name);
        builder.description(preset.description);
        builder.url(this.service.getUrl().toString());
        builder.modifiable(false);
        builder.arguments(this.createPresetArguments(preset.values));
        return builder.build();
    }

    List<ArgumentI> createPresetArguments(Map<String, Object> values) {
        ArrayList<ArgumentI> args = new ArrayList<ArgumentI>();
        for (Parameter param : this.service.getParameters()) {
            if (param instanceof Parameter.IntegerParameter) {
                args.add(this.createOption((Parameter.IntegerParameter)param, (Integer)values.get(param.getId())));
                continue;
            }
            if (param instanceof Parameter.DecimalParameter) {
                args.add(this.createOption((Parameter.DecimalParameter)param, (Double)values.get(param.getId())));
                continue;
            }
            if (param instanceof Parameter.TextParameter) {
                args.add(this.createOption((Parameter.TextParameter)param, (String)values.get(param.getId())));
                continue;
            }
            if (param instanceof Parameter.FlagParameter) {
                args.add(this.createOption((Parameter.FlagParameter)param, (Boolean)values.get(param.getId())));
                continue;
            }
            if (param instanceof Parameter.ChoiceParameter) {
                Object ovalue = values.get(param.getId());
                List<String> lvalue = null;
                if (param.isArray()) {
                    lvalue = (List<String>)ovalue;
                } else if (ovalue != null) {
                    lvalue = List.of((String)ovalue);
                }
                args.addAll(this.createChoiceOptions((Parameter.ChoiceParameter)param, lvalue));
                continue;
            }
            if (param instanceof Parameter.FileParameter) continue;
            args.add(this.createOption(param, values.get(param.getId())));
        }
        return args;
    }

    private Option createOption(Parameter.IntegerParameter param, Integer value) {
        IntegerParameter.Builder builder = IntegerParameter.newBuilder();
        this.setCommonProperties((Parameter)param, builder);
        builder.setDefaultValue((Integer)param.getDefault());
        builder.setValue(value);
        builder.setBounds(param.getMin(), param.getMax());
        return builder.build();
    }

    private Option createOption(Parameter.DecimalParameter param, Double value) {
        DoubleParameter.Builder builder = DoubleParameter.newBuilder();
        this.setCommonProperties((Parameter)param, builder);
        builder.setDefaultValue((Double)param.getDefault());
        builder.setValue(value);
        builder.setBounds(param.getMin(), param.getMax());
        return builder.build();
    }

    private Option createOption(Parameter.TextParameter param, String value) {
        StringParameter.Builder builder = StringParameter.newBuilder();
        this.setCommonProperties((Parameter)param, builder);
        builder.setDefaultValue((String)param.getDefault());
        builder.setValue(value);
        return builder.build();
    }

    private Option createOption(Parameter.FlagParameter param, Boolean value) {
        BooleanOption.Builder builder = BooleanOption.newBuilder();
        this.setCommonProperties((Parameter)param, builder);
        builder.setDefaultValue((Boolean)param.getDefault());
        builder.setValue(value);
        return builder.build();
    }

    private List<Option> createChoiceOptions(Parameter.ChoiceParameter param, List<String> value) {
        List<String> list = value = value != null ? value : Collections.emptyList();
        if (param.isArray()) {
            ArrayList<Option> options = new ArrayList<Option>();
            List selected = param.getDefault() != null ? (List)param.getDefault() : Collections.emptyList();
            int i = 0;
            BooleanOption.Builder builder = BooleanOption.newBuilder();
            this.setCommonProperties((Parameter)param, builder);
            for (String choice : param.getChoices()) {
                builder.setName(String.format("%s$%d", param.getId(), i++));
                builder.setLabel(choice);
                builder.setDefaultValue(selected.contains(choice));
                builder.setValue(value.contains(choice));
                builder.setReprValue(choice);
                options.add(builder.build());
            }
            return options;
        }
        StringParameter.Builder builder = StringParameter.newBuilder();
        this.setCommonProperties((Parameter)param, builder);
        builder.setDefaultValue((String)param.getDefault());
        if (value.size() > 0) {
            builder.setValue(value.get(0));
        }
        builder.setPossibleValues(param.getChoices());
        return List.of(builder.build());
    }

    private Option createOption(Parameter.FileParameter param, File value) {
        throw new NotImplementedError("file paramters are not implemented for slivka");
    }

    private Option createOption(Parameter param, Object value) {
        StringParameter.Builder builder = StringParameter.newBuilder();
        this.setCommonProperties(param, builder);
        if (param.getDefault() != null) {
            builder.setDefaultValue(param.getDefault().toString());
        }
        if (value != null) {
            builder.setValue(value.toString());
        }
        return builder.build();
    }

    private void setCommonProperties(Parameter param, Option.Builder builder) {
        builder.setName(param.getId());
        builder.setLabel(param.getName());
        builder.setDescription(param.getDescription());
        builder.setRequired(param.isRequired());
        try {
            builder.setDetailsUrl(this.service.getUrl().toURL());
        }
        catch (MalformedURLException e) {
            Console.warn("invalid service url " + this.service.getUrl(), e);
        }
    }
}

