/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.hmmer;

import jalview.api.AlignViewportI;
import jalview.datamodel.AlignmentI;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseAction;
import jalview.ws2.actions.BaseTask;
import jalview.ws2.actions.PollingTaskExecutor;
import jalview.ws2.actions.api.TaskEventListener;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.actions.hmmer.PhmmerTask;
import jalview.ws2.api.Credentials;
import jalview.ws2.client.api.AlignmentWebServiceClientI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

public class PhmmerAction
extends BaseAction<AlignmentI> {
    protected final AlignmentWebServiceClientI client;

    public static Builder newBuilder(AlignmentWebServiceClientI client) {
        return new Builder(client);
    }

    public PhmmerAction(Builder builder) {
        super(builder);
        this.client = builder.client;
    }

    public TaskI<AlignmentI> perform(AlignmentViewport viewport, List<ArgumentI> args, Credentials credentials, TaskEventListener<AlignmentI> handler) {
        TaskI task = this.createTask((AlignViewportI)viewport, (List)args, credentials);
        ((BaseTask)task).addTaskEventListener(handler);
        PollingTaskExecutor executor = PollingTaskExecutor.fromPool(viewport.getServiceExecutor());
        Future<?> future = executor.submit(task);
        ((BaseTask)task).setCancelAction(() -> future.cancel(true));
        return task;
    }

    public PhmmerTask createTask(AlignViewportI viewport, List<ArgumentI> args, Credentials credentials) {
        return new PhmmerTask(this.client, args, credentials, viewport.getAlignmentView(true));
    }

    @Override
    public boolean isActive(AlignmentViewport viewport) {
        return false;
    }

    public static class Builder
    extends BaseAction.Builder<PhmmerAction> {
        protected AlignmentWebServiceClientI client;

        private Builder(AlignmentWebServiceClientI client) {
            Objects.requireNonNull(client);
            this.client = client;
        }

        public PhmmerAction build() {
            return new PhmmerAction(this);
        }
    }
}

