/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.alignment;

import jalview.api.AlignViewportI;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseAction;
import jalview.ws2.actions.alignment.AlignmentResult;
import jalview.ws2.actions.alignment.AlignmentTask;
import jalview.ws2.api.Credentials;
import jalview.ws2.client.api.AlignmentWebServiceClientI;
import java.util.List;
import java.util.Objects;

public class AlignmentAction
extends BaseAction<AlignmentResult> {
    protected final boolean submitGaps;
    protected final AlignmentWebServiceClientI client;

    public static Builder newBuilder(AlignmentWebServiceClientI client) {
        return new Builder(client);
    }

    public AlignmentAction(Builder builder) {
        super(builder);
        this.submitGaps = builder.submitGaps;
        this.client = builder.client;
    }

    public AlignmentTask createTask(AlignViewportI viewport, List<ArgumentI> args, Credentials credentials) {
        return new AlignmentTask(this.client, this, args, credentials, viewport, this.submitGaps);
    }

    @Override
    public boolean isActive(AlignmentViewport viewport) {
        return false;
    }

    public static class Builder
    extends BaseAction.Builder<AlignmentAction> {
        protected AlignmentWebServiceClientI client;
        protected boolean submitGaps = false;

        public Builder(AlignmentWebServiceClientI client) {
            Objects.requireNonNull(client);
            this.client = client;
        }

        public void submitGaps(boolean val) {
            this.submitGaps = val;
        }

        public AlignmentAction build() {
            return new AlignmentAction(this);
        }
    }
}

