/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions;

import jalview.ws2.actions.api.TaskI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PollingTaskExecutor {
    private static final Map<ScheduledExecutorService, PollingTaskExecutor> executorPool = Collections.synchronizedMap(new WeakHashMap());
    private final ScheduledExecutorService executor;

    public static PollingTaskExecutor fromPool(ScheduledExecutorService executor) {
        return executorPool.computeIfAbsent(executor, PollingTaskExecutor::new);
    }

    public PollingTaskExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public Future<?> submit(TaskI<?> task) {
        Objects.requireNonNull(task);
        return this.executor.scheduleWithFixedDelay(new TaskRunnable(task), 0L, 2L, TimeUnit.SECONDS);
    }

    private static class TaskRunnable
    implements Runnable {
        private final TaskI<?> task;
        private static final int STAGE_INIT = 0;
        private static final int STAGE_POLLING = 2;
        private static final int STAGE_FINISHED = 3;
        private static final int STAGE_STOPPED = 4;
        private int stage = 0;
        private static final int MAX_POLL_RETRY = 5;
        private int pollRetryCount = 0;

        private TaskRunnable(TaskI<?> task) {
            this.task = task;
        }

        @Override
        public void run() {
            block9: {
                if (this.task.getStatus().isDone()) {
                    this.stage = 4;
                }
                if (this.stage == 0) {
                    try {
                        this.task.init();
                        this.stage = 2;
                    }
                    catch (Exception e) {
                        this.stage = 4;
                        throw new CompletionException(e);
                    }
                }
                try {
                    if (this.stage == 2 && this.task.poll()) {
                        this.stage = 3;
                    }
                    if (this.stage == 3) {
                        this.task.complete();
                        this.stage = 4;
                    }
                }
                catch (Exception e) {
                    if (++this.pollRetryCount <= 5 && !(e instanceof RuntimeException)) break block9;
                    this.task.cancel();
                    this.stage = 4;
                    throw new CompletionException(e);
                }
            }
            if (this.stage == 4) {
                throw new CancellationException();
            }
        }
    }
}

