/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.slivkaws;

import jalview.api.FeatureColourI;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.io.AnnotationFile;
import jalview.io.DataSourceType;
import jalview.io.FeaturesFile;
import jalview.util.MessageManager;
import jalview.ws.api.JobId;
import jalview.ws.api.SequenceAnnotationServiceI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import jalview.ws.slivkaws.SlivkaWSInstance;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import uk.ac.dundee.compbio.slivkaclient.RemoteFile;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

public class SlivkaAnnotationServiceInstance
extends SlivkaWSInstance
implements SequenceAnnotationServiceI {
    public SlivkaAnnotationServiceInstance(SlivkaClient client, SlivkaService service, String category) {
        super(client, service, category);
        if (category == "Conservation") {
            this.setAlignAnalysisUI(new AlignAnalysisUIText(this.getName(), SlivkaAnnotationServiceInstance.class, "Slivka.AACons", false, true, true, true, true, 2, MessageManager.getString("label.aacon_calculations"), MessageManager.getString("tooltip.aacon_calculations"), MessageManager.getString("label.aacon_settings"), MessageManager.getString("tooltip.aacon_settings")));
        }
        this.style = ServiceWithParameters.ServiceClient.SEQUENCEANNOTATIONWSCLIENT;
    }

    @Override
    public JobId submitToService(List<SequenceI> seqs, WsParamSetI preset, List<ArgumentI> paramset) throws Throwable {
        return super.submit(seqs, preset, paramset);
    }

    @Override
    public List<AlignmentAnnotation> getAnnotationResult(JobId jobId, List<SequenceI> seqs, Map<String, FeatureColourI> featureColours, Map<String, FeatureMatcherSetI> featureFilters) throws Throwable {
        RemoteFile annotFile = null;
        RemoteFile featFile = null;
        try {
            Collection files = this.client.fetchFilesList(jobId.getJobId());
            for (RemoteFile f : files) {
                if (f.getMediaType().equals("application/jalview-annotations")) {
                    annotFile = f;
                    continue;
                }
                if (!f.getMediaType().equals("application/jalview-features")) continue;
                featFile = f;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Alignment aln = new Alignment(seqs.toArray(new SequenceI[0]));
        if (annotFile == null || !new AnnotationFile().readAnnotationFileWithCalcId(aln, this.service.getId(), annotFile.getContentUrl().toString(), DataSourceType.URL)) {
            Console.debug("No annotation from slivka job\n" + annotFile);
        } else {
            Console.debug("Annotation file loaded " + annotFile);
        }
        if (featFile == null || !new FeaturesFile(featFile.getContentUrl().toString(), DataSourceType.URL).parse(aln, featureColours, true)) {
            Console.debug("No features from slivka job\n" + featFile);
        } else {
            Console.debug("Features feil loaded " + featFile);
        }
        return Arrays.asList(aln.getAlignmentAnnotation());
    }
}

