/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.params.simple;

import jalview.ws.params.OptionI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Option
implements OptionI {
    String name;
    String label;
    String value;
    String defvalue;
    String description;
    List<String> possibleVals;
    List<String> displayVals;
    boolean required;
    URL fdetails;

    public static Builder newBuilder() {
        return new Builder();
    }

    protected Option(Builder builder) {
        Objects.requireNonNull(builder.name);
        this.name = builder.name;
        this.label = builder.label != null ? builder.label : this.name;
        this.description = builder.description;
        this.required = builder.required;
        this.defvalue = builder.defaultValue;
        this.value = builder.value;
        if (builder.possibleValues != null) {
            this.possibleVals = new ArrayList<String>(builder.possibleValues);
        }
        this.displayVals = builder.displayValues != null ? new ArrayList<String>(builder.displayValues) : this.possibleVals;
        if (this.possibleVals == null && this.displayVals != null) {
            throw new IllegalArgumentException("cannot use displayValues if possibleValues is null");
        }
        if (this.possibleVals != null && this.possibleVals.size() != this.displayVals.size()) {
            throw new IllegalArgumentException("displayValues size does not match possibleValues");
        }
        this.fdetails = builder.detailsUrl;
    }

    public Option(Option opt) {
        this.name = opt.name;
        this.label = opt.label;
        this.value = opt.value;
        this.defvalue = opt.defvalue;
        this.description = opt.description;
        if (opt.possibleVals != null) {
            this.possibleVals = new ArrayList<String>(opt.possibleVals);
        }
        this.required = opt.required;
        this.fdetails = opt.fdetails;
    }

    public Option() {
    }

    public Option(String name, String description, String label, boolean isrequired, String defValue, String val, List<String> possibleVals, URL fdetails) {
        this(name, description, isrequired, defValue, val, possibleVals, fdetails);
        this.label = label;
    }

    public Option(String name2, String description2, boolean isrequired, String defValue, String val, List<String> possibleVals, List<String> displayNames, URL fdetails) {
        this.name = name2;
        this.description = description2;
        this.value = val;
        this.required = isrequired;
        this.defvalue = defValue;
        if (possibleVals != null) {
            this.possibleVals = new ArrayList<String>(possibleVals);
        }
        if (displayNames != null) {
            this.displayVals = new ArrayList<String>(displayNames);
        }
        this.fdetails = fdetails;
    }

    public Option(String name2, String description2, boolean isrequired, String defValue, String val, List<String> possibleVals, URL fdetails) {
        this(name2, description2, isrequired, defValue, val, possibleVals, null, fdetails);
    }

    @Override
    public OptionI copy() {
        Option opt = new Option(this);
        return opt;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label != null ? this.label : this.name;
    }

    @Override
    public String getValue() {
        return this.value == null ? this.defvalue : this.value;
    }

    @Override
    public void setValue(String selectedItem) {
        this.value = selectedItem;
    }

    @Override
    public URL getFurtherDetails() {
        return this.fdetails;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getPossibleValues() {
        return this.possibleVals;
    }

    @Override
    public List<String> getDisplayNames() {
        return this.displayVals;
    }

    public static class Builder {
        protected String name = null;
        protected String label = null;
        protected String description = "";
        protected boolean required = false;
        protected String defaultValue = null;
        protected String value = null;
        protected List<String> possibleValues = null;
        protected List<String> displayValues = null;
        protected URL detailsUrl = null;

        public void setName(String name) {
            this.name = name;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setPossibleValues(List<String> possibleValues) {
            this.possibleValues = possibleValues;
        }

        public void setDisplayValues(List<String> displayValues) {
            this.displayValues = displayValues;
        }

        public void setDetailsUrl(URL detailsUrl) {
            this.detailsUrl = detailsUrl;
        }

        public Option build() {
            return new Option(this);
        }
    }
}

