/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.params.simple;

import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParameterI;
import jalview.ws.params.ValueConstrainI;
import jalview.ws.params.simple.Option;

public class IntegerParameter
extends Option
implements ParameterI {
    int defval;
    int min;
    int max;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public ValueConstrainI getValidValue() {
        return new ValueConstrainI(){

            @Override
            public ValueConstrainI.ValueType getType() {
                return ValueConstrainI.ValueType.Integer;
            }

            @Override
            public Number getMin() {
                return IntegerParameter.this.min < IntegerParameter.this.max ? Integer.valueOf(IntegerParameter.this.min) : null;
            }

            @Override
            public Number getMax() {
                return IntegerParameter.this.min < IntegerParameter.this.max ? Integer.valueOf(IntegerParameter.this.max) : null;
            }
        };
    }

    protected IntegerParameter(Builder builder) {
        super(builder);
        this.min = builder.min;
        this.max = builder.max;
        if (this.defvalue != null) {
            this.defval = Integer.parseInt(this.defvalue);
        }
    }

    public IntegerParameter(IntegerParameter parm) {
        super(parm);
        this.max = parm.max;
        this.min = parm.min;
    }

    public IntegerParameter(String name, String description, boolean required, int defValue, int min, int max) {
        super(name, description, required, String.valueOf(defValue), null, null, null);
        this.defval = defValue;
        this.min = min;
        this.max = max;
    }

    public IntegerParameter(String name, String description, boolean required, int defValue, int value, int min, int max) {
        super(name, description, required, String.valueOf(defValue), String.valueOf(value), null, null);
        this.defval = defValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public IntegerParameter copy() {
        return new IntegerParameter(this);
    }

    public static Integer parseInt(ArgumentI arg) {
        return arg.getValue() != null && !arg.getValue().isEmpty() ? Integer.valueOf(Integer.parseInt(arg.getValue())) : null;
    }

    public static class Builder
    extends Option.Builder {
        protected int min = Integer.MAX_VALUE;
        protected int max = Integer.MIN_VALUE;

        @Override
        public void setDefaultValue(String defaultValue) {
            throw new UnsupportedOperationException();
        }

        public void setDefaultValue(Integer defaultValue) {
            if (defaultValue != null) {
                super.setDefaultValue(defaultValue.toString());
            } else {
                super.setDefaultValue(null);
            }
        }

        @Override
        public void setValue(String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Integer value) {
            if (value != null) {
                super.setValue(value.toString());
            } else {
                super.setValue(null);
            }
        }

        public void setMin(Integer min) {
            this.min = min != null ? min : Integer.MAX_VALUE;
        }

        public void setMax(Integer max) {
            this.max = max != null ? max : Integer.MIN_VALUE;
        }

        public void setBounds(Integer min, Integer max) {
            this.setMin(min);
            this.setMax(max);
        }

        @Override
        public IntegerParameter build() {
            return new IntegerParameter(this);
        }
    }
}

