/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.params.simple;

import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParameterI;
import jalview.ws.params.ValueConstrainI;
import jalview.ws.params.simple.Option;

public class DoubleParameter
extends Option
implements ParameterI {
    double defval;
    double min;
    double max;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public ValueConstrainI getValidValue() {
        return new ValueConstrainI(){

            @Override
            public ValueConstrainI.ValueType getType() {
                return ValueConstrainI.ValueType.Double;
            }

            @Override
            public Number getMin() {
                return DoubleParameter.this.min < DoubleParameter.this.max ? Double.valueOf(DoubleParameter.this.min) : null;
            }

            @Override
            public Number getMax() {
                return DoubleParameter.this.min < DoubleParameter.this.max ? Double.valueOf(DoubleParameter.this.max) : null;
            }
        };
    }

    protected DoubleParameter(Builder builder) {
        super(builder);
        this.min = builder.min;
        this.max = builder.max;
        if (this.defvalue != null) {
            this.defval = Double.parseDouble(this.defvalue);
        }
    }

    public DoubleParameter(DoubleParameter parm) {
        super(parm);
        this.max = parm.max;
        this.min = parm.min;
    }

    public DoubleParameter(String name, String description, boolean required, Double defValue, double min, double max) {
        super(name, description, required, String.valueOf(defValue), null, null, null);
        this.defval = defValue;
        this.min = min;
        this.max = max;
    }

    public DoubleParameter(String name, String description, boolean required, Double defValue, Double value, double min, double max) {
        super(name, description, required, String.valueOf(defValue), String.valueOf(value), null, null);
        this.defval = defValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public DoubleParameter copy() {
        return new DoubleParameter(this);
    }

    public static Double parseDouble(ArgumentI arg) {
        return arg.getValue() != null && !arg.getValue().isEmpty() ? Double.valueOf(Double.parseDouble(arg.getValue())) : null;
    }

    public static Float parseFloat(ArgumentI arg) {
        return arg.getValue() != null && !arg.getValue().isEmpty() ? Float.valueOf(Float.parseFloat(arg.getValue())) : null;
    }

    public static class Builder
    extends Option.Builder {
        protected double min = Double.POSITIVE_INFINITY;
        protected double max = Double.NEGATIVE_INFINITY;

        @Override
        public void setValue(String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Double value) {
            if (value != null) {
                super.setValue(value.toString());
            } else {
                super.setValue(null);
            }
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            throw new UnsupportedOperationException();
        }

        public void setDefaultValue(Double defaultValue) {
            if (defaultValue != null) {
                super.setDefaultValue(defaultValue.toString());
            } else {
                super.setDefaultValue(null);
            }
        }

        public void setMin(Double min) {
            this.min = min != null ? min : Double.POSITIVE_INFINITY;
        }

        public void setMax(Double max) {
            this.max = max != null ? max : Double.NEGATIVE_INFINITY;
        }

        public void setBounds(Double min, Double max) {
            this.setMin(min);
            this.setMax(max);
        }

        @Override
        public DoubleParameter build() {
            return new DoubleParameter(this);
        }
    }
}

