/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.params;

import jalview.util.MessageManager;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.util.ArrayList;
import java.util.List;

public class AutoCalcSetting {
    protected boolean autoUpdate;
    protected WsParamSetI preset;
    protected List<ArgumentI> jobArgset;
    protected ServiceWithParameters service;

    public AutoCalcSetting(ServiceWithParameters service2, WsParamSetI preset2, List<ArgumentI> jobArgset2, boolean autoUpdate2) {
        this.service = service2;
        this.autoUpdate = autoUpdate2;
        this.preset = preset2;
        this.jobArgset = jobArgset2;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public WsParamSetI getPreset() {
        return this.preset;
    }

    public void setPreset(WsParamSetI preset) {
        this.preset = preset;
    }

    public List<ArgumentI> getArgumentSet() {
        return this.jobArgset;
    }

    public String getServiceURI() {
        return this.service.getNameURI();
    }

    public String[] getServiceURLs() {
        return new String[]{this.service.getUri()};
    }

    public String getWsParamFile() {
        List<ArgumentI> opts = null;
        if (this.jobArgset != null) {
            opts = this.jobArgset;
        } else if (this.preset != null) {
            opts = this.preset.getArguments();
        }
        if (opts == null || opts.size() == 0) {
            return "";
        }
        StringBuffer pset = new StringBuffer();
        for (ArgumentI ps : opts) {
            pset.append(ps.getName() + "\t" + ps.getValue());
            pset.append("\n");
        }
        return pset.toString();
    }

    public ServiceWithParameters getService() {
        return this.service;
    }

    public void setService(ServiceWithParameters service) {
        this.service = service;
        if (this.preset != null) {
            for (String url : this.preset.getApplicableUrls()) {
                if (!url.equals(service.getUri())) continue;
                return;
            }
            WsParamSetI pr = service.getParamStore().getPreset(this.preset.getName());
            ArrayList<ArgumentI> oldargs = new ArrayList<ArgumentI>();
            ArrayList<ArgumentI> newargs = new ArrayList<ArgumentI>();
            oldargs.addAll(this.preset.getArguments());
            for (ArgumentI newparg : pr.getArguments()) {
                if (oldargs.remove(newparg)) continue;
                newargs.add(newparg);
            }
            if (oldargs.size() == 0 && newargs.size() == 0) {
                this.preset = pr;
                return;
            }
            throw new Error(MessageManager.getString("error.parameter_migration_not_implemented_yet"));
        }
    }
}

