/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Score;
import compbio.data.sequence.ScoreManager;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.WrongParameterException;
import jalview.api.FeatureColourI;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.util.MessageManager;
import jalview.ws.api.JobId;
import jalview.ws.api.SequenceAnnotationServiceI;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.jabaws2.JabawsServiceInstance;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class JabawsAnnotationInstance
extends JabawsServiceInstance<SequenceAnnotation>
implements SequenceAnnotationServiceI {
    protected ScoreManager scoremanager = null;

    public JabawsAnnotationInstance(Jws2Instance handle) {
        super(handle);
    }

    public String getCalcId() {
        return this.our.getAlignAnalysisUI() == null ? null : this.our.getAlignAnalysisUI().getCalcId();
    }

    @Override
    public JobId submitToService(List<SequenceI> seqs, WsParamSetI preset, List<ArgumentI> arguments) throws Throwable {
        String rslt = null;
        this.scoremanager = null;
        ArrayList<FastaSequence> jabaseqs = new ArrayList<FastaSequence>(seqs.size());
        for (SequenceI seq : seqs) {
            jabaseqs.add(new FastaSequence(seq.getName(), seq.getSequenceAsString()));
        }
        if (preset == null && arguments == null) {
            rslt = ((SequenceAnnotation)this.service).analize(jabaseqs);
        }
        if (preset != null) {
            rslt = preset instanceof JabaPreset ? ((SequenceAnnotation)this.service).presetAnalize(jabaseqs, ((JabaPreset)preset).getJabaPreset()) : ((SequenceAnnotation)this.service).customAnalize(jabaseqs, JabaParamStore.getJabafromJwsArgs(preset.getArguments()));
        } else if (arguments != null && arguments.size() > 0) {
            try {
                rslt = ((SequenceAnnotation)this.service).customAnalize(jabaseqs, JabaParamStore.getJabafromJwsArgs(arguments));
            }
            catch (WrongParameterException x) {
                throw new JobSubmissionException(MessageManager.getString("exception.jobsubmission_invalid_params_set"), (Throwable)x);
            }
        }
        if (rslt == null) {
            return null;
        }
        return new JobId(this.our.getServiceType(), this.our.getName(), rslt);
    }

    @Override
    public List<AlignmentAnnotation> getAnnotationResult(JobId job, List<SequenceI> seqs, Map<String, FeatureColourI> featureColours, Map<String, FeatureMatcherSetI> featureFilters) throws Throwable {
        if (this.scoremanager == null) {
            this.scoremanager = ((SequenceAnnotation)this.service).getAnnotation(job.getJobId());
        }
        if (this.scoremanager == null) {
            return List.of();
        }
        Alignment newal = new Alignment(seqs.toArray(new SequenceI[0]));
        List<AlignmentAnnotation> ourAnnot = this.annotationFromScoreManager(newal, featureColours, featureFilters);
        return ourAnnot;
    }

    abstract List<AlignmentAnnotation> annotationFromScoreManager(AlignmentI var1, Map<String, FeatureColourI> var2, Map<String, FeatureMatcherSetI> var3);

    protected void createAnnotationRowsForScores(AlignmentI al_result, boolean[] gapMap, List<AlignmentAnnotation> ourAnnot, String calcId, int alWidth, Score scr) {
        AlignmentAnnotation annotation = al_result.findOrCreateAnnotation(scr.getMethod(), calcId, true, null, null);
        if (gapMap == null || alWidth == gapMap.length) {
            this.constructAnnotationFromScore(gapMap, annotation, 0, alWidth, scr);
            ourAnnot.add(annotation);
        }
    }

    protected AlignmentAnnotation createAnnotationRowsForScores(AlignmentI alignment, boolean[] gapMap, List<AlignmentAnnotation> ourAnnot, String typeName, String calcId, SequenceI dseq, int base, Score scr) {
        System.out.println("Creating annotation on dseq:" + dseq.getStart() + " base is " + base + " and length=" + dseq.getLength() + " == " + scr.getScores().size());
        AlignmentAnnotation annotation = alignment.findOrCreateAnnotation(typeName, calcId, false, dseq, null);
        this.constructAnnotationFromScore(gapMap, annotation, 0, dseq.getLength(), scr);
        annotation.createSequenceMapping(dseq, base, false);
        annotation.adjustForAlignment();
        dseq.addAlignmentAnnotation(annotation);
        ourAnnot.add(annotation);
        return annotation;
    }

    protected void constructAnnotationFromScore(boolean[] gapMap, AlignmentAnnotation annotation, int base, int alWidth, Score scr) {
        Annotation[] elm = new Annotation[alWidth];
        Iterator vals = scr.getScores().iterator();
        float m = 0.0f;
        float x = 0.0f;
        int i = 0;
        while (vals.hasNext()) {
            float val = ((Float)vals.next()).floatValue();
            if (i == 0) {
                m = val;
                x = val;
            } else {
                if (m > val) {
                    m = val;
                }
                if (x < val) {
                    x = val;
                }
            }
            if (gapMap != null && gapMap.length > 0) {
                while (i < gapMap.length && !gapMap[i]) {
                    elm[i++] = new Annotation("", "", ' ', Float.NaN);
                }
            }
            elm[i] = new Annotation("", "" + val, ' ', val);
            ++i;
        }
        annotation.annotations = elm;
        annotation.belowAlignment = true;
        if (x < 0.0f) {
            x = 0.0f;
        }
        annotation.graphMax = x = (float)((double)x + (double)(x - m) * 0.1);
        annotation.graphMin = m;
        annotation.validateRangeAndDisplay();
    }
}

