/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.util.QuickSort;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.api.UIinfo;
import jalview.ws.jws2.PreferredServiceChangeListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PreferredServiceRegistry {
    private static PreferredServiceRegistry us = new PreferredServiceRegistry();
    List<ServiceWithParameters> ourServices = new ArrayList<ServiceWithParameters>();
    Map<String, Map<String, String>> preferredServiceMap = new HashMap<String, Map<String, String>>();

    public static PreferredServiceRegistry getRegistry() {
        if (us == null) {
            us = new PreferredServiceRegistry();
        }
        return us;
    }

    public void clearServices() {
        this.ourServices.clear();
    }

    public void populateWSMenuEntry(List<ServiceWithParameters> services, PreferredServiceChangeListener changeListener, JMenu menu, AlignFrame alignFrame, String typeFilter) {
        this.ourServices.addAll(services);
        ArrayList<ServiceWithParameters> oneshotServices = new ArrayList<ServiceWithParameters>();
        ArrayList<ServiceWithParameters> interactiveServices = new ArrayList<ServiceWithParameters>();
        HashMap<String, ServiceWithParameters> preferredHosts = new HashMap<String, ServiceWithParameters>();
        HashMap<String, List> alternates = new HashMap<String, List>();
        for (ServiceWithParameters service : services) {
            if (service.isInteractiveUpdate()) {
                interactiveServices.add(service);
                continue;
            }
            oneshotServices.add(service);
        }
        for (ServiceWithParameters service : interactiveServices) {
            if (!preferredHosts.containsKey(service.getName())) {
                ServiceWithParameters preferred = this.getPreferredServiceFor(alignFrame, service.getName());
                preferredHosts.put(service.getName(), preferred != null ? preferred : service);
            }
            List ph = alternates.getOrDefault(service.getName(), new ArrayList());
            if (preferredHosts.containsValue(service)) continue;
            ph.add(service);
            alternates.putIfAbsent(service.getName(), ph);
        }
        this.addEnumeratedServices(menu, alignFrame, oneshotServices);
        for (ServiceWithParameters service : preferredHosts.values()) {
            JMenu atpoint = JvSwingUtils.findOrCreateMenu(menu, service.getServiceType());
            if (atpoint.getItemCount() > 1) {
                atpoint.addSeparator();
            }
            JMenuItem hitm = new JMenuItem(service.getHostURL());
            atpoint.add(hitm);
            hitm.setForeground(Color.blue);
            hitm.addActionListener(e -> Desktop.showUrl(service.getHostURL()));
            hitm.setToolTipText(JvSwingUtils.wrapTooltip(false, MessageManager.getString("label.open_jabaws_web_page")));
            service.attachWSMenuEntry(atpoint, alignFrame);
            if (!alternates.containsKey(service.getName())) continue;
            hitm = new JMenu(MessageManager.getString("label.switch_server"));
            atpoint.add(hitm);
            hitm.setToolTipText(JvSwingUtils.wrapTooltip(false, MessageManager.getString("label.choose_jabaws_server")));
            for (ServiceWithParameters sv : (List)alternates.get(service.getName())) {
                JMenuItem itm = new JMenuItem(sv.getHostURL());
                hitm.add(itm);
                itm.setForeground(Color.blue);
                itm.addActionListener(e -> {
                    this.setPreferredServiceFor(alignFrame, sv.getName(), sv.getServiceType(), sv);
                    changeListener.preferredServiceChanged(sv);
                });
            }
        }
    }

    private void addEnumeratedServices(JMenu jws2al, AlignFrame alignFrame, List<ServiceWithParameters> enumerableServices) {
        boolean byhost = Cache.getDefault("WSMENU_BYHOST", false);
        boolean bytype = Cache.getDefault("WSMENU_BYTYPE", false);
        ArrayList<Object> hostLabels = new ArrayList<Object>();
        Hashtable<String, String> lasthostFor = new Hashtable<String, String>();
        Hashtable<String, ArrayList<ServiceWithParameters>> hosts = new Hashtable<String, ArrayList<ServiceWithParameters>>();
        ArrayList<String> hostlist = new ArrayList<String>();
        for (ServiceWithParameters service : enumerableServices) {
            ArrayList<ServiceWithParameters> hostservices = (ArrayList<ServiceWithParameters>)hosts.get(service.getHostURL());
            if (hostservices == null) {
                hostservices = new ArrayList<ServiceWithParameters>();
                hosts.put(service.getHostURL(), hostservices);
                hostlist.add(service.getHostURL());
            }
            hostservices.add(service);
        }
        for (String host : hostlist) {
            Object[] orderedsvcs = ((ArrayList)hosts.get(host)).toArray(new ServiceWithParameters[1]);
            String[] sortbytype = new String[orderedsvcs.length];
            for (int i = 0; i < sortbytype.length; ++i) {
                sortbytype[i] = ((UIinfo)orderedsvcs[i]).getName();
            }
            QuickSort.sort(sortbytype, orderedsvcs);
            for (Object service : orderedsvcs) {
                JMenu atpoint = JvSwingUtils.findOrCreateMenu(jws2al, ((UIinfo)service).getAction());
                String type = ((UIinfo)service).getName();
                if (byhost && (atpoint = JvSwingUtils.findOrCreateMenu(atpoint, host)).getToolTipText() == null) {
                    atpoint.setToolTipText(MessageManager.formatMessage("label.services_at", new String[]{host}));
                }
                if (bytype && (atpoint = JvSwingUtils.findOrCreateMenu(atpoint, type)).getToolTipText() == null) {
                    atpoint.setToolTipText(((UIinfo)service).getActionText());
                }
                if (!byhost && !hostLabels.contains(host + ((UIinfo)service).getName() + ((UIinfo)service).getActionText())) {
                    if (hostLabels.contains(host)) {
                        atpoint.addSeparator();
                    } else {
                        hostLabels.add(host);
                    }
                    if (lasthostFor.get(((UIinfo)service).getAction()) == null || !((String)lasthostFor.get(((UIinfo)service).getAction())).equals(host)) {
                        JMenuItem hitm = new JMenuItem(host);
                        atpoint.add(hitm);
                        hitm.setForeground(Color.blue);
                        hitm.addActionListener(new ActionListener((ServiceWithParameters)service){
                            final /* synthetic */ ServiceWithParameters val$service;
                            {
                                this.val$service = serviceWithParameters;
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Desktop.showUrl(this.val$service.getHostURL());
                            }
                        });
                        hitm.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.open_jabaws_web_page")));
                        lasthostFor.put(((UIinfo)service).getAction(), host);
                    }
                    hostLabels.add(host + ((UIinfo)service).getName() + ((UIinfo)service).getActionText());
                }
                ((ServiceWithParameters)service).attachWSMenuEntry(atpoint, alignFrame);
            }
        }
    }

    public ServiceWithParameters getPreferredServiceFor(String[] serviceURLs) {
        HashSet<String> urls = new HashSet<String>();
        urls.addAll(Arrays.asList(serviceURLs));
        ServiceWithParameters match = null;
        if (this.ourServices != null) {
            for (ServiceWithParameters svc : this.ourServices) {
                if (!urls.contains(svc.getNameURI())) continue;
                if (match == null) {
                    match = svc;
                }
                if (!urls.contains(svc.getUri())) continue;
                return svc;
            }
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceWithParameters getPreferredServiceFor(AlignFrame af, String serviceName) {
        String serviceurl = null;
        Map<String, Map<String, String>> map = this.preferredServiceMap;
        synchronized (map) {
            String afid = af == null ? "" : af.getViewport().getSequenceSetId();
            Map<String, String> prefmap = this.preferredServiceMap.get(afid);
            if (afid.length() > 0 && prefmap == null) {
                prefmap = this.preferredServiceMap.get("");
            }
            if (prefmap != null) {
                serviceurl = prefmap.get(serviceName);
            }
        }
        ServiceWithParameters response = null;
        for (ServiceWithParameters svc : this.ourServices) {
            if (!svc.getName().equals(serviceName) || serviceurl != null && !serviceurl.equals(svc.getHostURL())) continue;
            response = svc;
            break;
        }
        return response;
    }

    public void setPreferredServiceFor(AlignFrame af, String serviceName, String serviceAction, ServiceWithParameters selectedServer) {
        Map<String, String> prefmap;
        String afid;
        String string = afid = af == null ? "" : af.getViewport().getSequenceSetId();
        if (this.preferredServiceMap == null) {
            this.preferredServiceMap = new HashMap<String, Map<String, String>>();
        }
        if ((prefmap = this.preferredServiceMap.get(afid)) == null) {
            prefmap = new HashMap<String, String>();
            this.preferredServiceMap.put(afid, prefmap);
        }
        prefmap.put(serviceName, selectedServer.getHostURL());
        prefmap.put(serviceAction, selectedServer.getHostURL());
    }

    public void setPreferredServiceFor(String serviceType, String serviceAction, ServiceWithParameters selectedServer) {
        this.setPreferredServiceFor(null, serviceType, serviceAction, selectedServer);
    }

    public boolean contains(ServiceWithParameters service) {
        return this.ourServices.contains(service);
    }
}

