/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws1;

import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileParse;
import jalview.io.FormatAdapter;
import jalview.io.InputStreamParser;
import jalview.util.HttpUtils;
import jalview.util.MessageManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;

public class Annotate3D {
    public Annotate3D() {
        Console.outPrintln("Annotate3D");
    }

    public AlignmentI getRNAMLFor(FileParse source) throws IOException {
        try {
            StringBuffer sb = new StringBuffer();
            Reader fpr = source.getReader();
            int p = 0;
            char[] cbuff = new char[2048];
            while ((p = fpr.read(cbuff)) > 0) {
                for (int i = 0; i < p; ++i) {
                    sb.append(cbuff[i]);
                }
            }
            Iterator<Reader> r = jalview.ext.paradise.Annotate3D.getRNAMLForPDBFileAsString(sb.toString());
            AlignmentI al = null;
            while (r.hasNext()) {
                InputStreamParser fp = new InputStreamParser(r.next(), source.getDataName());
                AlignmentI nal = new FormatAdapter().readFromFile(fp, (FileFormatI)FileFormat.Rnaml);
                if (al == null) {
                    al = nal;
                    continue;
                }
                al.append(nal);
            }
            return al;
        }
        catch (Throwable x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(MessageManager.getString("exception.unexpected_handling_rnaml_translation_for_pdb"), x);
        }
    }

    public Annotate3D(String path) throws InterruptedException {
        Console.outPrintln("Annotate3D");
        try {
            String str4;
            String str;
            FileReader r = new FileReader(path);
            BufferedReader in = new BufferedReader(r);
            Object content = "";
            while ((str = in.readLine()) != null) {
                content = (String)content + str;
            }
            Console.outPrintln("pdbfile=" + ((String)content).toString());
            Console.outPrintln("capacit\u00e9=" + ((String)content).length());
            String paramfile = URLEncoder.encode(((String)content).toString(), "UTF-8");
            Console.outPrintln("param=" + paramfile);
            URL url = new URL("http://paradise-ibmc.u-strasbg.fr/webservices/annotate3d?data=" + (String)content);
            BufferedReader is = new BufferedReader(new InputStreamReader(HttpUtils.openStream(url)));
            while ((str4 = is.readLine()) != null) {
                Console.outPrintln(str4);
            }
            in.close();
            is.close();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

