/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel;

import jalview.analysis.PaSiMap;
import jalview.api.RotatableCanvasI;
import jalview.api.analysis.ScoreModelI;
import jalview.datamodel.Point;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import jalview.gui.PairwiseAlignPanel;
import jalview.viewmodel.AlignmentViewport;
import java.util.List;
import java.util.Vector;

public class PaSiMapModel {
    private AlignmentViewport inputData;
    private final SequenceI[] seqs;
    private ScoreModelI scoreModel;
    private boolean nucleotide = false;
    private PaSiMap pasimap;
    int top;
    private List<SequencePoint> points;

    public PaSiMapModel(AlignmentViewport seqData, SequenceI[] sqs, boolean nuc, ScoreModelI modelName) {
        this.inputData = seqData;
        this.seqs = sqs;
        this.nucleotide = nuc;
        this.scoreModel = modelName;
    }

    public void calculate(PairwiseAlignPanel pap) {
        this.pasimap = new PaSiMap(this.inputData, this.scoreModel, pap);
        this.pasimap.run();
        if (this.pasimap.isCancelled()) {
            return;
        }
        for (int ii = 0; ii < this.seqs.length && this.seqs[ii] != null; ++ii) {
        }
        int width = this.pasimap.getWidth();
        int height = this.pasimap.getHeight();
        this.top = width;
        this.points = new Vector<SequencePoint>();
        Point[] scores = this.pasimap.getComponents(width - 1, width - 2, width - 3, 1.0f);
        for (int i = 0; i < height; ++i) {
            SequencePoint sp = new SequencePoint(this.seqs[i], scores[i]);
            this.points.add(sp);
        }
    }

    public void updateRc(RotatableCanvasI rc) {
        rc.setPoints(this.points, this.pasimap.getHeight());
    }

    public boolean isNucleotide() {
        return this.nucleotide;
    }

    public void setNucleotide(boolean nucleotide) {
        this.nucleotide = nucleotide;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int t) {
        this.top = t;
    }

    public void updateRcView(int dim1, int dim2, int dim3) {
        Point[] scores = this.pasimap.getComponents(dim1 - 1, dim2 - 1, dim3 - 1, 1.0f);
        for (int i = 0; i < this.pasimap.getHeight(); ++i) {
            this.points.get((int)i).coord = scores[i];
        }
    }

    public String getDetails() {
        return this.pasimap.getDetails();
    }

    public String getAlignmentOutput() {
        return this.pasimap.getAlignmentOutput();
    }

    public AlignmentViewport getInputData() {
        return this.inputData;
    }

    public void setInputData(AlignmentViewport data) {
        this.inputData = data;
    }

    public String getPointsasCsv(boolean transformed, int xdim, int ydim, int zdim) {
        StringBuffer csv = new StringBuffer();
        csv.append("\"Sequence\"");
        if (transformed) {
            csv.append(",");
            csv.append(xdim);
            csv.append(",");
            csv.append(ydim);
            csv.append(",");
            csv.append(zdim);
        } else {
            int dmax = this.pasimap.getDim();
            for (int d = 1; d <= dmax; ++d) {
                csv.append("," + d);
            }
        }
        csv.append("\n");
        for (int s = 0; s < this.seqs.length; ++s) {
            csv.append("\"" + this.seqs[s].getName() + "\"");
            if (!transformed) {
                double[] fl = this.pasimap.component(s);
                for (int d = fl.length - 1; d >= 0; --d) {
                    csv.append(",");
                    csv.append(fl[d]);
                }
            } else {
                Point p = this.points.get((int)s).coord;
                csv.append(",").append(p.x);
                csv.append(",").append(p.y);
                csv.append(",").append(p.z);
            }
            csv.append("\n");
        }
        return csv.toString();
    }

    public String getScoreModelName() {
        return this.scoreModel == null ? "" : this.scoreModel.getName();
    }

    public void setScoreModel(ScoreModelI sm) {
        this.scoreModel = sm;
    }

    public List<SequencePoint> getSequencePoints() {
        return this.points;
    }

    public void setSequencePoints(List<SequencePoint> sp) {
        this.points = sp;
    }

    public PaSiMap getPasimapData() {
        return this.pasimap;
    }

    public void setPaSiMap(PaSiMap data) {
        this.pasimap = data;
    }

    public boolean isCancelled() {
        return this.pasimap == null || this.pasimap.isCancelled();
    }

    public void cancel() {
        this.pasimap.cancel();
    }

    public boolean canCancel() {
        return !this.isCancelled() && this.pasimap.isCancellable();
    }
}

