/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel;

import jalview.api.AlignmentColsCollectionI;
import jalview.api.AlignmentRowsCollectionI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AllColsCollection;
import jalview.datamodel.AllRowsCollection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.viewmodel.OverviewDimensions;
import jalview.viewmodel.ViewportRanges;
import java.awt.Dimension;

public class OverviewDimensionsShowHidden
extends OverviewDimensions {
    private ViewportRanges ranges;
    private int xdiff;
    private int ydiff;

    @Deprecated
    public OverviewDimensionsShowHidden(ViewportRanges vpranges, boolean showAnnotationPanel) {
        this(vpranges, showAnnotationPanel, null);
    }

    public OverviewDimensionsShowHidden(ViewportRanges vpranges, boolean showAnnotationPanel, Dimension dim) {
        super(vpranges, showAnnotationPanel, dim);
        this.ranges = vpranges;
        this.resetAlignmentDims();
    }

    @Override
    public void updateViewportFromMouse(int mousex, int mousey, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        this.resetAlignmentDims();
        int xAsRes = this.getLeftXFromCentreX(mousex, hiddenCols);
        int yAsSeq = this.getTopYFromCentreY(mousey, hiddenSeqs);
        int visXAsRes = hiddenCols.absoluteToVisibleColumn(xAsRes);
        yAsSeq = hiddenSeqs.adjustForHiddenSeqs(hiddenSeqs.findIndexWithoutHiddenSeqs(yAsSeq));
        yAsSeq = Math.max(yAsSeq, 0);
        int visYAsSeq = hiddenSeqs.findIndexWithoutHiddenSeqs(yAsSeq);
        visYAsSeq = Math.max(visYAsSeq, 0);
        this.updateViewportFromTopLeft(visXAsRes, visYAsSeq, hiddenSeqs, hiddenCols);
    }

    @Override
    public void adjustViewportFromMouse(int mousex, int mousey, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        this.resetAlignmentDims();
        int vpx = Math.round((float)mousex * (float)this.alwidth / (float)this.width);
        int visXAsRes = hiddenCols.absoluteToVisibleColumn(vpx) + this.xdiff;
        int vpy = Math.round((float)mousey * this.heightRatio);
        int visYAsRes = hiddenSeqs.findIndexWithoutHiddenSeqs(vpy) + this.ydiff;
        this.updateViewportFromTopLeft(visXAsRes, visYAsRes, hiddenSeqs, hiddenCols);
    }

    @Override
    protected void updateViewportFromTopLeft(int leftx, int topy, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        int visAlignHeight;
        int vpheight;
        int visAlignWidth;
        int vpwidth;
        int visXAsRes = leftx;
        int visYAsSeq = topy;
        if (visXAsRes < 0) {
            visXAsRes = 0;
        }
        if (visYAsSeq < 0) {
            visYAsSeq = 0;
        }
        if (this.ranges.isWrappedMode()) {
            visYAsSeq = 0;
        }
        if (visXAsRes + (vpwidth = this.ranges.getViewportWidth()) - 1 > (visAlignWidth = hiddenCols.absoluteToVisibleColumn(this.alwidth - 1))) {
            visXAsRes = this.ranges.getEndRes() < visAlignWidth ? hiddenCols.absoluteToVisibleColumn(hiddenCols.offsetByVisibleColumns(-(vpwidth - 1), this.alwidth - 1)) : this.ranges.getStartRes();
        }
        if (visYAsSeq + (vpheight = this.ranges.getViewportHeight()) - 1 > (visAlignHeight = hiddenSeqs.findIndexWithoutHiddenSeqs(this.alheight))) {
            visYAsSeq = this.ranges.getEndSeq() < visAlignHeight ? hiddenSeqs.findIndexWithoutHiddenSeqs(hiddenSeqs.subtractVisibleRows(vpheight - 1, this.alheight - 1)) : this.ranges.getStartSeq();
        }
        this.ranges.setStartResAndSeq(visXAsRes, visYAsSeq);
    }

    @Override
    public void setBoxPosition(HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        int startRes = hiddenCols.visibleToAbsoluteColumn(this.ranges.getStartRes());
        int endRes = hiddenCols.visibleToAbsoluteColumn(this.ranges.getEndRes());
        int startSeq = hiddenSeqs.adjustForHiddenSeqs(this.ranges.getStartSeq());
        int endSeq = hiddenSeqs.adjustForHiddenSeqs(this.ranges.getEndSeq());
        this.setBoxPosition(startRes, startSeq, endRes - startRes + 1, endSeq - startSeq + 1);
    }

    @Override
    public AlignmentColsCollectionI getColumns(AlignmentI al) {
        return new AllColsCollection(0, this.ranges.getAbsoluteAlignmentWidth() - 1, al);
    }

    @Override
    public AlignmentRowsCollectionI getRows(AlignmentI al) {
        return new AllRowsCollection(0, this.ranges.getAbsoluteAlignmentHeight() - 1, al);
    }

    @Override
    protected void resetAlignmentDims() {
        this.alwidth = this.ranges.getAbsoluteAlignmentWidth();
        this.alheight = this.ranges.getAbsoluteAlignmentHeight();
        this.widthRatio = (float)this.alwidth / (float)this.width;
        this.heightRatio = (float)this.alheight / (float)this.sequencesHeight;
    }

    @Override
    protected int getLeftXFromCentreX(int mousex, HiddenColumns hidden) {
        int vpx = Math.round((float)mousex * (float)this.alwidth / (float)this.width);
        return hidden.offsetByVisibleColumns(-this.ranges.getViewportWidth() / 2, vpx);
    }

    @Override
    protected int getTopYFromCentreY(int mousey, HiddenSequences hidden) {
        int vpy = Math.round((float)mousey * this.heightRatio);
        return hidden.subtractVisibleRows(this.ranges.getViewportHeight() / 2, vpy);
    }

    @Override
    public void setDragPoint(int x, int y, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        this.resetAlignmentDims();
        int vpx = Math.round((float)x * this.widthRatio);
        int vpy = Math.round((float)y * this.heightRatio);
        this.xdiff = this.ranges.getStartRes() - hiddenCols.absoluteToVisibleColumn(vpx);
        this.ydiff = this.ranges.getStartSeq() - hiddenSeqs.findIndexWithoutHiddenSeqs(vpy);
    }
}

